/*
 * Decompiled with CFR 0.152.
 */
package de.canitzp.feederhelmet;

import de.canitzp.feederhelmet.FeederHelmet;
import de.canitzp.feederhelmet.IHelmetModule;
import de.canitzp.feederhelmet.NBTHelper;
import de.canitzp.feederhelmet.item.ItemFeederModule;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.item.crafting.UpgradeRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class FeederRecipeManager {
    public static Recipe<?> creationRecipe(final IHelmetModule module, Item helmet, ResourceLocation craftingId) {
        ItemStack outputStack = helmet.m_7968_();
        NBTHelper.addModule(module.getTagName(), outputStack);
        return new UpgradeRecipe(craftingId, Ingredient.m_43929_((ItemLike[])new ItemLike[]{helmet}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)FeederHelmet.FEEDER_HELMET_MODULE_ITEM.get()}), outputStack){

            @NotNull
            public ItemStack m_5874_(@NotNull Container container) {
                ItemStack assembled = super.m_5874_(container);
                NBTHelper.addModule(module.getTagName(), assembled);
                return assembled;
            }

            public boolean m_5818_(Container container, Level level) {
                boolean matches = super.m_5818_(container, level);
                if (!matches) {
                    return false;
                }
                ItemStack helmetInputStack = container.m_8020_(0);
                return !NBTHelper.isModulePresent(module.getTagName(), helmetInputStack);
            }
        };
    }

    public static Recipe<?> removalRecipe(final IHelmetModule module, Item helmet, ResourceLocation craftingId) {
        NonNullList ingredients = NonNullList.m_122779_();
        ingredients.add((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{helmet}));
        ItemStack outputStack = helmet.m_7968_();
        return new ShapelessRecipe(craftingId, "", outputStack, ingredients){

            public ItemStack m_5874_(CraftingContainer container) {
                ItemStack assembled = super.m_5874_(container);
                ItemStack inputStack = ItemStack.f_41583_;
                for (int slotId = 0; slotId < container.m_6643_(); ++slotId) {
                    if (container.m_8020_(slotId).m_41619_()) continue;
                    inputStack = container.m_8020_(slotId).m_41777_();
                    break;
                }
                if (!inputStack.m_41619_() && inputStack.m_41782_()) {
                    CompoundTag inputTag = inputStack.m_41783_();
                    inputTag.m_128473_("SolarHelmet");
                    assembled.m_41751_(inputTag);
                    NBTHelper.removeModule(module.getTagName(), assembled);
                }
                return assembled;
            }

            public boolean m_5818_(CraftingContainer container, Level level) {
                boolean matches = super.m_5818_(container, level);
                if (!matches) {
                    return false;
                }
                ItemStack inputStack = ItemStack.f_41583_;
                for (int slotId = 0; slotId < container.m_6643_(); ++slotId) {
                    if (container.m_8020_(slotId).m_41619_()) continue;
                    inputStack = container.m_8020_(slotId);
                    break;
                }
                if (inputStack.m_41619_()) {
                    return false;
                }
                if (!inputStack.m_41782_()) {
                    return false;
                }
                return NBTHelper.isModulePresent(module.getTagName(), inputStack);
            }

            public NonNullList<ItemStack> getRemainingItems(CraftingContainer container) {
                NonNullList remainingItems = super.m_7457_((Container)container);
                remainingItems.set(0, (Object)((ItemFeederModule)((Object)FeederHelmet.FEEDER_HELMET_MODULE_ITEM.get())).m_7968_());
                return remainingItems;
            }
        };
    }
}

