/*
 * Decompiled with CFR 0.152.
 */
package de.canitzp.feederhelmet;

import de.canitzp.feederhelmet.EnergyHandler;
import de.canitzp.feederhelmet.FeederConfig;
import de.canitzp.feederhelmet.FeederHelmet;
import de.canitzp.feederhelmet.IHelmetModule;
import de.canitzp.feederhelmet.ItemStackUtil;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.event.ForgeEventFactory;

public class FeederModule
implements IHelmetModule {
    @Override
    public Item getCorrespondingModuleItem() {
        return (Item)FeederHelmet.FEEDER_HELMET_MODULE_ITEM.get();
    }

    @Override
    public String getTagName() {
        return "feeder_module";
    }

    @Override
    public boolean isModuleApplicableTo(ItemStack stack) {
        return FeederHelmet.isItemHelmet(stack);
    }

    @Override
    public void renderTooltip(@Nonnull ItemStack stack, @Nullable Player entityPlayer, List<Component> list, TooltipFlag flags) {
        list.add((Component)Component.m_237115_((String)"item.feederhelmet:feeder_helmet_module_installed.text").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.ITALIC}));
    }

    @Override
    public void updatePlayer(Player player, ItemStack helmetStack) {
        if (player.m_36391_(false) && FeederHelmet.canDamageBeReducedOrEnergyConsumed(helmetStack)) {
            for (ItemStack inventoryStack : player.m_150109_().f_35974_) {
                if (!FeederModule.canHelmetEatStack(player.f_19853_, inventoryStack) || !FeederModule.canPlayerEat(player, inventoryStack) || !player.m_36391_(false)) continue;
                AtomicBoolean hasEnergy = new AtomicBoolean(false);
                AtomicBoolean canEat = new AtomicBoolean(false);
                helmetStack.getCapability(ForgeCapabilities.ENERGY).ifPresent(energy -> {
                    hasEnergy.set(true);
                    EnergyHandler energyHandler = EnergyHandler.get(helmetStack);
                    if (energyHandler != null && energyHandler.canBeUsed((Integer)FeederConfig.GENERAL.ENERGY_CONSUMPTION.get())) {
                        energyHandler.use();
                        canEat.set(true);
                    }
                });
                if (!hasEnergy.get()) {
                    if (helmetStack.m_41763_()) {
                        helmetStack.m_41721_(helmetStack.m_41773_() + (Integer)FeederConfig.GENERAL.DURABILITY.get());
                        if (helmetStack.m_41776_() - helmetStack.m_41773_() <= 0) {
                            helmetStack.m_41764_(0);
                        }
                    }
                    canEat.set(true);
                }
                if (!canEat.get()) continue;
                ForgeEventFactory.onItemUseStart((LivingEntity)player, (ItemStack)inventoryStack, (int)0);
                ItemStack result = inventoryStack.m_41720_().m_5922_(inventoryStack, player.m_20193_(), (LivingEntity)player);
                ForgeEventFactory.onItemUseFinish((LivingEntity)player, (ItemStack)inventoryStack, (int)0, (ItemStack)result);
                break;
            }
        }
    }

    private static boolean canHelmetEatStack(Level level, @Nonnull ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        if (ItemStackUtil.isFoodBlacklisted(stack)) {
            return false;
        }
        if (ItemStackUtil.isFoodWhitelisted(stack)) {
            return true;
        }
        if (((Boolean)FeederConfig.GENERAL.BLACKLIST_SMELTABLES.get()).booleanValue() && ItemStackUtil.isSmeltable(level, stack)) {
            return false;
        }
        return ItemStackUtil.isEatable(stack);
    }

    private static boolean canPlayerEat(Player player, ItemStack stack) {
        if (!stack.m_41619_() && stack.m_41720_().m_41472_()) {
            if (((Boolean)FeederConfig.GENERAL.WAIT_UNITL_FILL_ALL_HUNGER.get()).booleanValue()) {
                return player.m_36324_().m_38702_() + stack.m_41720_().m_41473_().m_38744_() <= 20 || (Boolean)FeederConfig.GENERAL.IGNORE_WAITING_WHEN_LOW_HEART.get() != false && player.m_21223_() <= 10.0f;
            }
            return true;
        }
        return true;
    }
}

