/*
 * Decompiled with CFR 0.152.
 */
package de.canitzp.feederhelmet;

import de.canitzp.feederhelmet.FeederConfig;
import de.canitzp.feederhelmet.FeederModule;
import de.canitzp.feederhelmet.FeederRecipeManager;
import de.canitzp.feederhelmet.IHelmetModule;
import de.canitzp.feederhelmet.ItemStackUtil;
import de.canitzp.feederhelmet.NBTHelper;
import de.canitzp.feederhelmet.item.ItemFeederModule;
import de.canitzp.feederhelmet.item.ItemPhotosynthesisModule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
@Mod(value="feederhelmet")
public class FeederHelmet {
    public static final String MODID = "feederhelmet";
    private static final Logger LOGGER = LogManager.getLogger((String)"feederhelmet");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"feederhelmet");
    public static final RegistryObject<ItemFeederModule> FEEDER_HELMET_MODULE_ITEM = ITEMS.register("feeder_helmet_module", ItemFeederModule::new);
    public static final RegistryObject<ItemPhotosynthesisModule> PHOTOSYNTHESIS_MODULE_ITEM = ITEMS.register("photosynthesis_helmet_module", ItemPhotosynthesisModule::new);
    public static final List<IHelmetModule> MODULES = new ArrayList<IHelmetModule>();
    public static final CreativeModeTab TAB = new CreativeModeTab("feederhelmet"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)FEEDER_HELMET_MODULE_ITEM.get());
        }

        @OnlyIn(value=Dist.CLIENT)
        public void m_6151_(NonNullList<ItemStack> stacks) {
            for (IHelmetModule module : MODULES) {
                stacks.add((Object)new ItemStack((ItemLike)module.getCorrespondingModuleItem()));
                for (Item item : ForgeRegistries.ITEMS) {
                    if (!module.isModuleApplicableTo(item.m_7968_())) continue;
                    ItemStack stack = new ItemStack((ItemLike)item);
                    CompoundTag tag = new CompoundTag();
                    ListTag modulesList = new ListTag();
                    modulesList.add((Object)StringTag.m_129297_((String)module.getTagName()));
                    tag.m_128365_("modules", (Tag)modulesList);
                    stack.m_41751_(tag);
                    stacks.add((Object)stack);
                }
            }
        }
    };

    public FeederHelmet() {
        LOGGER.info("Feeder Helmet loading...");
        MODULES.add(new FeederModule());
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)FeederConfig.spec);
        ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        LOGGER.info("Feeder Helmet loaded.");
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void renderTooltips(ItemTooltipEvent event) {
        if (!event.getItemStack().m_41619_()) {
            for (IHelmetModule module : MODULES) {
                if (!NBTHelper.isModulePresent(module.getTagName(), event.getItemStack())) continue;
                module.renderTooltip(event.getItemStack(), event.getEntity(), event.getToolTip(), event.getFlags());
            }
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor.m_5776_()) {
            return;
        }
        if (levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            if (level.m_46472_() != Level.f_46428_) {
                return;
            }
            LOGGER.info("Feeder Helmet recipe injecting...");
            RecipeManager recipeManager = level.m_7465_();
            ArrayList allNewRecipes = new ArrayList();
            for (IHelmetModule module : MODULES) {
                for (Item helmet : ForgeRegistries.ITEMS.getValues()) {
                    if (!module.isModuleApplicableTo(helmet.m_7968_())) continue;
                    ResourceLocation helmetKey = ForgeRegistries.ITEMS.getKey((Object)helmet);
                    ResourceLocation creationCraftingId = new ResourceLocation(MODID, module.getTagName() + "_creation_" + helmetKey.m_135827_() + "_" + helmetKey.m_135815_());
                    ResourceLocation removalCraftingId = new ResourceLocation(MODID, module.getTagName() + "_removal_" + helmetKey.m_135827_() + "_" + helmetKey.m_135815_());
                    Recipe<?> creationRecipe = FeederRecipeManager.creationRecipe(module, helmet, creationCraftingId);
                    Recipe<?> removalRecipe = FeederRecipeManager.removalRecipe(module, helmet, removalCraftingId);
                    if (recipeManager.m_44073_().noneMatch(resourceLocation -> resourceLocation.equals((Object)creationCraftingId))) {
                        allNewRecipes.add(creationRecipe);
                        LOGGER.info(String.format("Feeder Helmet created %s recipe for %s with id '%s'", module.getTagName(), helmetKey, creationCraftingId));
                    }
                    if (!recipeManager.m_44073_().noneMatch(resourceLocation -> resourceLocation.equals((Object)removalCraftingId))) continue;
                    allNewRecipes.add(removalRecipe);
                    LOGGER.info(String.format("Feeder Helmet created %s recipe for %s with id '%s'", module.getTagName(), helmetKey, removalCraftingId));
                }
            }
            try {
                allNewRecipes.addAll(recipeManager.m_44051_());
                recipeManager.m_44024_(allNewRecipes);
            }
            catch (IllegalStateException e) {
                LOGGER.error("Feeder Helmet: Illegal recipe replacement caught! Report this to author immediately!", (Throwable)e);
            }
        }
    }

    @SubscribeEvent
    public static void updatePlayer(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.player.f_19853_.m_5776_() && event.player.m_20193_().m_46467_() % (long)((Integer)FeederConfig.GENERAL.WAIT_TICKS.get()).intValue() == 0L) {
            ItemStack helmetStack = (ItemStack)event.player.m_150109_().f_35975_.get(EquipmentSlot.HEAD.m_20749_());
            for (IHelmetModule module : MODULES) {
                if (!NBTHelper.isModulePresent(module.getTagName(), helmetStack)) continue;
                module.updatePlayer(event.player, helmetStack);
            }
        }
    }

    @SubscribeEvent
    public static void anvilRepair(AnvilRepairEvent event) {
        ItemStack toRepair = event.getLeft();
        ItemStack result = event.getOutput();
        if (toRepair.m_41782_() && toRepair.m_41783_().m_128425_("modules", 9)) {
            CompoundTag nbt = result.m_41782_() ? result.m_41783_() : new CompoundTag();
            nbt.m_128365_("modules", toRepair.m_41783_().m_128423_("modules"));
            result.m_41751_(nbt);
        }
    }

    @SubscribeEvent
    public static void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        NonNullList armorInventory = player.m_150109_().f_35975_;
        NonNullList mainInventory = player.m_150109_().f_35974_;
        NonNullList offHandInventory = player.m_150109_().f_35976_;
        NonNullList mergedInventory = NonNullList.m_122779_();
        mergedInventory.addAll((Collection)armorInventory);
        mergedInventory.addAll((Collection)mainInventory);
        mergedInventory.addAll((Collection)offHandInventory);
        for (ItemStack stack : mergedInventory) {
            CompoundTag tag;
            if (!stack.m_41782_() || !(tag = stack.m_41783_()).m_128425_("AutoFeederHelmet", 1)) continue;
            tag.m_128473_("AutoFeederHelmet");
            ListTag modules = tag.m_128437_("modules", 8);
            modules.add((Object)StringTag.m_129297_((String)"feeder_module"));
            tag.m_128365_("modules", (Tag)modules);
        }
    }

    public static boolean isItemHelmet(ItemStack stack) {
        return stack.m_41720_() instanceof ArmorItem && ((ArmorItem)stack.m_41720_()).m_40402_() == EquipmentSlot.HEAD && !ItemStackUtil.isHelmetBlacklisted(stack) || ItemStackUtil.isHelmetWhitelisted(stack);
    }

    public static boolean canDamageBeReducedOrEnergyConsumed(@Nonnull ItemStack stack) {
        AtomicBoolean canWork = new AtomicBoolean(false);
        stack.getCapability(ForgeCapabilities.ENERGY).ifPresent(energyCapability -> canWork.set(true));
        if (!canWork.get()) {
            if (stack.m_41763_()) {
                int newDmg = stack.m_41773_() + (Integer)FeederConfig.GENERAL.DURABILITY.get();
                if (((Boolean)FeederConfig.GENERAL.CAN_BREAK.get()).booleanValue()) {
                    canWork.set(newDmg <= stack.m_41776_());
                } else {
                    canWork.set(newDmg < stack.m_41776_());
                }
            } else {
                canWork.set(true);
            }
        }
        return canWork.get();
    }
}

