/*
 * Decompiled with CFR 0.152.
 */
package de.canitzp.feederhelmet;

import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.math.NumberUtils;

public abstract class EnergyHandler {
    private ItemStack stack;

    public static EnergyHandler get(@Nonnull ItemStack stack) {
        CompoundTag mekData;
        if (!stack.m_41782_()) {
            return null;
        }
        if (stack.m_41783_().m_128425_("Energy", 3)) {
            return new Simple(stack, "Energy");
        }
        if (stack.m_41783_().m_128425_("energy", 3)) {
            return new Simple(stack, "energy");
        }
        if (stack.m_41783_().m_128425_("enderio.darksteel.upgrade.energyUpgrade", 10)) {
            return new EnderIOEnergyUpgrade(stack);
        }
        if (stack.m_41783_().m_128425_("mekData", 10) && (mekData = stack.m_41783_().m_128469_("mekData")).m_128425_("EnergyContainers", 9)) {
            return new MekanismMekaSuit(stack, mekData.m_128437_("EnergyContainers", 10));
        }
        if (stack.m_41783_().m_128425_("charge", 6)) {
            return new IC2(stack);
        }
        return null;
    }

    public EnergyHandler(ItemStack stack) {
        this.stack = stack;
    }

    public abstract boolean canBeUsed(int var1);

    public abstract void use();

    public static class Simple
    extends EnergyHandler {
        private String tagName;
        private int energy;
        private int energyAfterUsage;

        public Simple(ItemStack stack, String tagName) {
            super(stack);
            this.tagName = tagName;
            this.energy = stack.m_41783_().m_128451_(this.tagName);
        }

        @Override
        public boolean canBeUsed(int energyToExtract) {
            this.energyAfterUsage = this.energy - energyToExtract;
            return this.energyAfterUsage >= 0;
        }

        @Override
        public void use() {
            this.stack.m_41783_().m_128405_(this.tagName, this.energyAfterUsage);
        }
    }

    public static class EnderIOEnergyUpgrade
    extends EnergyHandler {
        private int energy;
        private int energyAfterUsage;

        public EnderIOEnergyUpgrade(ItemStack stack) {
            super(stack);
            this.energy = stack.m_41783_().m_128469_("enderio.darksteel.upgrade.energyUpgrade").m_128451_("energy");
        }

        @Override
        public boolean canBeUsed(int energyToExtract) {
            this.energyAfterUsage = this.energy - energyToExtract;
            return this.energyAfterUsage >= 0;
        }

        @Override
        public void use() {
            this.stack.m_41783_().m_128469_("enderio.darksteel.upgrade.energyUpgrade").m_128405_("energy", this.energyAfterUsage);
        }
    }

    public static class MekanismMekaSuit
    extends EnergyHandler {
        private ListTag tagEnergyContainers;
        private int energy;
        private int energyToExtract;

        public MekanismMekaSuit(ItemStack stack, ListTag tagEnergyContainers) {
            super(stack);
            this.tagEnergyContainers = tagEnergyContainers;
            for (Tag tag : tagEnergyContainers) {
                CompoundTag compound;
                String storedAsString;
                if (!(tag instanceof CompoundTag) || !NumberUtils.isParsable((String)(storedAsString = (compound = (CompoundTag)tag).m_128461_("stored")))) continue;
                this.energy += NumberUtils.toInt((String)storedAsString, (int)0);
            }
            this.energy = Math.round((float)this.energy / 2.5f);
        }

        @Override
        public boolean canBeUsed(int energyToExtract) {
            this.energyToExtract = energyToExtract;
            return this.energy - energyToExtract >= 0;
        }

        @Override
        public void use() {
            this.energyToExtract = Math.round((float)this.energyToExtract * 2.5f);
            for (Tag energyContainer : this.tagEnergyContainers) {
                if (!(energyContainer instanceof CompoundTag)) continue;
                CompoundTag tag = (CompoundTag)energyContainer;
                String storedAsString = tag.m_128461_("stored");
                int stored = 0;
                if (NumberUtils.isParsable((String)storedAsString)) {
                    stored = NumberUtils.toInt((String)storedAsString, (int)0);
                }
                int energyAfterExtract = Math.max(0, stored - this.energyToExtract);
                this.energyToExtract = stored - energyAfterExtract;
                tag.m_128359_("stored", Integer.toString(energyAfterExtract));
                if (this.energyToExtract > 0) continue;
                break;
            }
        }
    }

    public static class IC2
    extends EnergyHandler {
        private static final double EU_CONVERSION_MODIFIER = 4.0;
        private double energy;
        private double energyAfterUsage;

        public IC2(ItemStack stack) {
            super(stack);
            this.energy = stack.m_41783_().m_128459_("charge");
        }

        @Override
        public boolean canBeUsed(int energyToExtract) {
            double realEnergyToExtract = (double)energyToExtract / 4.0;
            this.energyAfterUsage = this.energy - realEnergyToExtract;
            return this.energyAfterUsage >= 0.0;
        }

        @Override
        public void use() {
            this.stack.m_41783_().m_128347_("charge", this.energyAfterUsage);
        }
    }
}

