/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.clipboard;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.equipment.clipboard.ClipboardBlockEntity;
import com.simibubi.create.content.equipment.clipboard.ClipboardScreen;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import com.simibubi.create.foundation.gui.ScreenOpener;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.DistExecutor;

public class ClipboardBlock
extends FaceAttachedHorizontalDirectionalBlock
implements IBE<ClipboardBlockEntity>,
IWrenchable,
ProperWaterloggedBlock {
    public static final BooleanProperty WRITTEN = BooleanProperty.m_61465_((String)"written");

    public ClipboardBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WRITTEN, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder.m_61104_(new Property[]{WRITTEN, f_53179_, f_54117_, WATERLOGGED}));
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockState stateForPlacement = super.m_5573_(pContext);
        if (stateForPlacement == null) {
            return null;
        }
        if (stateForPlacement.m_61143_((Property)f_53179_) != AttachFace.WALL) {
            stateForPlacement = (BlockState)stateForPlacement.m_61124_((Property)f_54117_, (Comparable)((Direction)stateForPlacement.m_61143_((Property)f_54117_)).m_122424_());
        }
        return (BlockState)this.withWater(stateForPlacement, pContext).m_61124_((Property)WRITTEN, (Comparable)Boolean.valueOf(pContext.m_43722_().m_41782_()));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return (switch ((AttachFace)pState.m_61143_((Property)f_53179_)) {
            case AttachFace.FLOOR -> AllShapes.CLIPBOARD_FLOOR;
            case AttachFace.CEILING -> AllShapes.CLIPBOARD_CEILING;
            default -> AllShapes.CLIPBOARD_WALL;
        }).get((Direction)pState.m_61143_((Property)f_54117_));
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return !pLevel.m_8055_(pPos.m_121945_(ClipboardBlock.m_53200_((BlockState)pState).m_122424_())).m_60767_().m_76336_();
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pPlayer.m_20161_()) {
            this.breakAndCollect(pState, pLevel, pPos, pPlayer);
            return InteractionResult.SUCCESS;
        }
        return this.onBlockEntityUse((BlockGetter)pLevel, pPos, cbe -> {
            if (pLevel.m_5776_()) {
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.openScreen(pPlayer, cbe.dataContainer, pPos));
            }
            return InteractionResult.SUCCESS;
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openScreen(Player player, ItemStack stack, BlockPos pos) {
        if (Minecraft.m_91087_().f_91074_ == player) {
            ScreenOpener.open(new ClipboardScreen(player.m_150109_().f_35977_, stack, pos));
        }
    }

    public void m_6256_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        this.breakAndCollect(pState, pLevel, pPos, pPlayer);
    }

    private void breakAndCollect(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        if (pPlayer instanceof FakePlayer) {
            return;
        }
        if (pLevel.f_46443_) {
            return;
        }
        ItemStack cloneItemStack = this.m_7397_((BlockGetter)pLevel, pPos, pState);
        pLevel.m_46961_(pPos, false);
        if (pLevel.m_8055_(pPos) != pState) {
            pPlayer.m_150109_().m_150079_(cloneItemStack);
        }
    }

    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof ClipboardBlockEntity) {
            ClipboardBlockEntity cbe = (ClipboardBlockEntity)blockEntity;
            return cbe.dataContainer;
        }
        return new ItemStack((ItemLike)this);
    }

    public void m_5707_(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (!(blockEntity instanceof ClipboardBlockEntity)) {
            return;
        }
        ClipboardBlockEntity cbe = (ClipboardBlockEntity)blockEntity;
        if (pLevel.f_46443_ || pPlayer.m_7500_()) {
            return;
        }
        Block.m_49840_((Level)pLevel, (BlockPos)pPos, (ItemStack)cbe.dataContainer.m_41777_());
    }

    public List<ItemStack> m_7381_(BlockState pState, LootContext.Builder pBuilder) {
        Object object = pBuilder.m_78982_(LootContextParams.f_81462_);
        if (!(object instanceof ClipboardBlockEntity)) {
            return super.m_7381_(pState, pBuilder);
        }
        ClipboardBlockEntity cbe = (ClipboardBlockEntity)object;
        pBuilder.m_78979_(ShulkerBoxBlock.f_56184_, (p_56218_, p_56219_) -> p_56219_.accept(cbe.dataContainer.m_41777_()));
        return ImmutableList.of((Object)cbe.dataContainer.m_41777_());
    }

    public FluidState m_5888_(BlockState pState) {
        return this.fluidState(pState);
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        this.updateWater(pLevel, pState, pCurrentPos);
        return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    @Override
    public Class<ClipboardBlockEntity> getBlockEntityClass() {
        return ClipboardBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends ClipboardBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.CLIPBOARD.get();
    }
}

