/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.mutil.data;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.mickelus.mutil.data.DataDistributor;
import se.mickelus.mutil.data.DataStore;

public abstract class MergingDataStore<V, U>
extends DataStore<V> {
    private static final Logger logger = LogManager.getLogger();
    protected Class<U> arrayClass;

    public MergingDataStore(Gson gson, String namespace, String directory, Class<V> entryClass, Class<U> arrayClass, DataDistributor synchronizer) {
        super(gson, namespace, directory, entryClass, synchronizer);
        this.arrayClass = arrayClass;
    }

    @Override
    protected Map<ResourceLocation, JsonElement> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        logger.debug("Reading data for {} data store...", (Object)this.directory);
        HashMap map = Maps.newHashMap();
        int i = this.directory.length() + 1;
        for (Map.Entry entry : resourceManager.m_214160_(this.directory, rl -> rl.m_135815_().endsWith(".json")).entrySet()) {
            if (!this.namespace.equals(((ResourceLocation)entry.getKey()).m_135827_())) continue;
            String path = ((ResourceLocation)entry.getKey()).m_135815_();
            ResourceLocation location = new ResourceLocation(((ResourceLocation)entry.getKey()).m_135827_(), path.substring(i, path.length() - jsonExtLength));
            JsonArray allResources = new JsonArray();
            for (Resource resource : (List)entry.getValue()) {
                try {
                    BufferedReader reader = resource.m_215508_();
                    try {
                        JsonObject json = (JsonObject)GsonHelper.m_13776_((Gson)this.gson, (Reader)reader, JsonObject.class);
                        if (json != null) {
                            if (this.shouldLoad((JsonElement)json)) {
                                allResources.add((JsonElement)json);
                                continue;
                            }
                            logger.debug("Skipping data '{}' from '{}' due to condition", entry.getKey(), (Object)resource.m_215506_());
                            continue;
                        }
                        logger.error("Couldn't load data from '{}' in data pack '{}' as it's empty or null", entry.getKey(), (Object)resource.m_215506_());
                    }
                    finally {
                        if (reader == null) continue;
                        ((Reader)reader).close();
                    }
                }
                catch (IOException | RuntimeException e) {
                    logger.error("Couldn't load data from '{}' in data pack '{}'", entry.getKey(), (Object)resource.m_215506_(), (Object)e);
                }
            }
            if (allResources.size() <= 0) continue;
            map.put(location, allResources);
        }
        return map;
    }

    @Override
    public void loadFromPacket(Map<ResourceLocation, String> data) {
        Map<ResourceLocation, JsonElement> splashList = data.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (JsonElement)GsonHelper.m_13794_((Gson)this.gson, (String)((String)entry.getValue()), JsonArray.class)));
        this.parseData(splashList);
    }

    @Override
    public void parseData(Map<ResourceLocation, JsonElement> splashList) {
        logger.info("Loaded {} {}", (Object)String.format("%3d", splashList.values().size()), (Object)this.directory);
        this.dataMap = splashList.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.mergeData(this.gson.fromJson((JsonElement)entry.getValue(), this.arrayClass))));
        this.processData();
        this.listeners.forEach(Runnable::run);
    }

    protected abstract V mergeData(U var1);
}

