/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.tesla_coil;

import com.mrh0.createaddition.blocks.tesla_coil.TeslaCoilBeltCallbacks;
import com.mrh0.createaddition.blocks.tesla_coil.TeslaCoilBlock;
import com.mrh0.createaddition.config.Config;
import com.mrh0.createaddition.energy.BaseElectricTileEntity;
import com.mrh0.createaddition.index.CABlocks;
import com.mrh0.createaddition.index.CAEffects;
import com.mrh0.createaddition.recipe.charging.ChargingRecipe;
import com.mrh0.createaddition.util.Util;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class TeslaCoilTileEntity
extends BaseElectricTileEntity
implements IHaveGoggleInformation {
    private Optional<ChargingRecipe> recipeCache = Optional.empty();
    private ItemStackHandler inputInv = new ItemStackHandler(1);
    private int chargeAccumulator;
    private static final int MAX_IN = (Integer)Config.TESLA_COIL_MAX_INPUT.get();
    private static final int CHARGE_RATE = (Integer)Config.TESLA_COIL_CHARGE_RATE.get();
    private static final int CHARGE_RATE_RECIPE = (Integer)Config.TESLA_COIL_RECIPE_CHARGE_RATE.get();
    private static final int CAPACITY = Util.max((Integer)Config.TESLA_COIL_CAPACITY.get(), CHARGE_RATE, CHARGE_RATE_RECIPE);
    private static final int HURT_ENERGY_REQUIRED = (Integer)Config.TESLA_COIL_HURT_ENERGY_REQUIRED.get();
    private static final int HURT_DMG_MOB = (Integer)Config.TESLA_COIL_HURT_DMG_MOB.get();
    private static final int HURT_DMG_PLAYER = (Integer)Config.TESLA_COIL_HURT_DMG_PLAYER.get();
    private static final int HURT_RANGE = (Integer)Config.TESLA_COIL_HURT_RANGE.get();
    private static final int HURT_EFFECT_TIME_MOB = (Integer)Config.TESLA_COIL_HURT_EFFECT_TIME_MOB.get();
    private static final int HURT_EFFECT_TIME_PLAYER = (Integer)Config.TESLA_COIL_HURT_EFFECT_TIME_PLAYER.get();
    private static final int HURT_FIRE_COOLDOWN = (Integer)Config.TESLA_COIL_HURT_FIRE_COOLDOWN.get();
    protected ItemStack chargedStackCache;
    protected int poweredTimer = 0;
    private static DamageSource DMG_SOURCE = new DamageSource("tesla_coil");
    public BeltProcessingBehaviour processingBehaviour;
    int dmgTick = 0;
    int soundTimeout = 0;

    public TeslaCoilTileEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state, CAPACITY, MAX_IN, 0);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.processingBehaviour = new BeltProcessingBehaviour((SmartBlockEntity)this).whenItemEnters((s, i) -> TeslaCoilBeltCallbacks.onItemReceived(s, i, this)).whileItemHeld((s, i) -> TeslaCoilBeltCallbacks.whenItemHeld(s, i, this));
        behaviours.add((BlockEntityBehaviour)this.processingBehaviour);
    }

    @Override
    public boolean isEnergyInput(Direction side) {
        return side != ((Direction)this.m_58900_().m_61143_((Property)TeslaCoilBlock.FACING)).m_122424_();
    }

    @Override
    public boolean isEnergyOutput(Direction side) {
        return false;
    }

    public int getConsumption() {
        return CHARGE_RATE;
    }

    protected float getItemCharge(IEnergyStorage energy) {
        if (energy == null) {
            return 0.0f;
        }
        return (float)energy.getEnergyStored() / (float)energy.getMaxEnergyStored();
    }

    protected BeltProcessingBehaviour.ProcessingResult onCharge(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
        BeltProcessingBehaviour.ProcessingResult res = this.chargeCompundAndStack(transported, handler);
        return res;
    }

    private void doDmg() {
        this.localEnergy.internalConsumeEnergy(HURT_ENERGY_REQUIRED);
        BlockPos origin = this.m_58899_().m_121945_(((Direction)this.m_58900_().m_61143_((Property)TeslaCoilBlock.FACING)).m_122424_());
        List ents = this.m_58904_().m_45976_(LivingEntity.class, new AABB(origin).m_82400_((double)HURT_RANGE));
        for (LivingEntity e : ents) {
            if (e == null) {
                return;
            }
            int dmg = HURT_DMG_MOB;
            int time = HURT_EFFECT_TIME_MOB;
            if (e instanceof Player) {
                dmg = HURT_DMG_PLAYER;
                time = HURT_EFFECT_TIME_PLAYER;
            }
            if (dmg > 0) {
                e.m_6469_(DMG_SOURCE, (float)dmg);
            }
            if (time <= 0) continue;
            e.m_7292_(new MobEffectInstance((MobEffect)CAEffects.SHOCKING.get(), time));
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.f_58857_.m_5776_()) {
            if (this.isPoweredState() && this.soundTimeout++ > 20) {
                this.soundTimeout = 0;
            }
            return;
        }
        int signal = this.m_58904_().m_46755_(this.m_58899_());
        if (signal > 0 && this.localEnergy.getEnergyStored() >= HURT_ENERGY_REQUIRED) {
            this.poweredTimer = 10;
        }
        ++this.dmgTick;
        if ((this.dmgTick %= HURT_FIRE_COOLDOWN) == 0 && this.localEnergy.getEnergyStored() >= HURT_ENERGY_REQUIRED && signal > 0) {
            this.doDmg();
        }
        if (this.poweredTimer > 0) {
            if (!this.isPoweredState()) {
                ((TeslaCoilBlock)((Object)CABlocks.TESLA_COIL.get())).setPowered(this.f_58857_, this.m_58899_(), true);
            }
            --this.poweredTimer;
        } else if (this.isPoweredState()) {
            ((TeslaCoilBlock)((Object)CABlocks.TESLA_COIL.get())).setPowered(this.f_58857_, this.m_58899_(), false);
        }
    }

    public boolean isPoweredState() {
        return (Boolean)this.m_58900_().m_61143_((Property)TeslaCoilBlock.POWERED);
    }

    protected BeltProcessingBehaviour.ProcessingResult chargeCompundAndStack(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
        ItemStack stack = transported.stack;
        if (stack == null) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (this.chargeStack(stack, transported, handler)) {
            this.poweredTimer = 10;
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        if (this.chargeRecipe(stack, transported, handler)) {
            this.poweredTimer = 10;
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        return BeltProcessingBehaviour.ProcessingResult.PASS;
    }

    protected boolean chargeStack(ItemStack stack, TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
        if (!stack.getCapability(CapabilityEnergy.ENERGY).isPresent()) {
            return false;
        }
        IEnergyStorage es = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY).orElse(null);
        if (es.receiveEnergy(1, true) != 1) {
            return false;
        }
        if (this.localEnergy.getEnergyStored() < stack.m_41613_()) {
            return false;
        }
        this.localEnergy.internalConsumeEnergy(es.receiveEnergy(Math.min(this.getConsumption(), this.localEnergy.getEnergyStored()), false));
        return true;
    }

    private boolean chargeRecipe(ItemStack stack, TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
        if (!this.inputInv.getStackInSlot(0).m_41656_(stack)) {
            this.inputInv.setStackInSlot(0, stack);
            this.recipeCache = this.find(new RecipeWrapper((IItemHandlerModifiable)this.inputInv), this.m_58904_());
            this.chargeAccumulator = 0;
        }
        if (this.recipeCache.isPresent()) {
            ChargingRecipe recipe = this.recipeCache.get();
            int energyRemoved = this.localEnergy.internalConsumeEnergy(Math.min(CHARGE_RATE_RECIPE, recipe.getEnergy() - this.chargeAccumulator));
            this.chargeAccumulator += energyRemoved;
            if (this.chargeAccumulator >= recipe.getEnergy()) {
                TransportedItemStack remainingStack = transported.copy();
                TransportedItemStack result = transported.copy();
                result.stack = recipe.m_8043_().m_41777_();
                remainingStack.stack.m_41774_(1);
                ArrayList<TransportedItemStack> outList = new ArrayList<TransportedItemStack>();
                outList.add(result);
                handler.handleProcessingOnItem(transported, TransportedItemStackHandlerBehaviour.TransportedResult.convertToAndLeaveHeld(outList, (TransportedItemStack)remainingStack));
                this.chargeAccumulator = 0;
            }
            return true;
        }
        return false;
    }

    public Optional<ChargingRecipe> find(RecipeWrapper wrapper, Level world) {
        return world.m_7465_().m_44015_(ChargingRecipe.TYPE, (Container)wrapper, world);
    }
}

