/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.modular_accumulator;

import com.mrh0.createaddition.CreateAddition;
import com.mrh0.createaddition.blocks.modular_accumulator.CAConnectivityHandler;
import com.mrh0.createaddition.blocks.modular_accumulator.ModularAccumulatorBlock;
import com.mrh0.createaddition.compat.computercraft.ModularAccumulatorPeripheral;
import com.mrh0.createaddition.compat.computercraft.Peripherals;
import com.mrh0.createaddition.config.Config;
import com.mrh0.createaddition.debug.IDebugDrawer;
import com.mrh0.createaddition.energy.IMultiTileEnergyContainer;
import com.mrh0.createaddition.energy.InternalEnergyStorage;
import com.mrh0.createaddition.network.EnergyNetworkPacket;
import com.mrh0.createaddition.network.IObserveTileEntity;
import com.mrh0.createaddition.network.ObservePacket;
import com.mrh0.createaddition.util.Util;
import com.simibubi.create.Create;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.redstone.thresholdSwitch.ThresholdSwitchObservable;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class ModularAccumulatorTileEntity
extends SmartBlockEntity
implements IHaveGoggleInformation,
IMultiTileEnergyContainer,
IObserveTileEntity,
IDebugDrawer,
ThresholdSwitchObservable {
    public static final int CAPACITY = (Integer)Config.ACCUMULATOR_CAPACITY.get();
    public static final int MAX_IN = (Integer)Config.ACCUMULATOR_MAX_INPUT.get();
    public static final int MAX_OUT = (Integer)Config.ACCUMULATOR_MAX_OUTPUT.get();
    public static final int MAX_HEIGHT = (Integer)Config.ACCUMULATOR_MAX_HEIGHT.get();
    public static final int MAX_WIDTH = (Integer)Config.ACCUMULATOR_MAX_WIDTH.get();
    protected LazyOptional<IEnergyStorage> energyCap;
    protected InternalEnergyStorage energyStorage;
    protected BlockPos controller;
    protected BlockPos lastKnownPos;
    protected boolean updateConnectivity = false;
    protected int width = 1;
    protected int height = 1;
    private static final int SYNC_RATE = 8;
    protected int syncCooldown;
    protected boolean queuedSync;
    private LazyOptional<IEnergyStorage> escacheUp = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> escacheDown = LazyOptional.empty();
    protected LazyOptional<ModularAccumulatorPeripheral> peripheral;
    public LerpedFloat gauge = LerpedFloat.linear();
    int lastEnergy = 0;
    boolean firstTickState = true;

    public ModularAccumulatorTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.energyStorage = this.createEnergyStorage();
        this.energyCap = LazyOptional.of(() -> this.energyStorage);
        this.refreshCapability();
        if (CreateAddition.CC_ACTIVE) {
            this.peripheral = LazyOptional.of(() -> Peripherals.createModularAccumulatorPeripheral(this));
        }
    }

    protected InternalEnergyStorage createEnergyStorage() {
        return new InternalEnergyStorage(ModularAccumulatorTileEntity.getCapacityMultiplier(), (Integer)Config.ACCUMULATOR_MAX_INPUT.get(), (Integer)Config.ACCUMULATOR_MAX_OUTPUT.get());
    }

    public void setCache(Direction side, LazyOptional<IEnergyStorage> storage) {
        switch (side) {
            case DOWN: {
                this.escacheDown = storage;
                break;
            }
            case UP: {
                this.escacheUp = storage;
            }
        }
    }

    public LazyOptional<IEnergyStorage> getCachedEnergy(Direction side) {
        switch (side) {
            case DOWN: {
                return this.escacheDown;
            }
            case UP: {
                return this.escacheUp;
            }
        }
        return LazyOptional.empty();
    }

    public void firstTick() {
        this.updateCache();
    }

    public void updateCache() {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        for (Direction side : Direction.values()) {
            this.updateCache(side);
        }
    }

    public void updateCache(Direction side) {
        if (this.m_58901_()) {
            return;
        }
        if (!this.f_58857_.m_46749_(this.f_58858_.m_121945_(side))) {
            this.setCache(side, (LazyOptional<IEnergyStorage>)LazyOptional.empty());
            return;
        }
        BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_121945_(side));
        if (te == null) {
            this.setCache(side, (LazyOptional<IEnergyStorage>)LazyOptional.empty());
            return;
        }
        LazyOptional le = te.getCapability(CapabilityEnergy.ENERGY, side.m_122424_());
        if (side != Direction.UP && side != Direction.DOWN) {
            return;
        }
        if (le.equals(this.getCachedEnergy(side))) {
            return;
        }
        this.setCache(side, (LazyOptional<IEnergyStorage>)le);
        le.addListener(es -> this.updateCache(side));
    }

    protected void updateConnectivity() {
        this.updateConnectivity = false;
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        CAConnectivityHandler.formMulti(this);
    }

    public void tick() {
        super.tick();
        if (this.firstTickState) {
            this.firstTick();
        }
        this.firstTickState = false;
        this.tickOutput();
        if (this.syncCooldown > 0) {
            --this.syncCooldown;
            if (this.syncCooldown == 0 && this.queuedSync) {
                this.sendData();
            }
        }
        if (this.lastKnownPos == null) {
            this.lastKnownPos = this.m_58899_();
        } else if (!this.lastKnownPos.equals((Object)this.f_58858_) && this.f_58858_ != null) {
            this.onPositionChanged();
            return;
        }
        if (this.updateConnectivity) {
            this.updateConnectivity();
        }
        if (!this.isController()) {
            return;
        }
        if (Math.abs(this.lastEnergy - this.energyStorage.getEnergyStored()) > 256) {
            this.lastEnergy = this.energyStorage.getEnergyStored();
            this.onEnergyChanged();
        }
        if (this.f_58857_.m_5776_()) {
            this.gauge.tickChaser();
            float current = this.gauge.getValue(1.0f);
            if (current > 1.0f && Create.RANDOM.nextFloat() < 0.5f) {
                this.gauge.setValueNoUpdate((double)(current + Math.min(-(current - 1.0f) * Create.RANDOM.nextFloat(), 0.0f)));
            }
            return;
        }
    }

    public void tickOutput() {
        if (this.getControllerBE() == null) {
            return;
        }
        BlockState state = this.m_58900_();
        if (((Boolean)state.m_61143_((Property)ModularAccumulatorBlock.TOP)).booleanValue()) {
            this.tickOutputSide(Direction.UP);
        }
        if (((Boolean)state.m_61143_((Property)ModularAccumulatorBlock.BOTTOM)).booleanValue()) {
            this.tickOutputSide(Direction.DOWN);
        }
    }

    public void tickOutputSide(Direction side) {
        IEnergyStorage ies = (IEnergyStorage)this.getCachedEnergy(side).orElse(null);
        if (ies == null) {
            return;
        }
        int ext = this.getControllerBE().energyStorage.extractEnergy(ies.receiveEnergy(MAX_OUT, true), false);
        int rec = ies.receiveEnergy(ext, false);
    }

    public BlockPos getLastKnownPos() {
        return this.lastKnownPos;
    }

    public boolean isController() {
        return this.controller == null || this.f_58858_.m_123341_() == this.controller.m_123341_() && this.f_58858_.m_123342_() == this.controller.m_123342_() && this.f_58858_.m_123343_() == this.controller.m_123343_();
    }

    public void initialize() {
        super.initialize();
        this.sendData();
        if (this.f_58857_.f_46443_) {
            this.invalidateRenderBoundingBox();
        }
    }

    private void onPositionChanged() {
        this.removeController(true);
        this.lastKnownPos = this.f_58858_;
    }

    protected void onEnergyChanged() {
        if (!this.m_58898_()) {
            return;
        }
        for (int yOffset = 0; yOffset < this.height; ++yOffset) {
            for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                    BlockPos pos = this.f_58858_.m_7918_(xOffset, yOffset, zOffset);
                    ModularAccumulatorTileEntity acc = (ModularAccumulatorTileEntity)CAConnectivityHandler.partAt(this.m_58903_(), (BlockGetter)this.f_58857_, pos);
                    if (acc == null) continue;
                    this.f_58857_.m_46717_(pos, acc.m_58900_().m_60734_());
                }
            }
        }
        if (!this.f_58857_.f_46443_) {
            this.m_6596_();
            this.sendData();
        }
    }

    public ModularAccumulatorTileEntity getControllerBE() {
        if (this.isController()) {
            return this;
        }
        BlockEntity tileEntity = this.f_58857_.m_7702_(this.controller);
        if (tileEntity instanceof ModularAccumulatorTileEntity) {
            return (ModularAccumulatorTileEntity)tileEntity;
        }
        return null;
    }

    public void applySize(int blocks) {
        this.energyStorage.setCapacity(blocks * ModularAccumulatorTileEntity.getCapacityMultiplier());
        int overflow = this.energyStorage.getEnergyStored() - this.energyStorage.getMaxEnergyStored();
        if (overflow > 0) {
            this.energyStorage.extractEnergy(overflow, false);
        }
    }

    public void removeController(boolean keepEnergy) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.updateConnectivity = true;
        if (!keepEnergy) {
            this.applySize(1);
        }
        this.controller = null;
        this.width = 1;
        this.height = 1;
        this.onEnergyChanged();
        BlockState state = this.m_58900_();
        if (ModularAccumulatorBlock.isAccumulator(state)) {
            state = (BlockState)state.m_61124_((Property)ModularAccumulatorBlock.BOTTOM, (Comparable)Boolean.valueOf(true));
            state = (BlockState)state.m_61124_((Property)ModularAccumulatorBlock.TOP, (Comparable)Boolean.valueOf(true));
            this.m_58904_().m_7731_(this.f_58858_, state, 22);
        }
        this.refreshCapability();
        this.m_6596_();
        this.sendData();
    }

    public void sendDataImmediately() {
        this.syncCooldown = 0;
        this.queuedSync = false;
        this.sendData();
    }

    public void sendData() {
        if (this.syncCooldown > 0) {
            this.queuedSync = true;
            return;
        }
        super.sendData();
        this.queuedSync = false;
        this.syncCooldown = 8;
    }

    public void setController(BlockPos controller) {
        if (this.f_58857_.f_46443_ && !this.isVirtual()) {
            return;
        }
        if (controller.equals((Object)this.controller)) {
            return;
        }
        this.controller = controller;
        this.refreshCapability();
        this.m_6596_();
        this.sendData();
    }

    private void refreshCapability() {
        LazyOptional<IEnergyStorage> oldCap = this.energyCap;
        this.energyCap = LazyOptional.of(() -> this.handlerForCapability());
        oldCap.invalidate();
    }

    private InternalEnergyStorage handlerForCapability() {
        return this.isController() ? this.energyStorage : (this.getControllerBE() != null ? this.getControllerBE().handlerForCapability() : new InternalEnergyStorage(0, MAX_IN, MAX_OUT));
    }

    public BlockPos getController() {
        return this.isController() ? this.f_58858_ : this.controller;
    }

    protected AABB createRenderBoundingBox() {
        if (this.isController()) {
            return super.createRenderBoundingBox().m_82363_((double)(this.width - 1), (double)(this.height - 1), (double)(this.width - 1));
        }
        return super.createRenderBoundingBox();
    }

    @Nullable
    public ModularAccumulatorTileEntity getOtherTileEntity(Direction direction) {
        BlockEntity otherTE = this.f_58857_.m_7702_(this.f_58858_.m_121945_(direction));
        if (otherTE instanceof ModularAccumulatorTileEntity) {
            return (ModularAccumulatorTileEntity)otherTE;
        }
        return null;
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        boolean changeOfController;
        super.read(compound, clientPacket);
        BlockPos controllerBefore = this.controller;
        int prevSize = this.width;
        int prevHeight = this.height;
        this.updateConnectivity = compound.m_128441_("Uninitialized");
        this.controller = null;
        this.lastKnownPos = null;
        if (compound.m_128441_("LastKnownPos")) {
            this.lastKnownPos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("LastKnownPos"));
        }
        if (compound.m_128441_("Controller")) {
            this.controller = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("Controller"));
        }
        if (this.isController()) {
            this.width = compound.m_128451_("Size");
            this.height = compound.m_128451_("Height");
            this.energyStorage.setCapacity(this.getTotalAccumulatorSize() * ModularAccumulatorTileEntity.getCapacityMultiplier());
            this.energyStorage.read(compound.m_128469_("EnergyContent"));
            if (this.energyStorage.getSpace() < 0) {
                this.energyStorage.extractEnergy(-this.energyStorage.getSpace(), true);
            }
        }
        if (!clientPacket) {
            return;
        }
        boolean bl = controllerBefore == null ? this.controller != null : (changeOfController = !controllerBefore.equals((Object)this.controller));
        if (changeOfController || prevSize != this.width || prevHeight != this.height) {
            if (this.m_58898_()) {
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 16);
            }
            if (this.isController()) {
                this.energyStorage.setCapacity(ModularAccumulatorTileEntity.getCapacityMultiplier() * this.getTotalAccumulatorSize());
            }
            this.invalidateRenderBoundingBox();
        }
        if (this.isController()) {
            this.gauge.chase((double)this.getFillState(), 0.125, LerpedFloat.Chaser.EXP);
        }
    }

    public float getFillState() {
        return (float)this.energyStorage.getEnergyStored() / (float)this.energyStorage.getMaxEnergyStored();
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        if (this.updateConnectivity) {
            compound.m_128379_("Uninitialized", true);
        }
        if (this.lastKnownPos != null) {
            compound.m_128365_("LastKnownPos", (Tag)NbtUtils.m_129224_((BlockPos)this.lastKnownPos));
        }
        if (!this.isController()) {
            compound.m_128365_("Controller", (Tag)NbtUtils.m_129224_((BlockPos)this.controller));
        }
        if (this.isController()) {
            compound.m_128365_("EnergyContent", (Tag)this.energyStorage.write(new CompoundTag()));
            compound.m_128405_("EnergyCapacity", this.getTotalAccumulatorSize() * ModularAccumulatorTileEntity.getCapacityMultiplier());
            compound.m_128405_("Size", this.width);
            compound.m_128405_("Height", this.height);
        }
        super.write(compound, clientPacket);
        if (!clientPacket) {
            return;
        }
        if (this.queuedSync) {
            compound.m_128379_("LazySync", true);
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (!this.energyCap.isPresent()) {
            this.refreshCapability();
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyCap.cast();
        }
        if (CreateAddition.CC_ACTIVE && Peripherals.isPeripheral(cap)) {
            return this.peripheral.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidate() {
        this.energyCap.invalidate();
        super.invalidate();
    }

    public int getTotalAccumulatorSize() {
        return this.width * this.width * this.height;
    }

    public static int getCapacityMultiplier() {
        return (Integer)Config.ACCUMULATOR_CAPACITY.get();
    }

    public static int getMaxHeight() {
        return MAX_HEIGHT;
    }

    public int getMaxWidth() {
        return MAX_WIDTH;
    }

    public void preventConnectivityUpdate() {
        this.updateConnectivity = false;
    }

    public void notifyMultiUpdated() {
        BlockState state = this.m_58900_();
        if (ModularAccumulatorBlock.isAccumulator(state)) {
            state = (BlockState)state.m_61124_((Property)ModularAccumulatorBlock.BOTTOM, (Comparable)Boolean.valueOf(this.getController().m_123342_() == this.m_58899_().m_123342_()));
            state = (BlockState)state.m_61124_((Property)ModularAccumulatorBlock.TOP, (Comparable)Boolean.valueOf(this.getController().m_123342_() + this.height - 1 == this.m_58899_().m_123342_()));
            this.f_58857_.m_7731_(this.m_58899_(), state, 7);
        }
        this.m_6596_();
    }

    public Direction.Axis getMainConnectionAxis() {
        return Direction.Axis.Y;
    }

    public int getMaxLength(Direction.Axis longAxis, int width) {
        if (longAxis == Direction.Axis.Y) {
            return ModularAccumulatorTileEntity.getMaxHeight();
        }
        return this.getMaxWidth();
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        ModularAccumulatorTileEntity controllerTE = this.getControllerBE();
        if (controllerTE == null) {
            return false;
        }
        ObservePacket.send(this.f_58858_, 0);
        tooltip.add((Component)Component.m_237113_((String)"    ").m_7220_((Component)Component.m_237115_((String)"createaddition.tooltip.accumulator.info").m_130940_(ChatFormatting.WHITE)));
        tooltip.add((Component)Component.m_237113_((String)"    ").m_7220_((Component)Component.m_237115_((String)"createaddition.tooltip.energy.stored").m_130940_(ChatFormatting.GRAY)));
        tooltip.add((Component)Component.m_237113_((String)"    ").m_7220_((Component)Component.m_237113_((String)" ")).m_130946_(Util.format(EnergyNetworkPacket.clientBuff)).m_130946_("fe").m_130940_(ChatFormatting.AQUA));
        tooltip.add((Component)Component.m_237113_((String)"    ").m_7220_((Component)Component.m_237115_((String)"createaddition.tooltip.energy.capacity").m_130940_(ChatFormatting.GRAY)));
        tooltip.add((Component)Component.m_237113_((String)"    ").m_7220_((Component)Component.m_237113_((String)" ")).m_130946_(Util.format(controllerTE.energyStorage.getMaxEnergyStored())).m_130946_("fe").m_130940_(ChatFormatting.AQUA));
        return true;
    }

    public void observe() {
        if (!this.isController()) {
            return;
        }
    }

    @Override
    public void onObserved(ServerPlayer player, ObservePacket pack) {
        ModularAccumulatorTileEntity controllerTE = this.getControllerBE();
        if (controllerTE == null) {
            return;
        }
        EnergyNetworkPacket.send(this.f_58858_, 0, controllerTE.energyStorage.getEnergyStored(), player);
    }

    public boolean hasAccumulator() {
        return true;
    }

    public int getSize(int accumulator) {
        return ModularAccumulatorTileEntity.getCapacityMultiplier();
    }

    public void setSize(int accumulator, int blocks) {
        this.applySize(blocks);
    }

    public InternalEnergyStorage getEnergy() {
        return this.energyStorage;
    }

    @Override
    public void drawDebug() {
        if (this.f_58857_ == null) {
            return;
        }
        ModularAccumulatorTileEntity controller = this.getControllerBE();
        if (controller == null) {
            return;
        }
        VoxelShape shape = this.f_58857_.m_8055_(controller.m_58899_()).m_60816_((BlockGetter)this.f_58857_, controller.m_58899_());
        CreateClient.OUTLINER.chaseAABB((Object)"ca_accumulator", shape.m_83215_().m_82338_(controller.m_58899_())).lineWidth(0.0625f).colored(0xFF5B5B);
    }

    public float getPercent() {
        ModularAccumulatorTileEntity controllerTE = this.getControllerBE();
        if (controllerTE == null) {
            return 0.0f;
        }
        return controllerTE.getFillState() * 100.0f;
    }
}

