/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.modular_accumulator;

import com.mrh0.createaddition.blocks.modular_accumulator.CAConnectivityHandler;
import com.mrh0.createaddition.blocks.modular_accumulator.ModularAccumulatorTileEntity;
import com.mrh0.createaddition.index.CATileEntities;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.blockEntity.ComparatorUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.ForgeSoundType;

public class ModularAccumulatorBlock
extends Block
implements IWrenchable,
IBE<ModularAccumulatorTileEntity> {
    public static final BooleanProperty TOP = BooleanProperty.m_61465_((String)"top");
    public static final BooleanProperty BOTTOM = BooleanProperty.m_61465_((String)"bottom");
    private boolean creative;
    static final VoxelShape CAMPFIRE_SMOKE_CLIP = Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final SoundType SILENCED_METAL = new ForgeSoundType(0.1f, 1.5f, () -> SoundEvents.f_12062_, () -> SoundEvents.f_12068_, () -> SoundEvents.f_12065_, () -> SoundEvents.f_12064_, () -> SoundEvents.f_12063_);

    public static ModularAccumulatorBlock regular(BlockBehaviour.Properties props) {
        return new ModularAccumulatorBlock(props, false);
    }

    public static ModularAccumulatorBlock creative(BlockBehaviour.Properties props) {
        return new ModularAccumulatorBlock(props, true);
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
    }

    public static boolean isAccumulator(BlockState state) {
        return state.m_60734_() instanceof ModularAccumulatorBlock;
    }

    protected ModularAccumulatorBlock(BlockBehaviour.Properties p_i48440_1_, boolean creative) {
        super(p_i48440_1_);
        this.creative = creative;
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)TOP, (Comparable)Boolean.valueOf(true))).m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(true)));
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean moved) {
        if (oldState.m_60734_() == state.m_60734_()) {
            return;
        }
        if (moved) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)world, pos, ModularAccumulatorTileEntity::updateConnectivity);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TOP, BOTTOM});
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        return InteractionResult.SUCCESS;
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (pContext == CollisionContext.m_82749_()) {
            return CAMPFIRE_SMOKE_CLIP;
        }
        return pState.m_60808_(pLevel, pPos);
    }

    public VoxelShape m_7947_(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return Shapes.m_83144_();
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        return pState;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_155947_() && (state.m_60734_() != newState.m_60734_() || !newState.m_155947_())) {
            BlockEntity te = world.m_7702_(pos);
            if (!(te instanceof ModularAccumulatorTileEntity)) {
                return;
            }
            ModularAccumulatorTileEntity accumulatorTE = (ModularAccumulatorTileEntity)te;
            world.m_46747_(pos);
            CAConnectivityHandler.splitMulti(accumulatorTE);
        }
    }

    public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, Entity entity) {
        SoundType soundType = super.getSoundType(state, world, pos, entity);
        if (entity != null && entity.getPersistentData().m_128441_("SilenceTankSound")) {
            return SILENCED_METAL;
        }
        return soundType;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        return this.getBlockEntityOptional((BlockGetter)worldIn, pos).map(ModularAccumulatorTileEntity::getControllerBE).map(te -> ComparatorUtil.fractionToRedstoneLevel((double)te.getFillState())).orElse(0);
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        BlockEntity tileentity;
        BlockEntity blockEntity = tileentity = state.m_155947_() ? worldIn.m_7702_(pos) : null;
        if (tileentity != null && tileentity instanceof ModularAccumulatorTileEntity) {
            ((ModularAccumulatorTileEntity)tileentity).updateCache();
        }
    }

    public Class<ModularAccumulatorTileEntity> getBlockEntityClass() {
        return ModularAccumulatorTileEntity.class;
    }

    public BlockEntityType<? extends ModularAccumulatorTileEntity> getBlockEntityType() {
        return (BlockEntityType)CATileEntities.MODULAR_ACCUMULATOR.get();
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return CATileEntities.MODULAR_ACCUMULATOR.create(pos, state);
    }
}

