/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.mixin;

import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.piston.PistonStructureResolver;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import vazkii.quark.base.handler.QuarkPistonStructureResolver;
import vazkii.quark.content.automation.module.PistonsMoveTileEntitiesModule;
import vazkii.quark.content.experimental.module.GameNerfsModule;

@Mixin(value={PistonBaseBlock.class})
public class PistonBaseBlockMixin {
    @Unique
    private BlockPos oldPos;
    @Unique
    private BlockState newState;
    @Unique
    private Map<BlockPos, BlockState> storedMap;

    @Redirect(method={"isPushable"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;hasBlockEntity()Z"))
    private static boolean isPushable(BlockState blockStateIn) {
        return PistonsMoveTileEntitiesModule.shouldMoveTE(blockStateIn.m_155947_(), blockStateIn);
    }

    @Inject(method={"moveBlocks"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/piston/PistonStructureResolver;getToPush()Ljava/util/List;")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void moveBlocks(Level worldIn, BlockPos pos, Direction directionIn, boolean extending, CallbackInfoReturnable<Boolean> callbackInfoReturnable, BlockPos _pos, PistonStructureResolver pistonBlockStructureHelper) {
        PistonsMoveTileEntitiesModule.detachTileEntities(worldIn, pistonBlockStructureHelper, directionIn, extending);
    }

    @Redirect(method={"checkIfExtend", "moveBlocks"}, at=@At(value="NEW", target="net/minecraft/world/level/block/piston/PistonStructureResolver"))
    private PistonStructureResolver transformStructureHelper(Level worldIn, BlockPos posIn, Direction pistonFacing, boolean extending) {
        return new QuarkPistonStructureResolver(new PistonStructureResolver(worldIn, posIn, pistonFacing, extending), worldIn, posIn, pistonFacing, extending);
    }

    @ModifyVariable(method={"moveBlocks"}, at=@At(value="STORE", ordinal=0), index=15, ordinal=2, slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addDestroyBlockEffect(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V"), to=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/piston/MovingPistonBlock;newMovingBlockEntity(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/Direction;ZZ)Lnet/minecraft/world/level/block/entity/BlockEntity;")))
    private BlockPos storeOldPos(BlockPos pos) {
        this.oldPos = pos;
        return pos;
    }

    @ModifyVariable(method={"moveBlocks"}, at=@At(value="STORE", ordinal=0), slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/piston/PistonStructureResolver;resolve()Z"), to=@At(value="INVOKE", target="Lcom/google/common/collect/Lists;newArrayList()Ljava/util/ArrayList;")))
    private Map<BlockPos, BlockState> storeMap(Map<BlockPos, BlockState> map) {
        this.storedMap = map;
        return map;
    }

    @Inject(method={"moveBlocks"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;I)Z", ordinal=2, shift=At.Shift.AFTER)})
    private void modifyBlockstate(Level worldIn, BlockPos posIn, Direction pistonFacing, boolean extending, CallbackInfoReturnable<Boolean> cir) {
        if (GameNerfsModule.stopPistonPhysicsExploits()) {
            this.newState = worldIn.m_8055_(this.oldPos);
            this.storedMap.replace(this.oldPos, this.newState);
        }
    }

    @ModifyArg(method={"moveBlocks"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/piston/MovingPistonBlock;newMovingBlockEntity(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/Direction;ZZ)Lnet/minecraft/world/level/block/entity/BlockEntity;", ordinal=0), index=2)
    private BlockState modifyMovingBlockEntityState(BlockState state) {
        return GameNerfsModule.stopPistonPhysicsExploits() ? this.newState : state;
    }

    @Inject(method={"moveBlocks"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;setBlockEntity(Lnet/minecraft/world/level/block/entity/BlockEntity;)V", ordinal=0, shift=At.Shift.AFTER)})
    private void setOldPosToAir(Level worldIn, BlockPos pos, Direction directionIn, boolean extending, CallbackInfoReturnable<Boolean> cir) {
        if (GameNerfsModule.stopPistonPhysicsExploits()) {
            worldIn.m_7731_(this.oldPos, Blocks.f_50016_.m_49966_(), 1046);
        }
    }
}

