/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.block.be;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import vazkii.arl.block.be.ARLBlockEntity;
import vazkii.quark.base.handler.QuarkSounds;
import vazkii.quark.content.world.module.MonsterBoxModule;

public class MonsterBoxBlockEntity
extends ARLBlockEntity {
    private int breakProgress;

    public MonsterBoxBlockEntity(BlockPos pos, BlockState state) {
        super(MonsterBoxModule.blockEntityType, pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, MonsterBoxBlockEntity be) {
        boolean doBreak;
        if (level.m_46791_() == Difficulty.PEACEFUL) {
            return;
        }
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        if (level.f_46443_) {
            level.m_7106_((ParticleOptions)(be.breakProgress == 0 ? ParticleTypes.f_123744_ : ParticleTypes.f_123755_), (double)x + Math.random(), (double)y + Math.random(), (double)z + Math.random(), 0.0, 0.0, 0.0);
        }
        boolean bl = doBreak = be.breakProgress > 0;
        if (!doBreak) {
            List players = level.m_6907_();
            for (Player p : players) {
                if (!(p.m_20275_((double)x + 0.5, (double)y + 0.5, (double)z + 0.5) < 6.25) || p.m_5833_()) continue;
                doBreak = true;
                break;
            }
        }
        if (doBreak) {
            if (be.breakProgress == 0) {
                level.m_5594_(null, pos, QuarkSounds.BLOCK_MONSTER_BOX_GROWL, SoundSource.BLOCKS, 0.5f, 1.0f);
            }
            ++be.breakProgress;
            if (be.breakProgress > 40) {
                be.spawnMobs();
                level.m_46796_(2001, pos, Block.m_49956_((BlockState)level.m_8055_(pos)));
                level.m_7471_(pos, false);
            }
        }
    }

    private void spawnMobs() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = this.m_58899_();
            LootTable loot = serverLevel.m_7654_().m_129898_().m_79217_(MonsterBoxModule.MONSTER_BOX_SPAWNS_LOOT_TABLE);
            LootContext.Builder builder = new LootContext.Builder(serverLevel).m_230911_(serverLevel.f_46441_).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_78972_(LootContextParams.f_81461_, (Object)this.m_58900_()).m_78972_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_78972_(LootContextParams.f_81462_, (Object)this);
            LootContext ctx = builder.m_78975_(LootContextParamSets.f_81421_);
            int mobCount = MonsterBoxModule.minMobCount + this.f_58857_.f_46441_.m_188503_(Math.max(MonsterBoxModule.maxMobCount - MonsterBoxModule.minMobCount + 1, 1));
            for (int i = 0; i < mobCount; ++i) {
                loot.m_79131_(ctx, stack -> {
                    Entity e = null;
                    Item patt3459$temp = stack.m_41720_();
                    if (patt3459$temp instanceof SpawnEggItem) {
                        SpawnEggItem egg = (SpawnEggItem)patt3459$temp;
                        EntityType entitytype = egg.m_43228_(stack.m_41783_());
                        e = entitytype.m_20592_(serverLevel, stack, null, pos, MobSpawnType.SPAWNER, true, true);
                        double motionMultiplier = 0.4;
                        e.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
                        double mx = ((double)this.f_58857_.f_46441_.m_188501_() - 0.5) * motionMultiplier;
                        double my = ((double)this.f_58857_.f_46441_.m_188501_() - 0.5) * motionMultiplier;
                        double mz = ((double)this.f_58857_.f_46441_.m_188501_() - 0.5) * motionMultiplier;
                        e.m_20334_(mx, my, mz);
                        e.getPersistentData().m_128379_("quark:monster_box_spawned", true);
                    }
                });
            }
            serverLevel.m_6018_().m_142346_(null, GameEvent.f_157810_, pos);
        }
    }
}

