/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tweaks.module;

import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.hint.Hint;

@LoadModule(category=ModuleCategory.TWEAKS, hasSubscriptions=true)
public class GoldToolsHaveFortuneModule
extends QuarkModule {
    private static final Tier[] TIERS = new Tier[]{Tiers.WOOD, Tiers.STONE, Tiers.IRON, Tiers.DIAMOND, Tiers.NETHERITE};
    @Config
    @Config.Min(value=0.0)
    public static int fortuneLevel = 2;
    @Config
    @Config.Min(value=0.0)
    @Config.Max(value=4.0)
    public static int harvestLevel = 2;
    @Config
    public static boolean displayFortuneInTooltip = true;
    @Config
    public static boolean italicTooltip = true;
    @Hint(key="gold_tool_fortune", content={"fortuneLevel"})
    List<Item> gold_tools = Arrays.asList(Items.f_42433_, Items.f_42434_, Items.f_42432_, Items.f_42431_, Items.f_42430_);
    @Hint(key="gold_tool_harvest_level", content={"harvestLevel"})
    List<Item> gold_tools_2 = this.gold_tools;
    private static boolean staticEnabled;

    @Override
    public void configChanged() {
        staticEnabled = this.enabled;
    }

    @SubscribeEvent
    public void onLootingCheck(LootingLevelEvent event) {
        int level;
        int target;
        LivingEntity le;
        ItemStack stack;
        Entity entity;
        DamageSource source = event.getDamageSource();
        if (source != null && source.m_7639_() != null && (entity = source.m_7639_()) instanceof LivingEntity && (stack = (le = (LivingEntity)entity).m_21205_()).m_41720_() instanceof SwordItem && (target = GoldToolsHaveFortuneModule.getEffectiveLevel(stack, level = event.getLootingLevel())) > level) {
            event.setLootingLevel(target);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onTooltip(ItemTooltipEvent event) {
        Enchantment enchant;
        int enchantLevel;
        if (!displayFortuneInTooltip) {
            return;
        }
        ItemStack stack = event.getItemStack();
        int level = GoldToolsHaveFortuneModule.getEffectiveLevel(stack, 0);
        if (level == fortuneLevel && (enchantLevel = EnchantmentHelper.m_44843_((Enchantment)(enchant = stack.m_41720_() instanceof SwordItem ? Enchantments.f_44982_ : Enchantments.f_44987_), (ItemStack)stack)) < level) {
            Component comp = enchant.m_44700_(level);
            if (italicTooltip) {
                comp = comp.m_6881_().m_130940_(ChatFormatting.ITALIC);
            }
            event.getToolTip().add(comp);
        }
    }

    private static int getEffectiveLevel(ItemStack stack, int prevLvl) {
        TieredItem ti;
        Tier tier;
        Item item = stack.m_41720_();
        if (item instanceof TieredItem && (tier = (ti = (TieredItem)item).m_43314_()) == Tiers.GOLD) {
            return Math.max(prevLvl, fortuneLevel);
        }
        return prevLvl;
    }

    public static int getFortuneLevel(Enchantment enchant, ItemStack stack, int prev) {
        if (!staticEnabled || prev >= fortuneLevel || enchant != Enchantments.f_44987_ || !(stack.m_41720_() instanceof DiggerItem)) {
            return prev;
        }
        return GoldToolsHaveFortuneModule.getEffectiveLevel(stack, prev);
    }

    public static Tier getEffectiveTier(Item item, Tier realTier) {
        if (!staticEnabled || realTier != Tiers.GOLD) {
            return realTier;
        }
        return TIERS[harvestLevel];
    }
}

