/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.mobs.module;

import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.handler.EntityAttributeHandler;
import vazkii.quark.base.handler.advancement.QuarkAdvancementHandler;
import vazkii.quark.base.handler.advancement.QuarkGenericTrigger;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.config.type.CompoundBiomeConfig;
import vazkii.quark.base.module.config.type.DimensionConfig;
import vazkii.quark.base.module.config.type.EntitySpawnConfig;
import vazkii.quark.base.module.hint.Hint;
import vazkii.quark.base.world.EntitySpawnHandler;
import vazkii.quark.content.mobs.client.render.entity.StonelingRenderer;
import vazkii.quark.content.mobs.entity.Stoneling;
import vazkii.quark.content.mobs.item.DiamondHeartItem;

@LoadModule(category=ModuleCategory.MOBS, hasSubscriptions=true)
public class StonelingsModule
extends QuarkModule {
    public static EntityType<Stoneling> stonelingType;
    @Config
    public static int maxYLevel;
    @Config
    public static DimensionConfig dimensions;
    @Config
    public static EntitySpawnConfig spawnConfig;
    @Config(flag="stoneling_drop_diamond_heart")
    public static boolean enableDiamondHeart;
    @Config(description="When enabled, stonelings are much more aggressive in checking for players")
    public static boolean cautiousStonelings;
    @Config
    public static boolean tamableStonelings;
    @Config(description="Disabled if if Pathfinder Maps are disabled.", flag="stoneling_weald_pathfinder")
    public static boolean wealdPathfinderMaps;
    public static QuarkGenericTrigger makeStonelingTrigger;
    @Hint(value="stoneling_drop_diamond_heart")
    public static Item diamondHeart;
    public boolean registered = false;

    @Override
    public void setup() {
        makeStonelingTrigger = QuarkAdvancementHandler.registerGenericTrigger("make_stoneling");
    }

    @Override
    public void register() {
        this.registered = true;
        diamondHeart = new DiamondHeartItem("diamond_heart", this, new Item.Properties().m_41491_(CreativeModeTab.f_40753_));
        stonelingType = EntityType.Builder.m_20704_(Stoneling::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.5f, 0.9f).m_20702_(8).setCustomClientFactory((spawnEntity, world) -> new Stoneling((EntityType<? extends Stoneling>)stonelingType, (Level)world)).m_20712_("stoneling");
        RegistryHelper.register(stonelingType, (String)"stoneling", (ResourceKey)Registry.f_122903_);
        EntitySpawnHandler.registerSpawn(this, stonelingType, MobCategory.MONSTER, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Stoneling::spawnPredicate, spawnConfig);
        EntitySpawnHandler.addEgg(stonelingType, 0xA1A1A1, 0x505050, spawnConfig);
        EntityAttributeHandler.put(stonelingType, Stoneling::prepareAttributes);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        EntityRenderers.m_174036_(stonelingType, StonelingRenderer::new);
    }

    static {
        maxYLevel = 0;
        dimensions = DimensionConfig.overworld(false);
        spawnConfig = new EntitySpawnConfig(80, 1, 1, CompoundBiomeConfig.fromBiomeTags(true, Tags.Biomes.IS_VOID, BiomeTags.f_207612_, BiomeTags.f_215818_));
        enableDiamondHeart = true;
        cautiousStonelings = false;
        tamableStonelings = true;
        wealdPathfinderMaps = true;
    }
}

