/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.mobs.entity;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.network.NetworkHooks;
import vazkii.quark.base.handler.QuarkSounds;
import vazkii.quark.content.mobs.ai.RaveGoal;
import vazkii.quark.content.mobs.module.CrabsModule;

public class Crab
extends Animal
implements IEntityAdditionalSpawnData {
    public static final int COLORS = 3;
    public static final ResourceLocation CRAB_LOOT_TABLE = new ResourceLocation("quark", "entities/crab");
    private static final EntityDataAccessor<Float> SIZE_MODIFIER = SynchedEntityData.m_135353_(Crab.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(Crab.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> RAVING = SynchedEntityData.m_135353_(Crab.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int lightningCooldown;
    private Ingredient temptationItems;
    private boolean noSpike;
    private BlockPos jukeboxPosition;
    private final DynamicGameEventListener<JukeboxListener> dynamicJukeboxListener;

    public Crab(EntityType<? extends Crab> type, Level worldIn) {
        this(type, worldIn, 1.0f);
    }

    public Crab(EntityType<? extends Crab> type, Level worldIn, float sizeModifier) {
        super(type, worldIn);
        this.m_21441_(BlockPathTypes.LAVA, -1.0f);
        if (sizeModifier != 1.0f) {
            this.f_19804_.m_135381_(SIZE_MODIFIER, (Object)Float.valueOf(sizeModifier));
        }
        EntityPositionSource source = new EntityPositionSource((Entity)this, this.m_20192_());
        this.dynamicJukeboxListener = new DynamicGameEventListener((GameEventListener)new JukeboxListener((PositionSource)source, GameEvent.f_238690_.m_157827_()));
    }

    public void m_213651_(@Nonnull BiConsumer<DynamicGameEventListener<?>, ServerLevel> acceptor) {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            acceptor.accept(this.dynamicJukeboxListener, serverlevel);
        }
    }

    public static boolean spawnPredicate(EntityType<? extends Animal> type, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return world.m_8055_(pos.m_7495_()).m_204336_(CrabsModule.crabSpawnableTag) && world.m_46803_(pos) > 8;
    }

    public float m_5610_(BlockPos pos, LevelReader world) {
        return world.m_8055_(pos.m_7495_()).m_204336_(CrabsModule.crabSpawnableTag) ? 10.0f : (float)world.m_45524_(pos, 0) - 0.5f;
    }

    public boolean m_6040_() {
        return true;
    }

    @Nonnull
    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SIZE_MODIFIER, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(VARIANT, (Object)-1);
        this.f_19804_.m_135372_(RAVING, (Object)false);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return QuarkSounds.ENTITY_CRAB_IDLE;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return QuarkSounds.ENTITY_CRAB_DIE;
    }

    @Nullable
    protected SoundEvent m_7975_(@Nonnull DamageSource source) {
        return QuarkSounds.ENTITY_CRAB_HURT;
    }

    protected float m_6431_(@Nonnull Pose pose, EntityDimensions size) {
        return 0.2f * size.f_20378_;
    }

    public float getSizeModifier() {
        return ((Float)this.f_19804_.m_135370_(SIZE_MODIFIER)).floatValue();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(2, (Goal)new RaveGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.2, this.getTemptationItems(), false));
        this.f_21345_.m_25352_(5, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder prepareAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22284_, 3.0).m_22268_(Attributes.f_22285_, 2.0).m_22268_(Attributes.f_22278_, 0.5);
    }

    public void m_8119_() {
        BlockPos below;
        BlockState belowState;
        super.m_8119_();
        if (!this.f_19853_.f_46443_ && (Integer)this.f_19804_.m_135370_(VARIANT) == -1) {
            int variant = 0;
            if (this.f_19796_.m_188499_()) {
                variant += this.f_19796_.m_188503_(2) + 1;
            }
            if (this.f_19796_.m_188503_(3) == 0) {
                variant += 3;
            }
            this.f_19804_.m_135381_(VARIANT, (Object)variant);
        }
        if (this.lightningCooldown > 0) {
            --this.lightningCooldown;
            this.m_20095_();
        }
        if (this.isRaving() && this.f_19853_.f_46443_ && this.f_19797_ % 10 == 0 && (belowState = this.f_19853_.m_8055_(below = this.m_20183_().m_7495_())).m_60767_() == Material.f_76317_) {
            this.f_19853_.m_46796_(2001, below, Block.m_49956_((BlockState)belowState));
        }
        if (this.isRaving() && !this.f_19853_.f_46443_ && this.f_19797_ % 20 == 0 && this.shouldStopRaving()) {
            this.setRaving(false);
            this.jukeboxPosition = null;
        }
    }

    public float getStepHeight() {
        float baseStep = this.f_19798_ ? 1.0f : 0.6f;
        AttributeInstance stepHeightAttribute = this.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get());
        if (stepHeightAttribute != null) {
            return (float)Math.max(0.0, (double)baseStep + stepHeightAttribute.m_22135_());
        }
        return baseStep;
    }

    @Nonnull
    public EntityDimensions m_6972_(@Nonnull Pose poseIn) {
        return super.m_6972_(poseIn).m_20388_(this.getSizeModifier());
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    protected int m_7302_(int air) {
        return air;
    }

    public boolean m_6673_(@Nonnull DamageSource source) {
        return super.m_6673_(source) || source == DamageSource.f_19306_ || this.getSizeModifier() > 1.0f && source.m_19384_();
    }

    public boolean m_5825_() {
        return super.m_5825_() || this.getSizeModifier() > 1.0f;
    }

    public void m_8038_(@Nonnull ServerLevel sworld, @Nonnull LightningBolt lightningBolt) {
        if (this.lightningCooldown > 0 || this.f_19853_.f_46443_) {
            return;
        }
        float sizeMod = this.getSizeModifier();
        if (sizeMod <= 15.0f) {
            AttributeInstance armorAttr;
            AttributeInstance speedAttr;
            AttributeInstance healthAttr = this.m_21051_(Attributes.f_22276_);
            if (healthAttr != null) {
                healthAttr.m_22125_(new AttributeModifier("Lightning Bonus", 0.5, AttributeModifier.Operation.ADDITION));
            }
            if ((speedAttr = this.m_21051_(Attributes.f_22279_)) != null) {
                speedAttr.m_22125_(new AttributeModifier("Lightning Debuff", -0.05, AttributeModifier.Operation.ADDITION));
            }
            if ((armorAttr = this.m_21051_(Attributes.f_22284_)) != null) {
                armorAttr.m_22125_(new AttributeModifier("Lightning Bonus", 0.125, AttributeModifier.Operation.ADDITION));
            }
            float sizeModifier = Math.min(sizeMod + 1.0f, 16.0f);
            this.f_19804_.m_135381_(SIZE_MODIFIER, (Object)Float.valueOf(sizeModifier));
            this.m_6210_();
            this.lightningCooldown = 150;
        }
    }

    public void m_7334_(@Nonnull Entity entityIn) {
        if (this.getSizeModifier() <= 1.0f) {
            super.m_7334_(entityIn);
        }
    }

    protected void m_7324_(@Nonnull Entity entityIn) {
        super.m_7324_(entityIn);
        if (this.f_19853_.m_46791_() != Difficulty.PEACEFUL && !this.noSpike && entityIn instanceof LivingEntity && !(entityIn instanceof Crab)) {
            entityIn.m_6469_(DamageSource.f_19314_, 1.0f);
        }
    }

    public boolean m_6898_(ItemStack stack) {
        return !stack.m_41619_() && this.getTemptationItems().test(stack);
    }

    private Ingredient getTemptationItems() {
        if (this.temptationItems == null) {
            this.temptationItems = Ingredient.merge((Collection)Lists.newArrayList((Object[])new Ingredient[]{Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42405_, Items.f_42581_}), Ingredient.m_204132_((TagKey)ItemTags.f_13156_)}));
        }
        return this.temptationItems;
    }

    @Nullable
    public AgeableMob m_142606_(@Nonnull ServerLevel sworld, @Nonnull AgeableMob other) {
        return new Crab(CrabsModule.crabType, this.f_19853_);
    }

    @Nonnull
    protected ResourceLocation m_7582_() {
        return CRAB_LOOT_TABLE;
    }

    public int getVariant() {
        return Math.max(0, (Integer)this.f_19804_.m_135370_(VARIANT));
    }

    public void party(BlockPos pos, boolean isPartying) {
        if (isPartying) {
            if (!this.isRaving()) {
                this.jukeboxPosition = pos;
                this.setRaving(true);
            }
        } else if (pos.equals((Object)this.jukeboxPosition) || this.jukeboxPosition == null) {
            this.jukeboxPosition = null;
            this.setRaving(false);
        }
    }

    public boolean shouldStopRaving() {
        return this.jukeboxPosition == null || !this.jukeboxPosition.m_203195_((Position)this.m_20182_(), (double)GameEvent.f_238690_.m_157827_()) || !this.f_19853_.m_8055_(this.jukeboxPosition).m_60713_(Blocks.f_50131_);
    }

    public boolean isRaving() {
        return (Boolean)this.f_19804_.m_135370_(RAVING);
    }

    public void setRaving(boolean raving) {
        this.f_19804_.m_135381_(RAVING, (Object)raving);
    }

    public void m_7350_(@Nonnull EntityDataAccessor<?> parameter) {
        if (parameter.equals(SIZE_MODIFIER)) {
            this.m_6210_();
        }
        super.m_7350_(parameter);
    }

    @Nonnull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.getSizeModifier());
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        this.f_19804_.m_135381_(SIZE_MODIFIER, (Object)Float.valueOf(buffer.readFloat()));
    }

    public void m_7378_(@Nonnull CompoundTag compound) {
        super.m_7378_(compound);
        this.lightningCooldown = compound.m_128451_("LightningCooldown");
        this.noSpike = compound.m_128471_("NoSpike");
        if (compound.m_128441_("EnemyCrabRating")) {
            float sizeModifier = compound.m_128457_("EnemyCrabRating");
            this.f_19804_.m_135381_(SIZE_MODIFIER, (Object)Float.valueOf(sizeModifier));
        }
        if (compound.m_128441_("Variant")) {
            this.f_19804_.m_135381_(VARIANT, (Object)compound.m_128451_("Variant"));
        }
    }

    public void m_7380_(@Nonnull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_("EnemyCrabRating", this.getSizeModifier());
        compound.m_128405_("LightningCooldown", this.lightningCooldown);
        compound.m_128405_("Variant", ((Integer)this.f_19804_.m_135370_(VARIANT)).intValue());
        compound.m_128379_("NoSpike", this.noSpike);
    }

    public class JukeboxListener
    implements GameEventListener {
        private final PositionSource listenerSource;
        private final int listenerRadius;

        public JukeboxListener(PositionSource source, int radius) {
            this.listenerSource = source;
            this.listenerRadius = radius;
        }

        @Nonnull
        public PositionSource m_142460_() {
            return this.listenerSource;
        }

        public int m_142078_() {
            return this.listenerRadius;
        }

        public boolean m_214068_(@Nonnull ServerLevel level, GameEvent.Message message) {
            if (message.m_223740_() == GameEvent.f_238690_) {
                Crab.this.party(new BlockPos(message.m_223743_()), true);
                return true;
            }
            if (message.m_223740_() == GameEvent.f_238649_) {
                Crab.this.party(new BlockPos(message.m_223743_()), false);
                return true;
            }
            return false;
        }
    }
}

