/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.building.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemFrameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderItemInFrameEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import vazkii.quark.content.building.entity.GlassItemFrame;
import vazkii.quark.content.building.module.GlassItemFrameModule;

@OnlyIn(value=Dist.CLIENT)
public class GlassItemFrameRenderer
extends EntityRenderer<GlassItemFrame> {
    private static final ModelResourceLocation LOCATION_MODEL = new ModelResourceLocation(new ResourceLocation("quark", "extra/glass_item_frame"), "inventory");
    private static final List<Direction> SIGN_DIRECTIONS = List.of(Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST);
    private static final BannerBlockEntity banner = new BannerBlockEntity(BlockPos.f_121853_, Blocks.f_50414_.m_49966_());
    private final ModelPart bannerModel;
    private final Minecraft mc = Minecraft.m_91087_();
    private final ItemRenderer itemRenderer;
    private final ItemFrameRenderer<?> defaultRenderer;

    public GlassItemFrameRenderer(EntityRendererProvider.Context context) {
        super(context);
        ModelPart part = context.m_174023_(ModelLayers.f_171264_);
        this.bannerModel = part.m_171324_("flag");
        Minecraft mc = Minecraft.m_91087_();
        this.itemRenderer = mc.m_91291_();
        this.defaultRenderer = (ItemFrameRenderer)mc.m_91290_().f_114362_.get(EntityType.f_20462_);
    }

    public void render(@Nonnull GlassItemFrame frame, float yaw, float partialTicks, @Nonnull PoseStack matrix, @Nonnull MultiBufferSource buffer, int light) {
        super.m_7392_((Entity)frame, yaw, partialTicks, matrix, buffer, light);
        matrix.m_85836_();
        Direction direction = frame.m_6350_();
        Vec3 Vector3d = this.getRenderOffset(frame, partialTicks);
        matrix.m_85837_(-Vector3d.m_7096_(), -Vector3d.m_7098_(), -Vector3d.m_7094_());
        matrix.m_85837_((double)direction.m_122429_() * 0.46875, (double)direction.m_122430_() * 0.46875, (double)direction.m_122431_() * 0.46875);
        matrix.m_85845_(Vector3f.f_122223_.m_122240_(frame.m_146909_()));
        matrix.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - frame.m_146908_()));
        BlockRenderDispatcher blockrendererdispatcher = this.mc.m_91289_();
        ModelManager modelmanager = blockrendererdispatcher.m_110907_().m_110881_();
        ItemStack itemstack = frame.m_31822_();
        if (((Boolean)frame.m_20088_().m_135370_(GlassItemFrame.IS_SHINY)).booleanValue()) {
            light = 0xF000F0;
        }
        if (itemstack.m_41619_()) {
            matrix.m_85836_();
            matrix.m_85837_(-0.5, -0.5, -0.5);
            blockrendererdispatcher.m_110937_().m_111067_(matrix.m_85850_(), buffer.m_6299_(Sheets.m_110790_()), null, modelmanager.m_119422_(LOCATION_MODEL), 1.0f, 1.0f, 1.0f, light, OverlayTexture.f_118083_);
            matrix.m_85849_();
        } else {
            this.renderItemStack(frame, matrix, buffer, light, itemstack);
        }
        matrix.m_85849_();
    }

    @Nonnull
    public Vec3 getRenderOffset(GlassItemFrame frame, float partialTicks) {
        return new Vec3((double)((float)frame.m_6350_().m_122429_() * 0.3f), -0.25, (double)((float)frame.m_6350_().m_122431_() * 0.3f));
    }

    @Nonnull
    public ResourceLocation getTextureLocation(@Nonnull GlassItemFrame frame) {
        return TextureAtlas.f_118259_;
    }

    protected boolean shouldShowName(@Nonnull GlassItemFrame frame) {
        if (Minecraft.m_91404_() && !frame.m_31822_().m_41619_() && frame.m_31822_().m_41788_() && this.f_114476_.f_114359_ == frame) {
            double d0 = this.f_114476_.m_114471_((Entity)frame);
            float f = frame.m_20163_() ? 32.0f : 64.0f;
            return d0 < (double)(f * f);
        }
        return false;
    }

    protected void renderNameTag(@Nonnull GlassItemFrame frame, @Nonnull Component text, @Nonnull PoseStack matrix, @Nonnull MultiBufferSource buffer, int light) {
        super.m_7649_((Entity)frame, frame.m_31822_().m_41786_(), matrix, buffer, light);
    }

    protected void renderItemStack(GlassItemFrame itemFrame, PoseStack matrix, MultiBufferSource buff, int light, ItemStack stack) {
        if (!stack.m_41619_()) {
            matrix.m_85836_();
            MapItemSavedData mapdata = MapItem.m_42853_((ItemStack)stack, (Level)itemFrame.f_19853_);
            if (itemFrame.isOnSign()) {
                BlockPos back = itemFrame.getBehindPos();
                BlockState state = itemFrame.f_19853_.m_8055_(back);
                Direction ourDirection = itemFrame.m_6350_().m_122424_();
                int signRotation = (Integer)state.m_61143_((Property)StandingSignBlock.f_56987_);
                Direction signDirection = SIGN_DIRECTIONS.get(signRotation / 4);
                if (!(signRotation % 4 == 0 ? signDirection != ourDirection : signDirection.m_122424_() == ourDirection)) {
                    int ourRotation = SIGN_DIRECTIONS.indexOf(ourDirection) * 4;
                    int rotation = signRotation - ourRotation;
                    float angle = (float)(-rotation) * 22.5f;
                    matrix.m_85837_(0.0, 0.35, 0.8);
                    matrix.m_85841_(0.4f, 0.4f, 0.4f);
                    matrix.m_85837_(0.0, 0.0, 0.5);
                    matrix.m_85845_(Vector3f.f_122225_.m_122240_(angle));
                    matrix.m_85837_(0.0, 0.0, -0.5);
                    matrix.m_85837_(0.0, 0.0, -0.085);
                }
            }
            int rotation = mapdata != null ? itemFrame.m_31823_() % 4 * 2 : itemFrame.m_31823_();
            matrix.m_85845_(Vector3f.f_122227_.m_122240_((float)rotation * 360.0f / 8.0f));
            if (!MinecraftForge.EVENT_BUS.post((Event)new RenderItemInFrameEvent((ItemFrame)itemFrame, this.defaultRenderer, matrix, buff, light))) {
                if (mapdata != null) {
                    matrix.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
                    matrix.m_85841_(0.0078125f, 0.0078125f, 0.0078125f);
                    matrix.m_85837_(-64.0, -64.0, 62.5);
                    Integer mapID = MapItem.m_151131_((ItemStack)stack);
                    this.mc.f_91063_.m_109151_().m_168771_(matrix, buff, mapID.intValue(), mapdata, true, light);
                } else {
                    float s = (float)GlassItemFrameModule.itemRenderScale;
                    Item signRotation = stack.m_41720_();
                    if (signRotation instanceof BannerItem) {
                        BannerItem bannerItem = (BannerItem)signRotation;
                        banner.m_58489_(stack, bannerItem.m_40545_());
                        List patterns = banner.m_58508_();
                        matrix.m_85836_();
                        matrix.m_85837_((double)1.0E-4f, (double)-0.5001f, (double)0.55f);
                        matrix.m_85841_(0.799999f, 0.399999f, 0.5f);
                        BannerRenderer.m_112065_((PoseStack)matrix, (MultiBufferSource)buff, (int)light, (int)OverlayTexture.f_118083_, (ModelPart)this.bannerModel, (Material)ModelBakery.f_119224_, (boolean)true, (List)patterns);
                        matrix.m_85849_();
                    } else {
                        if (stack.m_41720_() instanceof ShieldItem) {
                            matrix.m_85837_(-0.25, 0.0, 0.5);
                            matrix.m_85841_(s *= 2.6666667f, s, s);
                        } else {
                            matrix.m_85837_(0.0, 0.0, (double)0.475f);
                            matrix.m_85841_(s, s, s);
                        }
                        matrix.m_85841_(0.5f, 0.5f, 0.5f);
                        this.itemRenderer.m_174269_(stack, ItemTransforms.TransformType.FIXED, light, OverlayTexture.f_118083_, matrix, buff, 0);
                    }
                }
            }
            matrix.m_85849_();
        }
    }
}

