/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.handler;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.recipe.DyeRecipe;

@Mod.EventBusSubscriber(modid="quark", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public final class DyeHandler {
    private static final Map<Item, Supplier<Boolean>> dyeableConditions = new HashMap<Item, Supplier<Boolean>>();
    private static final DyeSurrogate SURROGATE = new DyeSurrogate();

    public static void register() {
        ForgeRegistries.RECIPE_SERIALIZERS.register("quark:dye_item", DyeRecipe.SERIALIZER);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientSetup(ParallelDispatchEvent event) {
        ResourceLocation res = new ResourceLocation("quark_dyed");
        ItemColors colors = Minecraft.m_91087_().getItemColors();
        ItemPropertyFunction fun = (s, e, l, i) -> DyeHandler.isDyed(s) ? 1.0f : 0.0f;
        ItemColor color = (s, l) -> {
            if (l != 0 || !DyeHandler.isDyed(s)) {
                return 0xFFFFFF;
            }
            return SURROGATE.m_41121_(s);
        };
        event.enqueueWork(() -> {
            for (Item item : dyeableConditions.keySet()) {
                ItemProperties.register((Item)item, (ResourceLocation)res, (ItemPropertyFunction)fun);
                colors.m_92689_(color, new ItemLike[]{item});
                CauldronInteraction.f_175607_.put(item, DyeHandler::cauldronInteract);
            }
        });
    }

    private static InteractionResult cauldronInteract(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack stack) {
        if (!DyeHandler.isDyed(stack)) {
            return InteractionResult.PASS;
        }
        if (!level.f_46443_) {
            SURROGATE.m_41123_(stack);
            LayeredCauldronBlock.m_153559_((BlockState)state, (Level)level, (BlockPos)pos);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public static void addAlwaysDyeable(Item item) {
        DyeHandler.addDyeable(item, () -> true);
    }

    public static void addDyeable(Item item, QuarkModule module) {
        DyeHandler.addDyeable(item, () -> module.enabled);
    }

    public static void addDyeable(Item item, Supplier<Boolean> cond) {
        dyeableConditions.put(item, cond);
    }

    public static boolean isDyeable(ItemStack stack) {
        Item item = stack.m_41720_();
        return dyeableConditions.containsKey(item) && dyeableConditions.get(item).get() != false;
    }

    public static boolean isDyed(ItemStack stack) {
        return DyeHandler.isDyeable(stack) && SURROGATE.m_41113_(stack);
    }

    public static int getDye(ItemStack stack) {
        return SURROGATE.m_41121_(stack);
    }

    public static void applyDye(ItemStack stack, int color) {
        if (DyeHandler.isDyeable(stack)) {
            SURROGATE.m_41115_(stack, color);
        }
    }

    public static ItemStack dyeItem(ItemStack stack, List<DyeItem> dyes) {
        ItemStack itemstack = ItemStack.f_41583_;
        int[] aint = new int[3];
        int i = 0;
        int j = 0;
        if (DyeHandler.isDyeable(stack)) {
            itemstack = stack.m_41777_();
            itemstack.m_41764_(1);
            if (SURROGATE.m_41113_(stack)) {
                int k = SURROGATE.m_41121_(itemstack);
                float f = (float)(k >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(k >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(k & 0xFF) / 255.0f;
                i += (int)(Math.max(f, Math.max(f1, f2)) * 255.0f);
                aint[0] = aint[0] + (int)(f * 255.0f);
                aint[1] = aint[1] + (int)(f1 * 255.0f);
                aint[2] = aint[2] + (int)(f2 * 255.0f);
                ++j;
            }
            for (DyeItem dyeitem : dyes) {
                float[] afloat = dyeitem.m_41089_().m_41068_();
                int i2 = (int)(afloat[0] * 255.0f);
                int l = (int)(afloat[1] * 255.0f);
                int i1 = (int)(afloat[2] * 255.0f);
                i += Math.max(i2, Math.max(l, i1));
                aint[0] = aint[0] + i2;
                aint[1] = aint[1] + l;
                aint[2] = aint[2] + i1;
                ++j;
            }
            int j1 = aint[0] / j;
            int k1 = aint[1] / j;
            int l1 = aint[2] / j;
            float f3 = (float)i / (float)j;
            float f4 = Math.max(j1, Math.max(k1, l1));
            j1 = (int)((float)j1 * f3 / f4);
            k1 = (int)((float)k1 * f3 / f4);
            l1 = (int)((float)l1 * f3 / f4);
            int j2 = (j1 << 8) + k1;
            j2 = (j2 << 8) + l1;
            SURROGATE.m_41115_(itemstack, j2);
            return itemstack;
        }
        return ItemStack.f_41583_;
    }

    private static class DyeSurrogate
    implements DyeableLeatherItem {
        private DyeSurrogate() {
        }
    }
}

