/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.customvillagertrades.trades;

import uk.co.dotcode.customvillagertrades.ModLogger;
import uk.co.dotcode.customvillagertrades.trades.MyWandererTrade;

public class WandererTradeCollection {
    public transient String source = "Local Config file";
    public String profession;
    public boolean removeOtherTrades = false;
    public MyWandererTrade[] trades;

    public int numberOfGenericTrades() {
        int count = 0;
        for (MyWandererTrade t : this.trades) {
            if (t.isRare) continue;
            ++count;
        }
        return count;
    }

    public int numberOfRareTrades() {
        int count = 0;
        for (MyWandererTrade t : this.trades) {
            if (!t.isRare) continue;
            ++count;
        }
        return count;
    }

    public WandererTradeCollection build() {
        return this;
    }

    public boolean validate() {
        boolean isValid = true;
        if (this.numberOfGenericTrades() < 5) {
            ModLogger.warn("You must have at least 5 'not-rare' trades for the wanderer!");
            isValid = false;
        }
        if (this.numberOfRareTrades() < 1) {
            ModLogger.warn("You must have at least 1 'rare' trade for the wanderer!");
            isValid = false;
        }
        for (int i = 0; i < this.trades.length; ++i) {
            if (this.trades[i].validate(this.profession, i)) continue;
            isValid = false;
        }
        return isValid;
    }
}

