/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.customvillagertrades;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import uk.co.dotcode.customvillagertrades.ModLogger;
import uk.co.dotcode.customvillagertrades.TradeUtil;
import uk.co.dotcode.customvillagertrades.trades.MyTrade;
import uk.co.dotcode.customvillagertrades.trades.MyTradeEnchantment;
import uk.co.dotcode.customvillagertrades.trades.MyTradeItem;
import uk.co.dotcode.customvillagertrades.trades.TradeCollection;
import uk.co.dotcode.customvillagertrades.trades.WandererTradeCollection;

public class ConfigHandler {
    public static File folder;
    public static File folderWanderer;
    public static File folderExports;
    public static HashMap<String, TradeCollection> customTrades;
    public static HashMap<String, WandererTradeCollection> customWandererTrades;
    public static HashMap<String, HashMap<Integer, VillagerTrades.ItemListing[]>> registeredCustomTrades;
    public static HashMap<Integer, VillagerTrades.ItemListing[]> registeredCustomWandererTrades;
    public static HashMap<Integer, VillagerTrades.ItemListing[]> registeredAllCategoryTrades;

    public static void init() {
        boolean newConfigs = false;
        if (!folder.exists()) {
            folder.mkdir();
            newConfigs = true;
        }
        if (!folderWanderer.exists()) {
            folderWanderer.mkdir();
        }
        if (!folderExports.exists()) {
            folderExports.mkdir();
        }
        File[] fileArray = folder.listFiles();
        File[] fileArrayWanderer = folderWanderer.listFiles();
        if (newConfigs) {
            ModLogger.info("No custom trades were found. Generating example trades...");
            ConfigHandler.generateExampleTrade();
        }
        Gson gson = new Gson();
        for (File f : fileArray) {
            if (f.isDirectory() || !ConfigHandler.isJsonFile(f)) continue;
            ConfigHandler.loadFile(gson, f, false);
        }
        for (File f : fileArrayWanderer) {
            if (f.isDirectory() || !ConfigHandler.isJsonFile(f)) continue;
            ConfigHandler.loadFile(gson, f, true);
        }
    }

    private static void loadFile(Gson gson, File f, boolean isWanderer) {
        String currentProfession = "INVALID";
        ModLogger.info("Loading custom villager trades from file: " + f.getName());
        try (FileReader reader = new FileReader(f);){
            if (isWanderer) {
                WandererTradeCollection wandererTradeCollection = (WandererTradeCollection)gson.fromJson((Reader)reader, WandererTradeCollection.class);
                currentProfession = wandererTradeCollection.profession.toLowerCase();
                customWandererTrades.put(currentProfession, wandererTradeCollection);
            } else {
                TradeCollection tradeCollection = (TradeCollection)gson.fromJson((Reader)reader, TradeCollection.class);
                currentProfession = tradeCollection.profession.toLowerCase();
                customTrades.put(currentProfession, tradeCollection);
            }
        }
        catch (IOException e) {
            ModLogger.error("A problem has been found with the config file for '" + currentProfession + "'! This is most likely an issue where the file can not be found/accessed (which should never happen...)");
            e.printStackTrace();
        }
        catch (JsonSyntaxException e) {
            ModLogger.error("A problem has been found with the config file for '" + currentProfession + "'! This is most likely a formatting issue - take a look over the config for anything that seems out of place (and use a JSON verifier) - Everything needs to match the specification in the mod description. Printed cause: " + e.getCause());
        }
        if (isWanderer) {
            for (Map.Entry<String, Object> entry : customWandererTrades.entrySet()) {
                if (((WandererTradeCollection)entry.getValue()).validate()) continue;
                ModLogger.error("There is a problem with a trade config file! Source: " + ((WandererTradeCollection)entry.getValue()).source + ", Profession: " + ((WandererTradeCollection)entry.getValue()).profession);
            }
        } else {
            for (Map.Entry<String, Object> entry : customTrades.entrySet()) {
                if (((TradeCollection)entry.getValue()).validate()) continue;
                ModLogger.error("There is a problem with a trade config file! Source: " + ((TradeCollection)entry.getValue()).source + ", Profession: " + ((TradeCollection)entry.getValue()).profession);
            }
        }
    }

    public static TradeCollection loadTrades(String profession) {
        return customTrades.get(profession);
    }

    public static WandererTradeCollection loadWandererTrades(String profession) {
        return customWandererTrades.get(profession);
    }

    private static boolean isJsonFile(File f) {
        String extension = f.getPath().substring(f.getPath().lastIndexOf("."));
        return extension.equalsIgnoreCase(".json");
    }

    private static void generateExampleTrade() {
        TradeCollection exampleTrades = new TradeCollection();
        MyTrade exampleOne = new MyTrade();
        exampleOne.offer = new MyTradeItem("minecraft:dirt", 3, 0);
        exampleOne.offer.enchantments = new MyTradeEnchantment[2];
        exampleOne.offer.enchantments[0] = new MyTradeEnchantment("minecraft:knockback", 2);
        exampleOne.offer.enchantments[1] = new MyTradeEnchantment("minecraft:sharpness", -1, 5);
        exampleOne.request = new MyTradeItem("minecraft:cobblestone", 1, 0);
        exampleOne.tradeExp = 3;
        exampleOne.maxUses = 10;
        exampleOne.priceMultiplier = 0.1f;
        exampleOne.tradeLevel = 1;
        MyTrade exampleTwo = new MyTrade();
        exampleTwo.offer = new MyTradeItem("minecraft:emerald", 2, 0);
        exampleTwo.request = new MyTradeItem("minecraft:iron_ingot", 2, 0);
        exampleTwo.additionalRequest = new MyTradeItem("minecraft:gold_ingot", 1, 0);
        exampleTwo.tradeExp = 6;
        exampleTwo.maxUses = 10;
        exampleTwo.priceMultiplier = 0.1f;
        exampleTwo.tradeLevel = 2;
        MyTrade exampleThree = new MyTrade();
        exampleThree.multiOffer = new MyTradeItem[3];
        exampleThree.multiOffer[0] = new MyTradeItem("minecraft:iron_axe", 1, -3);
        exampleThree.multiOffer[1] = new MyTradeItem("minecraft:golden_axe", 1, 0);
        exampleThree.multiOffer[2] = new MyTradeItem("minecraft:diamond_axe", 1, 4);
        exampleThree.request = new MyTradeItem("minecraft:iron_ingot", 6, 0);
        exampleThree.tradeExp = 15;
        exampleThree.maxUses = 5;
        exampleThree.priceMultiplier = 0.1f;
        exampleThree.tradeLevel = 3;
        MyTrade exampleFour = new MyTrade();
        exampleFour.offer = new MyTradeItem("minecraft:wooden_sword", 1, 0);
        exampleFour.offer.semiRandomEnchantments = new MyTradeEnchantment[3];
        exampleFour.offer.semiRandomEnchantments[0] = new MyTradeEnchantment("minecraft:mending", 1);
        exampleFour.offer.semiRandomEnchantments[1] = new MyTradeEnchantment("minecraft:looting", 3);
        exampleFour.offer.semiRandomEnchantments[2] = new MyTradeEnchantment("minecraft:sweeping", 2);
        exampleFour.request = new MyTradeItem("minecraft:quartz", 5, 0);
        exampleFour.tradeExp = 20;
        exampleFour.maxUses = 5;
        exampleFour.priceMultiplier = 0.0f;
        exampleFour.tradeLevel = 4;
        MyTrade exampleFive = new MyTrade();
        exampleFive.offer = new MyTradeItem("minecraft:enchanted_book", 1, 0);
        exampleFive.offer.enchantments = new MyTradeEnchantment[1];
        exampleFive.offer.enchantments[0] = new MyTradeEnchantment("random", 2);
        exampleFive.offer.blacklistedEnchantments = new String[2];
        exampleFive.offer.blacklistedEnchantments[0] = "minecraft:protection";
        exampleFive.offer.blacklistedEnchantments[1] = "minecraft:fire_protection";
        exampleFive.request = new MyTradeItem("minecraft:emerald", 3, 0);
        exampleFive.tradeExp = 3;
        exampleFive.maxUses = 10;
        exampleFive.priceMultiplier = 0.1f;
        exampleFive.tradeLevel = 1;
        MyTrade[] exampleTradeList = new MyTrade[]{exampleOne, exampleTwo, exampleThree, exampleFour, exampleFive};
        exampleTrades.profession = TradeUtil.getKeyFromProfession(VillagerProfession.f_35586_);
        exampleTrades.trades = exampleTradeList;
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        File exportPath = new File(folder, VillagerProfession.f_35586_.toString() + ".json");
        try (FileWriter writer = new FileWriter(exportPath);){
            gson.toJson((Object)exampleTrades, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void exportTradeCollection(TradeCollection coll) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        File exportPath = new File(folderExports, coll.profession.split(":")[1] + ".json");
        try (FileWriter writer = new FileWriter(exportPath);){
            gson.toJson((Object)coll, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void overwriteTradeCollection(TradeCollection coll) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        File exportPath = new File(folder, coll.profession.split(":")[1] + ".json");
        try (FileWriter writer = new FileWriter(exportPath);){
            gson.toJson((Object)coll, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        customTrades = new HashMap();
        customWandererTrades = new HashMap();
        registeredCustomTrades = new HashMap();
        registeredCustomWandererTrades = null;
        registeredAllCategoryTrades = null;
    }
}

