/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.launch;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Optional;
import mod.chiselsandbits.api.launch.ILaunchPropertyManager;
import org.jetbrains.annotations.NotNull;

public final class LaunchPropertyManager
implements ILaunchPropertyManager {
    private static final LaunchPropertyManager INSTANCE = new LaunchPropertyManager();

    public static LaunchPropertyManager getInstance() {
        return INSTANCE;
    }

    private LaunchPropertyManager() {
    }

    @Override
    @NotNull
    public String get(String key, String defaultValue) {
        String sysProValue = System.getProperty("chiselsandbits.launch.prop.%s".formatted(key));
        if (sysProValue == null) {
            return this.getFromLaunchPropFile(key, defaultValue);
        }
        return sysProValue;
    }

    private String getFromLaunchPropFile(String key, String defaultValue) {
        try {
            Path launchPropertiesFilePath = Path.of("config", "chiselsandbits.launchproperties");
            if (!Files.exists(launchPropertiesFilePath, new LinkOption[0])) {
                ArrayList<String> launchPropLines = new ArrayList<String>();
                launchPropLines.add("%s=%s".formatted(key, defaultValue));
                Files.write(launchPropertiesFilePath, launchPropLines, new OpenOption[0]);
                return defaultValue;
            }
            ArrayList<String> launchPropLines = new ArrayList<String>(Files.readAllLines(launchPropertiesFilePath));
            Optional<String> value = launchPropLines.stream().filter(l -> !l.startsWith("#")).filter(l -> l.replace(" ", "").startsWith("%s=".formatted(key))).findFirst().map(l -> l.replace(" ", "").replace("%s=".formatted(key), ""));
            if (value.isEmpty()) {
                launchPropLines.add("%s=%s".formatted(key, defaultValue));
                Files.write(launchPropertiesFilePath, launchPropLines, new OpenOption[0]);
                return defaultValue;
            }
            return value.get();
        }
        catch (IOException e) {
            return defaultValue;
        }
    }
}

