/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.forge.data.recipe;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import mod.chiselsandbits.forge.data.recipe.AbstractRecipeGenerator;
import mod.chiselsandbits.forge.utils.CollectorUtils;
import mod.chiselsandbits.registrars.ModItems;
import mod.chiselsandbits.registrars.ModTags;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="chiselsandbits", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SimpleItemsRecipeGenerator
extends AbstractRecipeGenerator {
    private final boolean shapeless;
    private final List<String> pattern;
    private final Map<Character, TagKey<Item>> tagMap;
    private final Map<Character, ItemLike> itemMap;

    public SimpleItemsRecipeGenerator(DataGenerator generator, ItemLike itemProvider, String pattern, Map<Character, TagKey<Item>> tagMap, Map<Character, ItemLike> itemMap) {
        super(generator, itemProvider);
        this.shapeless = false;
        this.pattern = Arrays.asList(pattern.split(";"));
        this.tagMap = tagMap;
        this.itemMap = itemMap;
    }

    public SimpleItemsRecipeGenerator(DataGenerator generator, ItemLike itemProvider, List<TagKey<Item>> tagMap, List<ItemLike> itemMap) {
        super(generator, itemProvider);
        this.shapeless = true;
        this.pattern = ImmutableList.of((Object)"   ", (Object)"   ", (Object)"   ");
        this.tagMap = tagMap.stream().collect(CollectorUtils.toEnumeratedCharacterKeyedMap());
        this.itemMap = itemMap.stream().collect(CollectorUtils.toEnumeratedCharacterKeyedMap());
    }

    @SubscribeEvent
    public static void dataGeneratorSetup(GatherDataEvent event) {
        event.getGenerator().m_236039_(true, (DataProvider)new SimpleItemsRecipeGenerator(event.getGenerator(), (ItemLike)ModItems.ITEM_BIT_BAG_DEFAULT.get(), "www;wbw;www", (Map<Character, TagKey<Item>>)ImmutableMap.of((Object)Character.valueOf('w'), (Object)ItemTags.f_13167_), (Map<Character, ItemLike>)ImmutableMap.of((Object)Character.valueOf('b'), (Object)((ItemLike)ModItems.ITEM_BLOCK_BIT.get()))));
        event.getGenerator().m_236039_(true, (DataProvider)new SimpleItemsRecipeGenerator(event.getGenerator(), (ItemLike)ModItems.MAGNIFYING_GLASS.get(), "cg ;s  ;   ", (Map<Character, TagKey<Item>>)ImmutableMap.of((Object)Character.valueOf('c'), ModTags.Items.CHISEL, (Object)Character.valueOf('g'), (Object)Tags.Items.GLASS, (Object)Character.valueOf('s'), (Object)Tags.Items.RODS_WOODEN), (Map<Character, ItemLike>)ImmutableMap.of()));
        event.getGenerator().m_236039_(true, (DataProvider)new SimpleItemsRecipeGenerator(event.getGenerator(), (ItemLike)ModItems.MEASURING_TAPE.get(), "  s;isy;ii ", (Map<Character, TagKey<Item>>)ImmutableMap.of((Object)Character.valueOf('i'), (Object)Tags.Items.INGOTS_IRON, (Object)Character.valueOf('s'), (Object)Tags.Items.STRING, (Object)Character.valueOf('y'), (Object)Tags.Items.DYES_YELLOW), (Map<Character, ItemLike>)ImmutableMap.of()));
        event.getGenerator().m_236039_(true, (DataProvider)new SimpleItemsRecipeGenerator(event.getGenerator(), (ItemLike)ModItems.QUILL.get(), (List<TagKey<Item>>)ImmutableList.of((Object)Tags.Items.FEATHERS, (Object)Tags.Items.DYES_BLACK, (Object)Tags.Items.DYES_YELLOW), (List<ItemLike>)ImmutableList.of()));
        event.getGenerator().m_236039_(true, (DataProvider)new SimpleItemsRecipeGenerator(event.getGenerator(), (ItemLike)ModItems.SEALANT_ITEM.get(), (List<TagKey<Item>>)ImmutableList.of((Object)Tags.Items.SLIMEBALLS), (List<ItemLike>)ImmutableList.of((Object)Items.f_42787_)));
        event.getGenerator().m_236039_(true, (DataProvider)new SimpleItemsRecipeGenerator(event.getGenerator(), (ItemLike)ModItems.WRENCH.get(), " pb; pp;p  ", (Map<Character, TagKey<Item>>)ImmutableMap.of((Object)Character.valueOf('p'), (Object)ItemTags.f_13168_), (Map<Character, ItemLike>)ImmutableMap.of((Object)Character.valueOf('b'), (Object)((ItemLike)ModItems.ITEM_BLOCK_BIT.get()))));
        event.getGenerator().m_236039_(true, (DataProvider)new SimpleItemsRecipeGenerator(event.getGenerator(), (ItemLike)ModItems.UNSEAL_ITEM.get(), (List<TagKey<Item>>)ImmutableList.of(), (List<ItemLike>)ImmutableList.of((Object)Blocks.f_50057_)));
    }

    protected void m_176531_(@NotNull Consumer<FinishedRecipe> writer) {
        if (this.shapeless) {
            ShapelessRecipeBuilder builder = ShapelessRecipeBuilder.m_126189_((ItemLike)this.getItemProvider());
            this.tagMap.forEach((ingredientKey, tag) -> {
                builder.m_206419_(tag);
                builder.m_126132_("has_tag_" + ingredientKey, (CriterionTriggerInstance)SimpleItemsRecipeGenerator.m_206406_((TagKey)tag));
            });
            this.itemMap.forEach((ingredientKey, item) -> {
                builder.m_126209_(item);
                builder.m_126132_("has_item_" + ingredientKey, (CriterionTriggerInstance)SimpleItemsRecipeGenerator.m_125977_((ItemLike)item));
            });
            builder.m_176498_(writer);
        } else {
            ShapedRecipeBuilder builder = ShapedRecipeBuilder.m_126116_((ItemLike)this.getItemProvider());
            this.pattern.forEach(arg_0 -> ((ShapedRecipeBuilder)builder).m_126130_(arg_0));
            this.tagMap.forEach((ingredientKey, tag) -> {
                builder.m_206416_(ingredientKey, tag);
                builder.m_126132_("has_" + ingredientKey, (CriterionTriggerInstance)SimpleItemsRecipeGenerator.m_206406_((TagKey)tag));
            });
            this.itemMap.forEach((ingredientKey, item) -> {
                builder.m_126127_(ingredientKey, item);
                builder.m_126132_("has_" + ingredientKey, (CriterionTriggerInstance)SimpleItemsRecipeGenerator.m_125977_((ItemLike)item));
            });
            builder.m_176498_(writer);
        }
    }
}

