/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.util;

import com.mojang.math.Vector3f;
import java.util.Collection;
import java.util.List;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.client.model.baked.face.FaceManager;
import mod.chiselsandbits.client.model.baked.face.model.BakedQuadAdapter;
import mod.chiselsandbits.client.model.baked.face.model.ModelQuadLayer;
import mod.chiselsandbits.client.model.baked.face.model.VertexData;
import mod.chiselsandbits.client.util.VertexDataUtils;
import mod.chiselsandbits.utils.LightUtil;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.NotNull;

public final class QuadGenerationUtils {
    private QuadGenerationUtils() {
        throw new IllegalStateException("Tried to instantiate: 'QuadGenerationUtils', but this is a utility class.");
    }

    public static void generateQuads(List<BakedQuad> target, long primaryStateRenderSeed, @NotNull RenderType renderType, IBlockInformation blockInformation, Direction cullDirection, Vector3f from, Vector3f to) {
        Collection<ModelQuadLayer> quadLayers = FaceManager.getInstance().getCachedLayersFor(blockInformation, cullDirection, renderType, primaryStateRenderSeed, renderType);
        if (quadLayers != null) {
            for (ModelQuadLayer layer : quadLayers) {
                Collection<VertexData> adaptedVertices = VertexDataUtils.adaptVertices(layer.vertexData(), cullDirection, from, to);
                BakedQuadAdapter adapter = new BakedQuadAdapter(adaptedVertices, layer.color());
                LightUtil.put(adapter, layer.sourceQuad());
                adapter.setQuadTint(layer.tint());
                adapter.setApplyDiffuseLighting(layer.shade());
                adapter.setTexture(layer.sprite());
                adapter.setQuadOrientation(cullDirection);
                BakedQuad quad = adapter.build();
                target.add(quad);
            }
        }
    }
}

