/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.api.inventory.bit;

import java.util.Map;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.item.bit.IBitItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface IBitInventory {
    default public boolean canExtractOne(IBlockInformation blockInformation) {
        return this.canExtract(blockInformation, 1);
    }

    public boolean canExtract(IBlockInformation var1, int var2);

    public int getMaxExtractAmount(IBlockInformation var1);

    default public void extractOne(IBlockInformation blockInformation) throws IllegalArgumentException {
        this.extract(blockInformation, 1);
    }

    public void extract(IBlockInformation var1, int var2) throws IllegalArgumentException;

    default public boolean canInsertOne(IBlockInformation blockInformation) {
        return this.canInsert(blockInformation, 1);
    }

    public boolean canInsert(IBlockInformation var1, int var2);

    public int getMaxInsertAmount(IBlockInformation var1);

    default public void insertOne(IBlockInformation blockInformation) throws IllegalArgumentException {
        this.insert(blockInformation, 1);
    }

    public void insert(IBlockInformation var1, int var2) throws IllegalArgumentException;

    default public void insertOrDiscard(IBlockInformation blockInformation, int count) {
        this.insert(blockInformation, Math.min(this.getMaxInsertAmount(blockInformation), count));
    }

    public boolean isEmpty();

    default public ItemStack insert(ItemStack stack) {
        Item item = stack.m_41720_();
        if (!(item instanceof IBitItem)) {
            return stack;
        }
        IBitItem bitItem = (IBitItem)item;
        IBlockInformation blockInformation = bitItem.getBlockInformation(stack);
        int maxToInsertCount = this.getMaxInsertAmount(blockInformation);
        int maxToInsertFromStack = Math.min(stack.m_41613_(), maxToInsertCount);
        int maxRemainingOnStack = stack.m_41613_() - maxToInsertCount;
        this.insert(blockInformation, maxToInsertFromStack);
        ItemStack resultStack = stack.m_41777_();
        resultStack.m_41764_(maxRemainingOnStack);
        return resultStack;
    }

    public Map<IBlockInformation, Integer> getContainedStates();
}

