/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.tileentity;

import java.util.Objects;
import mod.pianomanu.blockcarpentry.setup.Registration;
import mod.pianomanu.blockcarpentry.tileentity.FrameBlockTile;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LockableFrameTile
extends FrameBlockTile {
    private static final Logger LOGGER = LogManager.getLogger();
    private boolean canBeOpenedByPlayers = true;
    private boolean canBeOpenedByRedstoneSignal = true;

    public LockableFrameTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.DOOR_FRAME_TILE.get(), pos, state);
    }

    public boolean canBeOpenedByPlayers() {
        return this.canBeOpenedByPlayers;
    }

    public void setCanBeOpenedByPlayers(boolean canBeOpenedByPlayers) {
        this.canBeOpenedByPlayers = canBeOpenedByPlayers;
    }

    public boolean canBeOpenedByRedstoneSignal() {
        return this.canBeOpenedByRedstoneSignal;
    }

    public void setCanBeOpenedByRedstoneSignal(boolean canBeOpenedByRedstoneSignal) {
        this.canBeOpenedByRedstoneSignal = canBeOpenedByRedstoneSignal;
    }

    private static CompoundTag writeBool(boolean bool) {
        CompoundTag compoundnbt = new CompoundTag();
        compoundnbt.m_128359_("boolean", String.valueOf(bool));
        return compoundnbt;
    }

    private static boolean readBool(CompoundTag tag, boolean defaultReturnValue) {
        if (!tag.m_128425_("boolean", 8)) {
            return defaultReturnValue;
        }
        try {
            return Boolean.parseBoolean(tag.m_128461_("boolean"));
        }
        catch (NumberFormatException e) {
            LOGGER.error("Not a valid Boolean Value: " + tag.m_128461_("boolean"));
            return defaultReturnValue;
        }
    }

    @Override
    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        boolean oldCanBeOpenedByPlayers = this.canBeOpenedByPlayers;
        boolean oldCanBeOpenedByRedstoneSignal = this.canBeOpenedByRedstoneSignal;
        CompoundTag tag = pkt.m_131708_();
        if (tag.m_128441_("canBeOpenedByPlayers")) {
            this.canBeOpenedByPlayers = LockableFrameTile.readBool(tag.m_128469_("canBeOpenedByPlayers"), true);
            if (!Objects.equals(oldCanBeOpenedByPlayers, this.canBeOpenedByPlayers)) {
                this.requestModelDataUpdate();
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        }
        if (tag.m_128441_("canBeOpenedByRedstoneSignal")) {
            this.canBeOpenedByRedstoneSignal = LockableFrameTile.readBool(tag.m_128469_("canBeOpenedByRedstoneSignal"), true);
            if (!Objects.equals(oldCanBeOpenedByRedstoneSignal, this.canBeOpenedByRedstoneSignal)) {
                this.requestModelDataUpdate();
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        }
        super.onDataPacket(net, pkt);
    }

    @Override
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128365_("canBeOpenedByPlayers", (Tag)LockableFrameTile.writeBool(this.canBeOpenedByPlayers));
        tag.m_128365_("canBeOpenedByRedstoneSignal", (Tag)LockableFrameTile.writeBool(this.canBeOpenedByRedstoneSignal));
        return tag;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("canBeOpenedByPlayers")) {
            this.canBeOpenedByPlayers = LockableFrameTile.readBool(tag.m_128469_("canBeOpenedByPlayers"), true);
        }
        if (tag.m_128441_("canBeOpenedByRedstoneSignal")) {
            this.canBeOpenedByRedstoneSignal = LockableFrameTile.readBool(tag.m_128469_("canBeOpenedByRedstoneSignal"), true);
        }
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("canBeOpenedByPlayers", (Tag)LockableFrameTile.writeBool(this.canBeOpenedByPlayers));
        tag.m_128365_("canBeOpenedByRedstoneSignal", (Tag)LockableFrameTile.writeBool(this.canBeOpenedByRedstoneSignal));
    }

    @Override
    public void clear() {
        super.clear();
        this.canBeOpenedByPlayers = true;
        this.canBeOpenedByRedstoneSignal = true;
    }

    public void addFromOutdatedTileEntity(FrameBlockTile tile) {
        if (this.f_58857_ == null) {
            this.f_58857_ = tile.m_58904_();
        }
        this.setDesign(tile.getDesign());
        this.setDesignTexture(tile.getDesignTexture());
        this.setMimic(tile.getMimic());
        this.setGlassColor(tile.getGlassColor());
        this.setOverlay(tile.getOverlay());
        this.setRotation(tile.getRotation());
        this.setTexture(tile.getTexture());
    }
}

