/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.tileentity;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.setup.Registration;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BedFrameTile
extends BlockEntity {
    public static final ModelProperty<BlockState> MIMIC = new ModelProperty();
    public static final ModelProperty<Integer> TEXTURE = new ModelProperty();
    public static final ModelProperty<Integer> PILLOW = new ModelProperty();
    public static final ModelProperty<Integer> BLANKET = new ModelProperty();
    public static final ModelProperty<Integer> DESIGN = new ModelProperty();
    public static final ModelProperty<Integer> DESIGN_TEXTURE = new ModelProperty();
    public static final ModelProperty<Integer> ROTATION = new ModelProperty();
    public final int maxTextures = 6;
    public final int maxDesigns = 4;
    private BlockState mimic;
    private Integer texture = 0;
    private Integer pillowColor = 0;
    private Integer blanketColor = 0;
    private Integer design = 0;
    private Integer designTexture = 0;
    private Integer rotation = 0;
    private static final Logger LOGGER = LogManager.getLogger();

    public BedFrameTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.BED_FRAME_TILE.get(), pos, state);
    }

    private static Integer readInteger(CompoundTag tag) {
        if (!tag.m_128425_("number", 8)) {
            return 0;
        }
        try {
            return Integer.parseInt(tag.m_128461_("number"));
        }
        catch (NumberFormatException e) {
            LOGGER.error("Not a valid Number Format: " + tag.m_128461_("number"));
            return 0;
        }
    }

    public BlockState getMimic() {
        return this.mimic;
    }

    private static CompoundTag writeInteger(Integer tag) {
        CompoundTag compoundnbt = new CompoundTag();
        compoundnbt.m_128359_("number", tag.toString());
        return compoundnbt;
    }

    public Integer getPillowColor() {
        return this.pillowColor;
    }

    public void setMimic(BlockState mimic) {
        this.mimic = mimic;
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public Integer getBlanketColor() {
        return this.blanketColor;
    }

    public void setPillowColor(Integer pillowColor) {
        this.pillowColor = pillowColor;
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public Integer getDesign() {
        return this.design;
    }

    public void setBlanketColor(Integer blanketColor) {
        this.blanketColor = blanketColor;
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public Integer getDesignTexture() {
        return this.designTexture;
    }

    public void setDesign(Integer design) {
        this.design = design;
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public Integer getTexture() {
        return this.texture;
    }

    public void setTexture(Integer texture) {
        this.texture = texture;
    }

    public Integer getRotation() {
        return this.rotation;
    }

    public void setRotation(Integer rotation) {
        this.rotation = rotation;
    }

    public void setDesignTexture(Integer designTexture) {
        this.designTexture = designTexture;
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        BlockState oldMimic = this.mimic;
        Integer oldTexture = this.texture;
        Integer oldPillow = this.pillowColor;
        Integer oldBlanket = this.blanketColor;
        Integer oldDesign = this.design;
        Integer oldDesignTexture = this.designTexture;
        Integer oldRotation = this.rotation;
        CompoundTag tag = pkt.m_131708_();
        if (tag.m_128441_("mimic")) {
            this.mimic = NbtUtils.m_129241_((CompoundTag)tag.m_128469_("mimic"));
            if (!Objects.equals(oldMimic, this.mimic)) {
                this.requestModelDataUpdate();
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        }
        if (tag.m_128441_("texture")) {
            this.texture = BedFrameTile.readInteger(tag.m_128469_("texture"));
            if (!Objects.equals(oldTexture, this.texture)) {
                this.requestModelDataUpdate();
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        }
        if (tag.m_128441_("blanket")) {
            this.blanketColor = BedFrameTile.readInteger(tag.m_128469_("blanket"));
            if (!Objects.equals(oldBlanket, this.blanketColor)) {
                this.requestModelDataUpdate();
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        }
        if (tag.m_128441_("pillow")) {
            this.pillowColor = BedFrameTile.readInteger(tag.m_128469_("pillow"));
            if (!Objects.equals(oldPillow, this.pillowColor)) {
                this.requestModelDataUpdate();
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        }
        if (tag.m_128441_("design")) {
            this.design = BedFrameTile.readInteger(tag.m_128469_("design"));
            if (!Objects.equals(oldDesign, this.design)) {
                this.requestModelDataUpdate();
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        }
        if (tag.m_128441_("design_texture")) {
            this.designTexture = BedFrameTile.readInteger(tag.m_128469_("design_texture"));
            if (!Objects.equals(oldDesignTexture, this.designTexture)) {
                this.requestModelDataUpdate();
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        }
        if (tag.m_128441_("rotation")) {
            this.rotation = BedFrameTile.readInteger(tag.m_128469_("rotation"));
            if (!Objects.equals(oldRotation, this.rotation)) {
                this.requestModelDataUpdate();
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        }
    }

    @Nonnull
    public ModelData getModelData() {
        return ModelData.builder().with(MIMIC, (Object)this.mimic).with(TEXTURE, (Object)this.texture).with(BLANKET, (Object)this.blanketColor).with(PILLOW, (Object)this.pillowColor).with(DESIGN, (Object)this.design).with(DESIGN_TEXTURE, (Object)this.designTexture).with(ROTATION, (Object)this.rotation).build();
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        if (this.mimic != null) {
            tag.m_128365_("mimic", (Tag)NbtUtils.m_129202_((BlockState)this.mimic));
        }
        if (this.texture != null) {
            tag.m_128365_("texture", (Tag)BedFrameTile.writeInteger(this.texture));
        }
        if (this.blanketColor != null) {
            tag.m_128365_("blanket", (Tag)BedFrameTile.writeInteger(this.blanketColor));
        }
        if (this.pillowColor != null) {
            tag.m_128365_("pillow", (Tag)BedFrameTile.writeInteger(this.pillowColor));
        }
        if (this.design != null) {
            tag.m_128365_("design", (Tag)BedFrameTile.writeInteger(this.design));
        }
        if (this.designTexture != null) {
            tag.m_128365_("design_texture", (Tag)BedFrameTile.writeInteger(this.designTexture));
        }
        if (this.rotation != null) {
            tag.m_128365_("rotation", (Tag)BedFrameTile.writeInteger(this.rotation));
        }
        return tag;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("mimic")) {
            this.mimic = NbtUtils.m_129241_((CompoundTag)tag.m_128469_("mimic"));
        }
        if (tag.m_128441_("texture")) {
            this.texture = BedFrameTile.readInteger(tag.m_128469_("texture"));
        }
        if (tag.m_128441_("blanket")) {
            this.blanketColor = BedFrameTile.readInteger(tag.m_128469_("blanket"));
        }
        if (tag.m_128441_("pillow")) {
            this.pillowColor = BedFrameTile.readInteger(tag.m_128469_("pillow"));
        }
        if (tag.m_128441_("design")) {
            this.design = BedFrameTile.readInteger(tag.m_128469_("design"));
        }
        if (tag.m_128441_("design_texture")) {
            this.designTexture = BedFrameTile.readInteger(tag.m_128469_("design_texture"));
        }
        if (tag.m_128441_("rotation")) {
            this.rotation = BedFrameTile.readInteger(tag.m_128469_("rotation"));
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.mimic != null) {
            tag.m_128365_("mimic", (Tag)NbtUtils.m_129202_((BlockState)this.mimic));
        }
        if (this.texture != null) {
            tag.m_128365_("texture", (Tag)BedFrameTile.writeInteger(this.texture));
        }
        if (this.blanketColor != null) {
            tag.m_128365_("blanket", (Tag)BedFrameTile.writeInteger(this.blanketColor));
        }
        if (this.pillowColor != null) {
            tag.m_128365_("pillow", (Tag)BedFrameTile.writeInteger(this.pillowColor));
        }
        if (this.design != null) {
            tag.m_128365_("design", (Tag)BedFrameTile.writeInteger(this.design));
        }
        if (this.designTexture != null) {
            tag.m_128365_("design_texture", (Tag)BedFrameTile.writeInteger(this.designTexture));
        }
        if (this.rotation != null) {
            tag.m_128365_("rotation", (Tag)BedFrameTile.writeInteger(this.rotation));
        }
    }

    public void clear() {
        this.setMimic(null);
        this.setTexture(0);
        this.setBlanketColor(0);
        this.setPillowColor(0);
        this.setDesign(0);
        this.setDesignTexture(0);
        this.setRotation(0);
    }
}

