/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.bakedmodels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.tileentity.FrameBlockTile;
import mod.pianomanu.blockcarpentry.util.BlockAppearanceHelper;
import mod.pianomanu.blockcarpentry.util.ModelHelper;
import mod.pianomanu.blockcarpentry.util.TextureHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;

public class SlopeBakedModel
implements IDynamicBakedModel {
    private static Vec3 v(double x, double y, double z) {
        return new Vec3(x, y, z);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, RenderType renderType) {
        BlockState mimic = (BlockState)extraData.get(FrameBlockTile.MIMIC);
        if (mimic != null) {
            ModelResourceLocation location = BlockModelShaper.m_110895_((BlockState)mimic);
            BakedModel model = Minecraft.m_91087_().m_91304_().m_119422_(location);
            return this.getMimicQuads(state, side, rand, extraData, model);
        }
        return Collections.emptyList();
    }

    public List<BakedQuad> getMimicQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, BakedModel model) {
        if (side != null) {
            return new ArrayList<BakedQuad>();
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        BlockState mimic = (BlockState)extraData.get(FrameBlockTile.MIMIC);
        List<TextureAtlasSprite> texture = TextureHelper.getTextureFromModel(model, extraData, rand);
        int index = (Integer)extraData.get(FrameBlockTile.TEXTURE);
        if (index >= texture.size()) {
            index = 0;
        }
        if (texture.size() == 0) {
            if (Minecraft.m_91087_().f_91074_ != null) {
                Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237115_((String)"message.blockcarpentry.block_not_available"), true);
            }
            return Collections.emptyList();
        }
        int tintIndex = BlockAppearanceHelper.setTintIndex(mimic);
        quads.addAll(this.createSlope(0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, texture.get(index), tintIndex, (Direction)state.m_61143_((Property)StairBlock.f_56841_), (StairsShape)state.m_61143_((Property)StairBlock.f_56843_), (Half)state.m_61143_((Property)StairBlock.f_56842_)));
        return quads;
    }

    private List<BakedQuad> createSlope(float xl, float xh, float yl, float yh, float zl, float zh, TextureAtlasSprite texture, int tintIndex, Direction direction, StairsShape shape, Half half) {
        boolean isBottom;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        Vec3 NWU = SlopeBakedModel.v(xl, yh, zl);
        Vec3 SWU = SlopeBakedModel.v(xl, yh, zh);
        Vec3 NWD = SlopeBakedModel.v(xl, yl, zl);
        Vec3 SWD = SlopeBakedModel.v(xl, yl, zh);
        Vec3 NEU = SlopeBakedModel.v(xh, yh, zl);
        Vec3 SEU = SlopeBakedModel.v(xh, yh, zh);
        Vec3 NED = SlopeBakedModel.v(xh, yl, zl);
        Vec3 SED = SlopeBakedModel.v(xh, yl, zh);
        if (xh - xl > 1.0f || yh - yl > 1.0f || zh - zl > 1.0f) {
            if (Minecraft.m_91087_().f_91074_ != null) {
                Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237115_((String)"An error occured with this block, please report to the mod author (PianoManu)"), true);
            }
            return quads;
        }
        boolean bl = isBottom = half == Half.BOTTOM;
        if (isBottom) {
            quads.add(ModelHelper.createQuad(SWD, NWD, NED, SED, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
            block0 : switch (shape) {
                case STRAIGHT: {
                    switch (direction) {
                        case NORTH: {
                            quads.add(ModelHelper.createQuad(NEU, NED, NWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(SED, NED, NEU, SED, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWU, NWD, SWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWU, SWD, SED, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            break block0;
                        }
                        case EAST: {
                            quads.add(ModelHelper.createQuad(SEU, SED, NED, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NEU, NED, NWD, NWD, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(SWD, SED, SEU, SWD, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SWD, SEU, NEU, NWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            break block0;
                        }
                        case SOUTH: {
                            quads.add(ModelHelper.createQuad(SWU, SWD, SED, SEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SEU, SED, NED, SEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NWD, SWD, SWU, NWD, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWD, SWU, SEU, NED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            break block0;
                        }
                        case WEST: {
                            quads.add(ModelHelper.createQuad(NWU, NWD, SWD, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NED, NWD, NWU, NED, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SWU, SWD, SED, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SWU, SED, NED, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                        }
                    }
                    break;
                }
                case OUTER_LEFT: {
                    switch (direction) {
                        case NORTH: {
                            quads.add(ModelHelper.createQuadInverted(NED, NWD, NWU, NED, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWU, NWD, SWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWU, SWD, SED, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(SED, NED, NWU, SED, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            break block0;
                        }
                        case EAST: {
                            quads.add(ModelHelper.createQuadInverted(SED, NED, NEU, SED, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NEU, NED, NWD, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NEU, NWD, SWD, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(SWD, SED, NEU, SWD, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            break block0;
                        }
                        case SOUTH: {
                            quads.add(ModelHelper.createQuadInverted(SWD, SED, SEU, SWD, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SEU, SED, NED, SEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SEU, NED, NWD, SEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NWD, SWD, SEU, NWD, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            break block0;
                        }
                        case WEST: {
                            quads.add(ModelHelper.createQuadInverted(NWD, SWD, SWU, NWD, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SWU, SWD, SED, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SWU, SED, NED, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NED, NWD, SWU, NED, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                        }
                    }
                    break;
                }
                case OUTER_RIGHT: {
                    switch (direction) {
                        case WEST: {
                            quads.add(ModelHelper.createQuadInverted(NED, NWD, NWU, NED, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWU, NWD, SWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWU, SWD, SED, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(SED, NED, NWU, SED, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            break block0;
                        }
                        case NORTH: {
                            quads.add(ModelHelper.createQuadInverted(SED, NED, NEU, SED, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NEU, NED, NWD, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NEU, NWD, SWD, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(SWD, SED, NEU, SWD, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            break block0;
                        }
                        case EAST: {
                            quads.add(ModelHelper.createQuadInverted(SWD, SED, SEU, SWD, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SEU, SED, NED, SEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SEU, NED, NWD, SEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NWD, SWD, SEU, NWD, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            break block0;
                        }
                        case SOUTH: {
                            quads.add(ModelHelper.createQuadInverted(NWD, SWD, SWU, NWD, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SWU, SWD, SED, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SWU, SED, NED, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NED, NWD, SWU, NED, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                        }
                    }
                    break;
                }
                case INNER_LEFT: {
                    switch (direction) {
                        case NORTH: {
                            quads.add(ModelHelper.createQuad(NEU, NED, NWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(SED, NED, NEU, SED, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SED, NEU, NWU, SED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWU, NWD, SWD, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SWU, SWD, SED, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NWU, SWU, SED, NWU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            break block0;
                        }
                        case EAST: {
                            quads.add(ModelHelper.createQuad(SEU, SED, NED, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(SWD, SED, SEU, SWD, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SWD, SEU, NEU, SWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NEU, NED, NWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWU, NWD, SWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NEU, NWU, SWD, NEU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            break block0;
                        }
                        case SOUTH: {
                            quads.add(ModelHelper.createQuad(SWU, SWD, SED, SEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NWD, SWD, SWU, NWD, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWD, SWU, SEU, NWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SEU, SED, NED, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NEU, NED, NWD, NWD, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(SEU, NEU, NWD, SEU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            break block0;
                        }
                        case WEST: {
                            quads.add(ModelHelper.createQuad(NWU, NWD, SWD, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NED, NWD, NWU, NED, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NED, NWU, SWU, NED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SWU, SWD, SED, SEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SEU, SED, NED, SEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(SWU, SEU, NED, SWU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                        }
                    }
                    break;
                }
                case INNER_RIGHT: {
                    switch (direction) {
                        case WEST: {
                            quads.add(ModelHelper.createQuad(NEU, NED, NWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(SED, NED, NEU, SED, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SED, NEU, NWU, SED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWU, NWD, SWD, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SWU, SWD, SED, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NWU, SWU, SED, NWU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            break block0;
                        }
                        case NORTH: {
                            quads.add(ModelHelper.createQuad(SEU, SED, NED, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(SWD, SED, SEU, SWD, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SWD, SEU, NEU, SWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NEU, NED, NWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWU, NWD, SWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NEU, NWU, SWD, NEU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            break block0;
                        }
                        case EAST: {
                            quads.add(ModelHelper.createQuad(SWU, SWD, SED, SEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NWD, SWD, SWU, NWD, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWD, SWU, SEU, NWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SEU, SED, NED, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NEU, NED, NWD, NWD, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(SEU, NEU, NWD, SEU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            break block0;
                        }
                        case SOUTH: {
                            quads.add(ModelHelper.createQuad(NWU, NWD, SWD, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NED, NWD, NWU, NED, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NED, NWU, SWU, NED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SWU, SWD, SED, SEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SEU, SED, NED, SEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(SWU, SEU, NED, SWU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                        }
                    }
                }
            }
        } else {
            quads.add(ModelHelper.createQuad(NWU, SWU, SEU, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
            block37 : switch (shape) {
                case STRAIGHT: {
                    switch (direction) {
                        case NORTH: {
                            quads.add(ModelHelper.createQuad(NEU, NED, NWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NED, NEU, SEU, NED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(SWU, NWU, NWD, SWU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NED, SEU, SWU, NWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            break;
                        }
                        case EAST: {
                            quads.add(ModelHelper.createQuad(SEU, SED, NED, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SED, SEU, SWU, SED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NWU, NEU, NED, NWU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWU, NED, SED, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            break;
                        }
                        case SOUTH: {
                            quads.add(ModelHelper.createQuad(SWU, SWD, SED, SEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SWD, SWU, NWU, SWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NEU, SEU, SED, NEU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NEU, SED, SWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            break;
                        }
                        case WEST: {
                            quads.add(ModelHelper.createQuad(NWU, NWD, SWD, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWD, NWU, NEU, NWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(SEU, SWU, SWD, SEU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWD, NEU, SEU, SWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                        }
                    }
                    break;
                }
                case OUTER_LEFT: {
                    switch (direction) {
                        case NORTH: {
                            quads.add(ModelHelper.createQuad(NWD, NWU, NEU, NWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(SWU, NWU, NWD, SWU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(SEU, SWU, NWD, SEU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWD, NEU, SEU, NWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            break;
                        }
                        case EAST: {
                            quads.add(ModelHelper.createQuad(NED, NEU, SEU, NED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NWU, NEU, NED, NWU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(SWU, NWU, NED, SWU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NED, SEU, SWU, NED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            break;
                        }
                        case SOUTH: {
                            quads.add(ModelHelper.createQuad(SED, SEU, SWU, SED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NEU, SEU, SED, NEU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NWU, NEU, SED, NWU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SED, SWU, NWU, SED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            break;
                        }
                        case WEST: {
                            quads.add(ModelHelper.createQuad(SWD, SWU, NWU, SWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(SEU, SWU, SWD, SEU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NEU, SEU, SWD, NEU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SWD, NWU, NEU, SWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                        }
                    }
                    break;
                }
                case OUTER_RIGHT: {
                    switch (direction) {
                        case WEST: {
                            quads.add(ModelHelper.createQuad(NWD, NWU, NEU, NWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(SWU, NWU, NWD, SWU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(SEU, SWU, NWD, SEU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWD, NEU, SEU, NWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            break;
                        }
                        case NORTH: {
                            quads.add(ModelHelper.createQuad(NED, NEU, SEU, NED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NWU, NEU, NED, NWU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(SWU, NWU, NED, SWU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NED, SEU, SWU, NED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            break;
                        }
                        case EAST: {
                            quads.add(ModelHelper.createQuad(SED, SEU, SWU, SED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NEU, SEU, SED, NEU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NWU, NEU, SED, NWU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SED, SWU, NWU, SED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            break;
                        }
                        case SOUTH: {
                            quads.add(ModelHelper.createQuad(SWD, SWU, NWU, SWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(SEU, SWU, SWD, SEU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NEU, SEU, SWD, NEU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SWD, NWU, NEU, SWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                        }
                    }
                    break;
                }
                case INNER_LEFT: {
                    switch (direction) {
                        case NORTH: {
                            quads.add(ModelHelper.createQuad(NEU, NED, NWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NED, NEU, SEU, NED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NWD, NED, SEU, NWD, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWU, NWD, SWD, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(SEU, SWU, SWD, SEU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SEU, SWD, NWD, SEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            break;
                        }
                        case EAST: {
                            quads.add(ModelHelper.createQuad(SEU, SED, NED, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SED, SEU, SWU, SED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NED, SED, SWU, NED, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NEU, NED, NWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(SWU, NWU, NWD, SWU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SWU, NWD, NED, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            break;
                        }
                        case SOUTH: {
                            quads.add(ModelHelper.createQuad(SWU, SWD, SED, SEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SWD, SWU, NWU, SWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(SED, SWD, NWU, SED, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SEU, SED, NED, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NWU, NEU, NED, NWU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWU, NED, SED, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            break;
                        }
                        case WEST: {
                            quads.add(ModelHelper.createQuad(NWU, NWD, SWD, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWD, NWU, NEU, NWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(SWD, NWD, NEU, SWD, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SWU, SWD, SED, SEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NEU, SEU, SED, NEU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NEU, SED, SWD, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                        }
                    }
                    break;
                }
                case INNER_RIGHT: {
                    switch (direction) {
                        case WEST: {
                            quads.add(ModelHelper.createQuad(NEU, NED, NWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NED, NEU, SEU, NED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NWD, NED, SEU, NWD, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWU, NWD, SWD, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(SEU, SWU, SWD, SEU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SEU, SWD, NWD, SEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            break block37;
                        }
                        case NORTH: {
                            quads.add(ModelHelper.createQuad(SEU, SED, NED, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SED, SEU, SWU, SED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NED, SED, SWU, NED, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NEU, NED, NWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(SWU, NWU, NWD, SWU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SWU, NWD, NED, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            break block37;
                        }
                        case EAST: {
                            quads.add(ModelHelper.createQuad(SWU, SWD, SED, SEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SWD, SWU, NWU, SWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(SED, SWD, NWU, SED, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SEU, SED, NED, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NWU, NEU, NED, NWU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWU, NED, SED, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            break block37;
                        }
                        case SOUTH: {
                            quads.add(ModelHelper.createQuad(NWU, NWD, SWD, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWD, NWU, NEU, NWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(SWD, NWD, NEU, SWD, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SWU, SWD, SED, SEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NEU, SEU, SED, NEU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NEU, SED, SWD, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                        }
                    }
                }
            }
        }
        return quads;
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite m_6160_() {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("minecraft", "block/oak_planks"));
    }

    @Nonnull
    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    @NotNull
    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.m_110466_()});
    }
}

