/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.bakedmodels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.tileentity.ChestFrameBlockEntity;
import mod.pianomanu.blockcarpentry.util.BlockAppearanceHelper;
import mod.pianomanu.blockcarpentry.util.ModelHelper;
import mod.pianomanu.blockcarpentry.util.TextureHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;

public class IllusionChestBakedModel
implements IDynamicBakedModel {
    public static final ResourceLocation TEXTURE = new ResourceLocation("minecraft", "block/oak_planks");

    private TextureAtlasSprite getTexture() {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TEXTURE);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, RenderType renderType) {
        BlockState mimic = (BlockState)extraData.get(ChestFrameBlockEntity.MIMIC);
        if (mimic != null) {
            ModelResourceLocation location = BlockModelShaper.m_110895_((BlockState)mimic);
            BakedModel model = Minecraft.m_91087_().m_91304_().m_119422_(location);
            return this.getMimicQuads(state, side, rand, extraData, model);
        }
        return Collections.emptyList();
    }

    public List<BakedQuad> getMimicQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, BakedModel model) {
        if (side != null) {
            return Collections.emptyList();
        }
        BlockState mimic = (BlockState)extraData.get(ChestFrameBlockEntity.MIMIC);
        if (mimic != null && state != null) {
            ArrayList<TextureAtlasSprite> designTextureList = new ArrayList<TextureAtlasSprite>(TextureHelper.getMetalTextures());
            designTextureList.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("minecraft", "block/shulker_box")));
            TextureAtlasSprite chestFront = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("blockcarpentry", "block/chest_front"));
            TextureAtlasSprite chestSide = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("blockcarpentry", "block/chest_side"));
            TextureAtlasSprite chestTop = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("blockcarpentry", "block/chest_top"));
            int tintIndex = BlockAppearanceHelper.setTintIndex(mimic);
            int rotation = (Integer)extraData.get(ChestFrameBlockEntity.ROTATION);
            int design = (Integer)extraData.get(ChestFrameBlockEntity.DESIGN);
            int desTex = (Integer)extraData.get(ChestFrameBlockEntity.DESIGN_TEXTURE);
            TextureAtlasSprite designTexture = (TextureAtlasSprite)designTextureList.get(desTex);
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            if (design == 0) {
                return new ArrayList<BakedQuad>(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
            }
            if (design == 1 || design == 2) {
                quads.addAll(ModelHelper.createSixFaceCuboid(0.125f, 0.875f, 0.125f, 0.875f, 0.125f, 0.875f, mimic, model, extraData, rand, tintIndex, rotation));
            }
            if (design == 3) {
                quads.addAll(ModelHelper.createCuboid(0.125f, 0.875f, 0.125f, 0.875f, 0.125f, 0.875f, designTexture, -1));
            }
            if (design == 1 || design == 3 || design == 4) {
                quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.125f, 0.0f, 1.0f, 0.0f, 0.125f, mimic, model, extraData, rand, tintIndex, rotation));
                quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.125f, 0.0f, 1.0f, 0.875f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                quads.addAll(ModelHelper.createSixFaceCuboid(0.875f, 1.0f, 0.0f, 1.0f, 0.0f, 0.125f, mimic, model, extraData, rand, tintIndex, rotation));
                quads.addAll(ModelHelper.createSixFaceCuboid(0.875f, 1.0f, 0.0f, 1.0f, 0.875f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                quads.addAll(ModelHelper.createSixFaceCuboid(0.125f, 0.875f, 0.0f, 0.125f, 0.0f, 0.125f, mimic, model, extraData, rand, tintIndex, rotation));
                quads.addAll(ModelHelper.createSixFaceCuboid(0.125f, 0.875f, 0.0f, 0.125f, 0.875f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.125f, 0.0f, 0.125f, 0.125f, 0.875f, mimic, model, extraData, rand, tintIndex, rotation));
                quads.addAll(ModelHelper.createSixFaceCuboid(0.875f, 1.0f, 0.0f, 0.125f, 0.125f, 0.875f, mimic, model, extraData, rand, tintIndex, rotation));
                quads.addAll(ModelHelper.createSixFaceCuboid(0.125f, 0.875f, 0.875f, 1.0f, 0.0f, 0.125f, mimic, model, extraData, rand, tintIndex, rotation));
                quads.addAll(ModelHelper.createSixFaceCuboid(0.125f, 0.875f, 0.875f, 1.0f, 0.875f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.125f, 0.875f, 1.0f, 0.125f, 0.875f, mimic, model, extraData, rand, tintIndex, rotation));
                quads.addAll(ModelHelper.createSixFaceCuboid(0.875f, 1.0f, 0.875f, 1.0f, 0.125f, 0.875f, mimic, model, extraData, rand, tintIndex, rotation));
            }
            if (design == 2) {
                quads.addAll(ModelHelper.createCuboid(0.0f, 0.125f, 0.0f, 1.0f, 0.0f, 0.125f, designTexture, -1));
                quads.addAll(ModelHelper.createCuboid(0.0f, 0.125f, 0.0f, 1.0f, 0.875f, 1.0f, designTexture, -1));
                quads.addAll(ModelHelper.createCuboid(0.875f, 1.0f, 0.0f, 1.0f, 0.0f, 0.125f, designTexture, -1));
                quads.addAll(ModelHelper.createCuboid(0.875f, 1.0f, 0.0f, 1.0f, 0.875f, 1.0f, designTexture, -1));
                quads.addAll(ModelHelper.createCuboid(0.125f, 0.875f, 0.0f, 0.125f, 0.0f, 0.125f, designTexture, -1));
                quads.addAll(ModelHelper.createCuboid(0.125f, 0.875f, 0.0f, 0.125f, 0.875f, 1.0f, designTexture, -1));
                quads.addAll(ModelHelper.createCuboid(0.0f, 0.125f, 0.0f, 0.125f, 0.125f, 0.875f, designTexture, -1));
                quads.addAll(ModelHelper.createCuboid(0.875f, 1.0f, 0.0f, 0.125f, 0.125f, 0.875f, designTexture, -1));
                quads.addAll(ModelHelper.createCuboid(0.125f, 0.875f, 0.875f, 1.0f, 0.0f, 0.125f, designTexture, -1));
                quads.addAll(ModelHelper.createCuboid(0.125f, 0.875f, 0.875f, 1.0f, 0.875f, 1.0f, designTexture, -1));
                quads.addAll(ModelHelper.createCuboid(0.0f, 0.125f, 0.875f, 1.0f, 0.125f, 0.875f, designTexture, -1));
                quads.addAll(ModelHelper.createCuboid(0.875f, 1.0f, 0.875f, 1.0f, 0.125f, 0.875f, designTexture, -1));
            }
            if (design == 4) {
                quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.0625f, 0.125f, 0.0625f, 0.9375f, chestTop, -1));
                quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.875f, 0.9375f, 0.0625f, 0.9375f, chestTop, -1));
                int[] ulow = new int[]{7, 7, 7, 9, 8, 9};
                int[] uhigh = new int[]{9, 9, 8, 7, 9, 7};
                int[] vlow = new int[]{4, 7, 4, 4, 4, 4};
                int[] vhigh = new int[]{5, 8, 8, 8, 8, 8};
                switch ((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)) {
                    case NORTH: {
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.0625f, 0.9375f, 0.0625f, 0.125f, chestFront, -1));
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.0625f, 0.9375f, 0.875f, 0.9375f, chestSide, -1));
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.125f, 0.0625f, 0.9375f, 0.0625f, 0.9375f, chestSide, -1));
                        quads.addAll(ModelHelper.createCuboid(0.875f, 0.9375f, 0.0625f, 0.9375f, 0.0625f, 0.9375f, chestSide, -1));
                        quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.5f, 0.75f, 0.0f, 0.0625f, chestFront, -1, ulow, uhigh, vlow, vhigh));
                        break;
                    }
                    case EAST: {
                        ulow = new int[]{7, 8, 9, 8, 9, 7};
                        uhigh = new int[]{8, 9, 7, 9, 7, 8};
                        vlow = new int[]{6, 4, 4, 4, 4, 4};
                        vhigh = new int[]{4, 6, 8, 8, 8, 8};
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.0625f, 0.9375f, 0.0625f, 0.125f, chestSide, -1));
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.0625f, 0.9375f, 0.875f, 0.9375f, chestSide, -1));
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.125f, 0.0625f, 0.9375f, 0.0625f, 0.9375f, chestSide, -1));
                        quads.addAll(ModelHelper.createCuboid(0.875f, 0.9375f, 0.0625f, 0.9375f, 0.0625f, 0.9375f, chestFront, -1));
                        quads.addAll(ModelHelper.createCuboid(0.9375f, 1.0f, 0.5f, 0.75f, 0.4375f, 0.5625f, chestFront, -1, ulow, uhigh, vlow, vhigh));
                        break;
                    }
                    case SOUTH: {
                        ulow = new int[]{9, 9, 8, 9, 7, 9};
                        uhigh = new int[]{7, 7, 9, 7, 8, 7};
                        vlow = new int[]{4, 8, 4, 4, 4, 4};
                        vhigh = new int[]{5, 7, 8, 8, 8, 8};
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.0625f, 0.9375f, 0.0625f, 0.125f, chestSide, -1));
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.0625f, 0.9375f, 0.875f, 0.9375f, chestFront, -1));
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.125f, 0.0625f, 0.9375f, 0.0625f, 0.9375f, chestSide, -1));
                        quads.addAll(ModelHelper.createCuboid(0.875f, 0.9375f, 0.0625f, 0.9375f, 0.0625f, 0.9375f, chestSide, -1));
                        quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.5f, 0.75f, 0.9375f, 1.0f, chestFront, -1, ulow, uhigh, vlow, vhigh));
                        break;
                    }
                    case WEST: {
                        ulow = new int[]{7, 7, 9, 7, 9, 8};
                        uhigh = new int[]{8, 8, 7, 8, 7, 9};
                        vlow = new int[]{4, 6, 4, 4, 4, 4};
                        vhigh = new int[]{6, 4, 8, 8, 8, 8};
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.0625f, 0.9375f, 0.0625f, 0.125f, chestSide, -1));
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.0625f, 0.9375f, 0.875f, 0.9375f, chestSide, -1));
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.125f, 0.0625f, 0.9375f, 0.0625f, 0.9375f, chestFront, -1));
                        quads.addAll(ModelHelper.createCuboid(0.875f, 0.9375f, 0.0625f, 0.9375f, 0.0625f, 0.9375f, chestSide, -1));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.0625f, 0.5f, 0.75f, 0.4375f, 0.5625f, chestFront, -1, ulow, uhigh, vlow, vhigh));
                    }
                }
            }
            return quads;
        }
        return Collections.emptyList();
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite m_6160_() {
        return this.getTexture();
    }

    @Nonnull
    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    @NotNull
    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.m_110466_()});
    }
}

