/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.bakedmodels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.tileentity.FrameBlockTile;
import mod.pianomanu.blockcarpentry.util.BlockAppearanceHelper;
import mod.pianomanu.blockcarpentry.util.ModelHelper;
import mod.pianomanu.blockcarpentry.util.TextureHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;

public class EdgedSlopeBakedModel
implements IDynamicBakedModel {
    public static final ResourceLocation TEXTURE = new ResourceLocation("minecraft", "block/oak_planks");

    private TextureAtlasSprite getTexture() {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TEXTURE);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, RenderType renderType) {
        BlockState mimic = (BlockState)extraData.get(FrameBlockTile.MIMIC);
        if (mimic != null) {
            ModelResourceLocation location = BlockModelShaper.m_110895_((BlockState)mimic);
            if (state != null) {
                BakedModel model = Minecraft.m_91087_().m_91304_().m_119422_(location);
                return this.getMimicQuads(state, side, rand, extraData, model);
            }
        }
        return Collections.emptyList();
    }

    public List<BakedQuad> getMimicQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, ModelData extraData, BakedModel model) {
        if (side != null) {
            return Collections.emptyList();
        }
        BlockState mimic = (BlockState)extraData.get(FrameBlockTile.MIMIC);
        if (mimic != null && state != null) {
            int z;
            int y;
            int x;
            List<TextureAtlasSprite> texture = TextureHelper.getTextureFromModel(model, extraData, rand);
            int index = (Integer)extraData.get(FrameBlockTile.TEXTURE);
            if (index >= texture.size()) {
                index = 0;
            }
            if (texture.size() == 0) {
                if (Minecraft.m_91087_().f_91074_ != null) {
                    Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237115_((String)"message.blockcarpentry.block_not_available"), true);
                }
                return Collections.emptyList();
            }
            int tintIndex = BlockAppearanceHelper.setTintIndex(mimic);
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            Half half = (Half)state.m_61143_((Property)StairBlock.f_56842_);
            Half lower = Half.BOTTOM;
            Half upper = Half.TOP;
            Direction direction = (Direction)state.m_61143_((Property)StairBlock.f_56841_);
            Direction north = Direction.NORTH;
            Direction east = Direction.EAST;
            Direction south = Direction.SOUTH;
            Direction west = Direction.WEST;
            StairsShape shape = (StairsShape)state.m_61143_((Property)StairBlock.f_56843_);
            StairsShape straight = StairsShape.STRAIGHT;
            StairsShape innerLeft = StairsShape.INNER_LEFT;
            StairsShape innerRight = StairsShape.INNER_RIGHT;
            StairsShape outerLeft = StairsShape.OUTER_LEFT;
            StairsShape outerRight = StairsShape.OUTER_RIGHT;
            if (half == lower) {
                for (x = 0; x < 16; ++x) {
                    for (y = 0; y < 16; ++y) {
                        for (z = 0; z < 16; ++z) {
                            if (shape == straight) {
                                if (direction == north) {
                                    quads.addAll(ModelHelper.createVoxel(x, y, z, texture.get(index), tintIndex, z == 0, z == 15 - y, x == 15 && z <= 15 - y, x == 0 && z <= 15 - y, z == 15 - y, y == 0));
                                } else if (direction == east) {
                                    quads.addAll(ModelHelper.createVoxel(x, y, z, texture.get(index), tintIndex, z == 0 && x >= y, z == 15 && x >= y, x == 15, x == y, x == y, y == 0));
                                } else if (direction == south) {
                                    quads.addAll(ModelHelper.createVoxel(x, y, z, texture.get(index), tintIndex, z == y, z == 15, x == 15 && z >= y, x == 0 && z >= y, z == y, y == 0));
                                } else if (direction == west) {
                                    quads.addAll(ModelHelper.createVoxel(x, y, z, texture.get(index), tintIndex, z == 0 && x <= 15 - y, z == 15 && x <= 15 - y, x == 15 - y, x == 0, x == 15 - y, y == 0));
                                }
                            }
                            if (shape == innerLeft) {
                                if (direction == north) {
                                    quads.addAll(ModelHelper.createVoxel(x, y, z, texture.get(index), tintIndex, z == 0, z == 15 - y && z < x || z == 15 && x <= 15 - y, x == 15 && z <= 15 - y || x == 15 - y && x < z, x == 0, z == 15 - y && z <= x || x == 15 - y && x <= z, y == 0));
                                } else if (direction == east) {
                                    quads.addAll(ModelHelper.createVoxel(x, y, z, texture.get(index), tintIndex, z == 0, z == 15 && x >= y || z == 15 - y && z < 15 - x, x == 15, x == y && x > 15 - z || x == 0 && z <= 15 - y, z == 15 - y && z <= 15 - x || x == y && x >= 15 - z, y == 0));
                                } else if (direction == south) {
                                    quads.addAll(ModelHelper.createVoxel(x, y, z, texture.get(index), tintIndex, z == y && z > x || z == 0 && x >= y, z == 15, x == 15, x == 0 && z >= y || x == y && x > z, z == y && z >= x || x == y && x >= z, y == 0));
                                } else if (direction == west) {
                                    quads.addAll(ModelHelper.createVoxel(x, y, z, texture.get(index), tintIndex, z == 0 && x <= 15 - y || z == y && z > 15 - x, z == 15, x == 15 - y && x < 15 - z || x == 15 && z >= y, x == 0, x == 15 - y && x <= 15 - z || z == y && z > 15 - x, y == 0));
                                }
                            }
                            if (shape == innerRight) {
                                if (direction == west) {
                                    quads.addAll(ModelHelper.createVoxel(x, y, z, texture.get(index), tintIndex, z == 0, z == 15 - y && z < x || z == 15 && x <= 15 - y, x == 15 && z <= 15 - y || x == 15 - y && x < z, x == 0, z == 15 - y && z <= x || x == 15 - y && x <= z, y == 0));
                                } else if (direction == north) {
                                    quads.addAll(ModelHelper.createVoxel(x, y, z, texture.get(index), tintIndex, z == 0, z == 15 && x >= y || z == 15 - y && z < 15 - x, x == 15, x == y && x > 15 - z || x == 0 && z <= 15 - y, z == 15 - y && z <= 15 - x || x == y && x >= 15 - z, y == 0));
                                } else if (direction == east) {
                                    quads.addAll(ModelHelper.createVoxel(x, y, z, texture.get(index), tintIndex, z == y && z > x || z == 0 && x >= y, z == 15, x == 15, x == 0 && z >= y || x == y && x > z, z == y && z >= x || x == y && x >= z, y == 0));
                                } else if (direction == south) {
                                    quads.addAll(ModelHelper.createVoxel(x, y, z, texture.get(index), tintIndex, z == 0 && x <= 15 - y || z == y && z > 15 - x, z == 15, x == 15 - y && x < 15 - z || x == 15 && z >= y, x == 0, x == 15 - y && x <= 15 - z || z == y && z > 15 - x, y == 0));
                                }
                            }
                            if (shape == outerLeft) {
                                if (direction == north) {
                                    quads.addAll(ModelHelper.createVoxel(x, y, z, texture.get(index), tintIndex, z == 0 && x <= 15 - y, z == 15 - y && x <= 15 - y, x == 15 - y && z <= 15 - y, x == 0 && z <= 15 - y, z == 15 - y && z >= x || x == 15 - y && x >= z, y == 0));
                                } else if (direction == east) {
                                    quads.addAll(ModelHelper.createVoxel(x, y, z, texture.get(index), tintIndex, z == 0 && x >= y, z == 15 - y && x >= y, x == 15 && z <= 15 - y, x == y && x <= 15 - z, x == y && x <= 15 - z || z == 15 - y && z >= 15 - x, y == 0));
                                } else if (direction == south) {
                                    quads.addAll(ModelHelper.createVoxel(x, y, z, texture.get(index), tintIndex, z == y && z <= x, z == 15 && x >= y, x == 15 && z >= y, x == y && z >= y, z == y && z <= x || x == y && x <= z, y == 0));
                                } else if (direction == west) {
                                    quads.addAll(ModelHelper.createVoxel(x, y, z, texture.get(index), tintIndex, z == y && x <= 15 - y, z == 15 && x <= 15 - y, x == 15 - y && x >= 15 - z, x == 0 && z >= y, x == 15 - y && x >= 15 - z || z == y && z < 15 - x, y == 0));
                                }
                            }
                            if (shape != outerRight) continue;
                            if (direction == west) {
                                quads.addAll(ModelHelper.createVoxel(x, y, z, texture.get(index), tintIndex, z == 0 && x <= 15 - y, z == 15 - y && x <= 15 - y, x == 15 - y && z <= 15 - y, x == 0 && z <= 15 - y, z == 15 - y && z >= x || x == 15 - y && x >= z, y == 0));
                                continue;
                            }
                            if (direction == north) {
                                quads.addAll(ModelHelper.createVoxel(x, y, z, texture.get(index), tintIndex, z == 0 && x >= y, z == 15 - y && x >= y, x == 15 && z <= 15 - y, x == y && x <= 15 - z, x == y && x <= 15 - z || z == 15 - y && z >= 15 - x, y == 0));
                                continue;
                            }
                            if (direction == east) {
                                quads.addAll(ModelHelper.createVoxel(x, y, z, texture.get(index), tintIndex, z == y && z <= x, z == 15 && x >= y, x == 15 && z >= y, x == y && z >= y, z == y && z <= x || x == y && x <= z, y == 0));
                                continue;
                            }
                            if (direction != south) continue;
                            quads.addAll(ModelHelper.createVoxel(x, y, z, texture.get(index), tintIndex, z == y && x <= 15 - y, z == 15 && x <= 15 - y, x == 15 - y && x >= 15 - z, x == 0 && z >= y, x == 15 - y && x >= 15 - z || z == y && z < 15 - x, y == 0));
                        }
                    }
                }
            }
            if (half == upper) {
                for (x = 0; x < 16; ++x) {
                    for (y = 0; y < 16; ++y) {
                        for (z = 0; z < 16; ++z) {
                            if (shape == straight) {
                                if (direction == north) {
                                    quads.addAll(ModelHelper.createVoxel(x, y, z, texture.get(index), tintIndex, z == 0, z == y, x == 15 && z <= y, x == 0 && z <= y, y == 15, z == y));
                                } else if (direction == east) {
                                    quads.addAll(ModelHelper.createVoxel(x, y, z, texture.get(index), tintIndex, z == 0 && x >= 15 - y, z == 15 && x >= 15 - y, x == 15, x == 15 - y, y == 15, x == 15 - y));
                                } else if (direction == south) {
                                    quads.addAll(ModelHelper.createVoxel(x, y, z, texture.get(index), tintIndex, z == 15 - y, z == 15, x == 15 && z >= 15 - y, x == 0 && z >= 15 - y, y == 15, z == 15 - y));
                                } else if (direction == west) {
                                    quads.addAll(ModelHelper.createVoxel(x, y, z, texture.get(index), tintIndex, z == 0 && x <= y, z == 15 && x <= y, x == y, x == 0, y == 15, x == y));
                                }
                            }
                            if (shape == innerLeft) {
                                if (direction == north) {
                                    quads.addAll(ModelHelper.createVoxel(x, y, z, texture.get(index), tintIndex, z == 0, z == y && z < x || z == 15 && x <= y, x == 15 && z <= y || x == y && x < z, x == 0, y == 15, z == y && z <= x || x == y && x <= z));
                                } else if (direction == east) {
                                    quads.addAll(ModelHelper.createVoxel(x, y, z, texture.get(index), tintIndex, z == 0, z == 15 && x >= 15 - y || z == y && z < 15 - x, x == 15, x == 15 - y && x > 15 - z || x == 0 && z <= y, y == 15, z == y && z <= 15 - x || x == 15 - y && x >= 15 - z));
                                } else if (direction == south) {
                                    quads.addAll(ModelHelper.createVoxel(x, y, z, texture.get(index), tintIndex, z == 15 - y && z > x || z == 0 && x >= 15 - y, z == 15, x == 15, x == 0 && z >= 15 - y || x == 15 - y && x > z, y == 15, z == 15 - y && z >= x || x == 15 - y && x >= z));
                                } else if (direction == west) {
                                    quads.addAll(ModelHelper.createVoxel(x, y, z, texture.get(index), tintIndex, z == 0 && x <= y || z == 15 - y && z > 15 - x, z == 15, x == y && x < 15 - z || x == 15 && z >= 15 - y, x == 0, y == 15, x == y && x <= 15 - z || z == 15 - y && z > 15 - x));
                                }
                            }
                            if (shape == innerRight) {
                                if (direction == west) {
                                    quads.addAll(ModelHelper.createVoxel(x, y, z, texture.get(index), tintIndex, z == 0, z == y && z < x || z == 15 && x <= y, x == 15 && z <= y || x == y && x < z, x == 0, y == 15, z == y && z <= x || x == y && x <= z));
                                } else if (direction == north) {
                                    quads.addAll(ModelHelper.createVoxel(x, y, z, texture.get(index), tintIndex, z == 0, z == 15 && x >= 15 - y || z == y && z < 15 - x, x == 15, x == 15 - y && x > 15 - z || x == 0 && z <= y, y == 15, z == y && z <= 15 - x || x == 15 - y && x >= 15 - z));
                                } else if (direction == east) {
                                    quads.addAll(ModelHelper.createVoxel(x, y, z, texture.get(index), tintIndex, z == 15 - y && z > x || z == 0 && x >= 15 - y, z == 15, x == 15, x == 0 && z >= 15 - y || x == 15 - y && x > z, y == 15, z == 15 - y && z >= x || x == 15 - y && x >= z));
                                } else if (direction == south) {
                                    quads.addAll(ModelHelper.createVoxel(x, y, z, texture.get(index), tintIndex, z == 0 && x <= y || z == 15 - y && z > 15 - x, z == 15, x == y && x < 15 - z || x == 15 && z >= 15 - y, x == 0, y == 15, x == y && x <= 15 - z || z == 15 - y && z > 15 - x));
                                }
                            }
                            if (shape == outerLeft) {
                                if (direction == north) {
                                    quads.addAll(ModelHelper.createVoxel(x, y, z, texture.get(index), tintIndex, z == 0 && x <= y, z == y && x <= y, x == y && z <= y, x == 0 && z <= y, y == 15, z == y && z >= x || x == y && x >= z));
                                } else if (direction == east) {
                                    quads.addAll(ModelHelper.createVoxel(x, y, z, texture.get(index), tintIndex, z == 0 && x >= 15 - y, z == y && x >= 15 - y, x == 15 && z <= y, x == 15 - y && x <= 15 - z, y == 15, x == 15 - y && x <= 15 - z || z == y && z >= 15 - x));
                                } else if (direction == south) {
                                    quads.addAll(ModelHelper.createVoxel(x, y, z, texture.get(index), tintIndex, z == 15 - y && z <= x, z == 15 && x >= 15 - y, x == 15 && z >= 15 - y, x == 15 - y && z >= 15 - y, y == 15, z == 15 - y && z <= x || x == 15 - y && x <= z));
                                } else if (direction == west) {
                                    quads.addAll(ModelHelper.createVoxel(x, y, z, texture.get(index), tintIndex, z == 15 - y && x <= y, z == 15 && x <= y, x == y && x >= 15 - z, x == 0 && z >= 15 - y, y == 15, x == y && x >= 15 - z || z == 15 - y && z < 15 - x));
                                }
                            }
                            if (shape != outerRight) continue;
                            if (direction == west) {
                                quads.addAll(ModelHelper.createVoxel(x, y, z, texture.get(index), tintIndex, z == 0 && x <= y, z == y && x <= y, x == y && z <= y, x == 0 && z <= y, y == 15, z == y && z >= x || x == y && x >= z));
                                continue;
                            }
                            if (direction == north) {
                                quads.addAll(ModelHelper.createVoxel(x, y, z, texture.get(index), tintIndex, z == 0 && x >= 15 - y, z == y && x >= 15 - y, x == 15 && z <= y, x == 15 - y && x <= 15 - z, y == 15, x == 15 - y && x <= 15 - z || z == y && z >= 15 - x));
                                continue;
                            }
                            if (direction == east) {
                                quads.addAll(ModelHelper.createVoxel(x, y, z, texture.get(index), tintIndex, z == 15 - y && z <= x, z == 15 && x >= 15 - y, x == 15 && z >= 15 - y, x == 15 - y && z >= 15 - y, y == 15, z == 15 - y && z <= x || x == 15 - y && x <= z));
                                continue;
                            }
                            if (direction != south) continue;
                            quads.addAll(ModelHelper.createVoxel(x, y, z, texture.get(index), tintIndex, z == 15 - y && x <= y, z == 15 && x <= y, x == y && x >= 15 - z, x == 0 && z >= 15 - y, y == 15, x == y && x >= 15 - z || z == 15 - y && z < 15 - x));
                        }
                    }
                }
            }
            return quads;
        }
        return Collections.emptyList();
    }

    public boolean m_7541_() {
        return false;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite m_6160_() {
        return this.getTexture();
    }

    @Nonnull
    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    @NotNull
    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.m_110466_()});
    }
}

