/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.bakedmodels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.tileentity.FrameBlockTile;
import mod.pianomanu.blockcarpentry.util.BlockAppearanceHelper;
import mod.pianomanu.blockcarpentry.util.ModelHelper;
import mod.pianomanu.blockcarpentry.util.TextureHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;

public class CarpetBakedModel
implements IDynamicBakedModel {
    public static final ResourceLocation TEXTURE = new ResourceLocation("minecraft", "block/oak_planks");

    private TextureAtlasSprite getTexture() {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TEXTURE);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, RenderType renderType) {
        BlockState mimic = (BlockState)extraData.get(FrameBlockTile.MIMIC);
        Integer design = (Integer)extraData.get(FrameBlockTile.DESIGN);
        if (side != null) {
            return Collections.emptyList();
        }
        if (mimic != null) {
            ModelResourceLocation location = BlockModelShaper.m_110895_((BlockState)mimic);
            if (state != null) {
                BakedModel model = Minecraft.m_91087_().m_91304_().m_119422_(location);
                List<TextureAtlasSprite> textureList = TextureHelper.getTextureFromModel(model, extraData, rand);
                TextureAtlasSprite glass = TextureHelper.getGlassTextures().get((Integer)extraData.get(FrameBlockTile.GLASS_COLOR));
                int woolInt = (Integer)extraData.get(FrameBlockTile.GLASS_COLOR) - 1;
                if (woolInt < 0) {
                    woolInt = 0;
                }
                TextureAtlasSprite wool = TextureHelper.getWoolTextures().get(woolInt);
                Integer tex = (Integer)extraData.get(FrameBlockTile.TEXTURE);
                if (textureList.size() <= tex) {
                    extraData.derive().with(FrameBlockTile.TEXTURE, (Object)0);
                    tex = 0;
                }
                if (textureList.size() == 0) {
                    if (Minecraft.m_91087_().f_91074_ != null) {
                        Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237115_((String)"message.blockcarpentry.block_not_available"), true);
                    }
                    for (int i = 0; i < 6; ++i) {
                        textureList.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("missing")));
                    }
                }
                TextureAtlasSprite texture = textureList.get(tex);
                boolean renderNorth = (Boolean)extraData.get(FrameBlockTile.NORTH_VISIBLE);
                boolean renderEast = (Boolean)extraData.get(FrameBlockTile.EAST_VISIBLE);
                boolean renderSouth = (Boolean)extraData.get(FrameBlockTile.SOUTH_VISIBLE);
                boolean renderWest = (Boolean)extraData.get(FrameBlockTile.WEST_VISIBLE);
                int tintIndex = BlockAppearanceHelper.setTintIndex(mimic);
                ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
                if (design == 0) {
                    quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.0f, 0.0625f, 0.0f, 1.0f, texture, tintIndex, renderNorth, renderSouth, renderEast, renderWest, true, true));
                } else if (design == 1) {
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.0625f, 0.0f, 0.0625f, 0.0f, 0.9375f, texture, tintIndex, renderNorth, renderSouth, renderEast, renderWest, true, true));
                    quads.addAll(ModelHelper.createCuboid(0.0625f, 1.0f, 0.0f, 0.0625f, 0.0f, 0.0625f, texture, tintIndex, renderNorth, renderSouth, renderEast, renderWest, true, true));
                    quads.addAll(ModelHelper.createCuboid(0.9375f, 1.0f, 0.0f, 0.0625f, 0.0625f, 1.0f, texture, tintIndex, renderNorth, renderSouth, renderEast, renderWest, true, true));
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.9375f, 0.0f, 0.0625f, 0.9375f, 1.0f, texture, tintIndex, renderNorth, renderSouth, renderEast, renderWest, true, true));
                    quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.0f, 0.0625f, 0.0625f, 0.9375f, glass, -1, renderNorth, renderSouth, renderEast, renderWest, true, true));
                } else if (design == 2) {
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.125f, 0.0f, 0.0625f, 0.0f, 0.875f, texture, tintIndex, renderNorth, renderSouth, renderEast, renderWest, true, true));
                    quads.addAll(ModelHelper.createCuboid(0.125f, 1.0f, 0.0f, 0.0625f, 0.0f, 0.125f, texture, tintIndex, renderNorth, renderSouth, renderEast, renderWest, true, true));
                    quads.addAll(ModelHelper.createCuboid(0.875f, 1.0f, 0.0f, 0.0625f, 0.125f, 1.0f, texture, tintIndex, renderNorth, renderSouth, renderEast, renderWest, true, true));
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.875f, 0.0f, 0.0625f, 0.875f, 1.0f, texture, tintIndex, renderNorth, renderSouth, renderEast, renderWest, true, true));
                    quads.addAll(ModelHelper.createCuboid(0.125f, 0.875f, 0.0f, 0.0625f, 0.125f, 0.875f, glass, -1, renderNorth, renderSouth, renderEast, renderWest, true, true));
                } else if (design == 3) {
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.0625f, 0.0f, 0.0625f, 0.0f, 0.9375f, texture, tintIndex, renderNorth, renderSouth, renderEast, renderWest, true, true));
                    quads.addAll(ModelHelper.createCuboid(0.0625f, 1.0f, 0.0f, 0.0625f, 0.0f, 0.0625f, texture, tintIndex, renderNorth, renderSouth, renderEast, renderWest, true, true));
                    quads.addAll(ModelHelper.createCuboid(0.9375f, 1.0f, 0.0f, 0.0625f, 0.0625f, 1.0f, texture, tintIndex, renderNorth, renderSouth, renderEast, renderWest, true, true));
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.9375f, 0.0f, 0.0625f, 0.9375f, 1.0f, texture, tintIndex, renderNorth, renderSouth, renderEast, renderWest, true, true));
                    quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.0f, 0.0625f, 0.0625f, 0.9375f, wool, -1, renderNorth, renderSouth, renderEast, renderWest, true, true));
                } else if (design == 4) {
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.125f, 0.0f, 0.0625f, 0.0f, 0.875f, texture, tintIndex, renderNorth, renderSouth, renderEast, renderWest, true, true));
                    quads.addAll(ModelHelper.createCuboid(0.125f, 1.0f, 0.0f, 0.0625f, 0.0f, 0.125f, texture, tintIndex, renderNorth, renderSouth, renderEast, renderWest, true, true));
                    quads.addAll(ModelHelper.createCuboid(0.875f, 1.0f, 0.0f, 0.0625f, 0.125f, 1.0f, texture, tintIndex, renderNorth, renderSouth, renderEast, renderWest, true, true));
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.875f, 0.0f, 0.0625f, 0.875f, 1.0f, texture, tintIndex, renderNorth, renderSouth, renderEast, renderWest, true, true));
                    quads.addAll(ModelHelper.createCuboid(0.125f, 0.875f, 0.0f, 0.0625f, 0.125f, 0.875f, wool, -1, renderNorth, renderSouth, renderEast, renderWest, true, true));
                }
                int overlayIndex = (Integer)extraData.get(FrameBlockTile.OVERLAY);
                if (overlayIndex != 0) {
                    quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, 0.0f, 0.0625f, 0.0f, 1.0f, overlayIndex, true, true, true, true, true, true, false));
                }
                return quads;
            }
        }
        return Collections.emptyList();
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite m_6160_() {
        return this.getTexture();
    }

    @Nonnull
    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    @NotNull
    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.m_110466_()});
    }
}

