/*
 * Decompiled with CFR 0.152.
 */
package com.structureessentials.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.structureessentials.StructureEssentials;

public class CommonConfiguration {
    public boolean structurePlacementLogging = false;
    public int structureSearchTimeout = 50;
    public boolean useFastStructureLookup = true;
    public boolean warnMissingRegistryEntry = true;
    public boolean disableLegacyRandomCrashes = true;

    public JsonObject serialize() {
        JsonObject root = new JsonObject();
        JsonObject entry = new JsonObject();
        entry.addProperty("desc:", "Enables debug logging of structure placement, does spam logs, only recommenced for debugging. Default: false");
        entry.addProperty("structurePlacementLogging", Boolean.valueOf(this.structurePlacementLogging));
        root.add("structurePlacementLogging", (JsonElement)entry);
        JsonObject entry2 = new JsonObject();
        entry2.addProperty("desc:", "Maximum time in seconds a structure search is allowed to take: default 50");
        entry2.addProperty("structureSearchTimeout", (Number)this.structureSearchTimeout);
        root.add("structureSearchTimeout", (JsonElement)entry2);
        JsonObject entry3 = new JsonObject();
        entry3.addProperty("desc:", "Whether the fast structure search is used, default: true");
        entry3.addProperty("useFastStructureLookup", Boolean.valueOf(this.useFastStructureLookup));
        root.add("useFastStructureLookup", (JsonElement)entry3);
        JsonObject entry4 = new JsonObject();
        entry4.addProperty("desc:", "Prevents crashes for missing registry entries(e.g. a mod update structure ids) and turns them into a log error message instead, default: true");
        entry4.addProperty("warnMissingRegistryEntry", Boolean.valueOf(this.warnMissingRegistryEntry));
        root.add("warnMissingRegistryEntry", (JsonElement)entry4);
        JsonObject entry5 = new JsonObject();
        entry5.addProperty("desc:", "Prevents crashes for multithreaded access of thread specific randoms, default: true");
        entry5.addProperty("disableLegacyRandomCrashes", Boolean.valueOf(this.disableLegacyRandomCrashes));
        root.add("disableLegacyRandomCrashes", (JsonElement)entry5);
        return root;
    }

    public void deserialize(JsonObject data) {
        if (data == null) {
            StructureEssentials.LOGGER.error("Config file was empty!");
            return;
        }
        this.structurePlacementLogging = data.get("structurePlacementLogging").getAsJsonObject().get("structurePlacementLogging").getAsBoolean();
        this.structureSearchTimeout = data.get("structureSearchTimeout").getAsJsonObject().get("structureSearchTimeout").getAsInt();
        this.useFastStructureLookup = data.get("useFastStructureLookup").getAsJsonObject().get("useFastStructureLookup").getAsBoolean();
    }
}

