/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.handcrafted.common.block.chair.couch;

import earth.terrarium.handcrafted.common.block.SimpleEntityBlock;
import earth.terrarium.handcrafted.common.block.SittableBlock;
import earth.terrarium.handcrafted.common.block.property.CouchShape;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;

@MethodsReturnNonnullByDefault
public abstract class ExpandableCouchBlock
extends SimpleEntityBlock
implements SittableBlock {
    public static final EnumProperty<CouchShape> COUCH_SHAPE = EnumProperty.m_61587_((String)"shape", CouchShape.class);

    public ExpandableCouchBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(COUCH_SHAPE, (Comparable)((Object)CouchShape.SINGLE))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        CouchShape couchShape = (CouchShape)((Object)state.m_61143_(COUCH_SHAPE));
        switch (mirror) {
            case LEFT_RIGHT: {
                if (direction.m_122434_() != Direction.Axis.Z) break;
                CouchShape shape = switch (couchShape) {
                    case CouchShape.OUTER_LEFT -> CouchShape.OUTER_RIGHT;
                    case CouchShape.OUTER_RIGHT -> CouchShape.OUTER_LEFT;
                    case CouchShape.INNER_LEFT -> CouchShape.INNER_RIGHT;
                    case CouchShape.INNER_RIGHT -> CouchShape.INNER_LEFT;
                    default -> couchShape;
                };
                return (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(COUCH_SHAPE, (Comparable)((Object)shape));
            }
            case FRONT_BACK: {
                if (direction.m_122434_() != Direction.Axis.X) break;
                CouchShape shape = switch (couchShape) {
                    case CouchShape.OUTER_LEFT -> CouchShape.OUTER_RIGHT;
                    case CouchShape.OUTER_RIGHT -> CouchShape.OUTER_LEFT;
                    case CouchShape.INNER_LEFT -> CouchShape.INNER_LEFT;
                    case CouchShape.INNER_RIGHT -> CouchShape.INNER_RIGHT;
                    default -> couchShape;
                };
                return (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(COUCH_SHAPE, (Comparable)((Object)shape));
            }
        }
        return super.m_6943_(state, mirror);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{COUCH_SHAPE, FACING, WATERLOGGED});
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return direction.m_122434_().m_122479_() ? (BlockState)state.m_61124_(COUCH_SHAPE, (Comparable)((Object)this.getCouchShape(state, (BlockGetter)level, currentPos))) : super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (this.sitOn(level, pos, player, ((Direction)state.m_61143_((Property)FACING)).m_122424_())) {
            return InteractionResult.CONSUME;
        }
        return InteractionResult.CONSUME_PARTIAL;
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockPos = context.m_8083_();
        FluidState fluidState = context.m_43725_().m_6425_(blockPos);
        BlockState blockState = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        return (BlockState)blockState.m_61124_(COUCH_SHAPE, (Comparable)((Object)this.getCouchShape(blockState, (BlockGetter)context.m_43725_(), blockPos)));
    }

    private boolean canTakeShape(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        BlockState blockState = level.m_8055_(pos.m_121945_(face));
        return !blockState.m_60713_((Block)this) || blockState.m_61143_((Property)FACING) != state.m_61143_((Property)FACING);
    }

    private CouchShape getCouchShape(BlockState state, BlockGetter level, BlockPos pos) {
        Direction direction3;
        Direction direction2;
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockState blockState = level.m_8055_(pos.m_121945_(direction));
        if (blockState.m_60713_((Block)this) && (direction2 = (Direction)blockState.m_61143_((Property)FACING)).m_122434_() != ((Direction)state.m_61143_((Property)FACING)).m_122434_() && this.canTakeShape(state, level, pos, direction2.m_122424_())) {
            if (direction2 == direction.m_122428_()) {
                return CouchShape.OUTER_LEFT;
            }
            return CouchShape.OUTER_RIGHT;
        }
        BlockState blockState2 = level.m_8055_(pos.m_121945_(direction.m_122424_()));
        if (blockState2.m_60713_((Block)this) && (direction3 = (Direction)blockState2.m_61143_((Property)FACING)).m_122434_() != ((Direction)state.m_61143_((Property)FACING)).m_122434_() && this.canTakeShape(state, level, pos, direction3)) {
            if (direction3 == direction.m_122428_()) {
                return CouchShape.INNER_LEFT;
            }
            return CouchShape.INNER_RIGHT;
        }
        BlockState blockState3 = level.m_8055_(pos.m_121945_(direction.m_122427_()));
        BlockState blockState4 = level.m_8055_(pos.m_121945_(direction.m_122427_().m_122424_()));
        if (!blockState3.m_60713_((Block)this) && !blockState4.m_60713_((Block)this)) {
            return CouchShape.SINGLE;
        }
        if (!blockState3.m_60713_((Block)this)) {
            return CouchShape.RIGHT;
        }
        if (!blockState4.m_60713_((Block)this)) {
            return CouchShape.LEFT;
        }
        return CouchShape.MIDDLE;
    }
}

