/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.handcrafted.client.block.stackablebook;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.teamresourceful.resourcefullib.client.CloseablePoseStack;
import earth.terrarium.handcrafted.client.block.stackablebook.StackableBookModel;
import earth.terrarium.handcrafted.common.block.chair.couch.ExpandableCouchBlock;
import earth.terrarium.handcrafted.common.block.stackablebook.StackableBookBlock;
import earth.terrarium.handcrafted.common.block.stackablebook.StackableBookBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class StackableBookRenderer
implements BlockEntityRenderer<StackableBookBlockEntity> {
    public StackableBookRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    private static void render(int books, long seed, ResourceLocation texture, Direction direction, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        try (CloseablePoseStack ignored = new CloseablePoseStack(poseStack);){
            poseStack.m_85837_(0.5, 1.5, 0.5);
            poseStack.m_85845_(Vector3f.f_122224_.m_122240_(direction.m_122424_().m_122435_()));
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
            EntityModelSet modelSet = Minecraft.m_91087_().m_167973_();
            RandomSource random = RandomSource.m_216335_((long)seed);
            for (int i = 0; i < books; ++i) {
                StackableBookModel model = switch (i + 1) {
                    case 2 -> new StackableBookModel(modelSet.m_171103_(StackableBookModel.LAYER_LOCATION_BOOK_2));
                    case 4 -> new StackableBookModel(modelSet.m_171103_(StackableBookModel.LAYER_LOCATION_BOOK_3));
                    default -> new StackableBookModel(modelSet.m_171103_(StackableBookModel.LAYER_LOCATION_BOOK_1));
                };
                poseStack.m_85837_(0.0, (double)(-0.25f * (float)i), 0.0);
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_((float)random.m_188502_()));
                String colour = DyeColor.m_41053_((int)random.m_188503_(DyeColor.values().length)).toString();
                model.m_7695_(poseStack, buffer.m_6299_(RenderType.m_110458_((ResourceLocation)new ResourceLocation(texture.m_135827_(), "textures/block/stackable_book/" + colour + "_book.png"))), packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
                poseStack.m_85837_(0.0, (double)(0.25f * (float)i), 0.0);
            }
        }
    }

    public void render(StackableBookBlockEntity entity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        StackableBookRenderer.render((Integer)entity.m_58900_().m_61143_((Property)StackableBookBlock.BOOKS), entity.m_58899_().m_121878_(), Registry.f_122824_.m_7981_((Object)entity.m_58900_().m_60734_()), (Direction)entity.m_58900_().m_61143_((Property)ExpandableCouchBlock.FACING), poseStack, bufferSource, packedLight, packedOverlay);
    }
}

