/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.core.helper;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.codecs.PrimitiveCodec;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Rarity;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import org.cyclops.everlastingabilities.ability.AbilityTypeEffect;

public class CodecHelpers {
    public static final Codec<Rarity> CODEC_RARITY = ExtraCodecs.m_184425_((Codec)ExtraCodecs.m_184405_(rarity -> rarity.name().toLowerCase(Locale.ROOT), name -> Rarity.valueOf((String)name.toUpperCase(Locale.ROOT))), (Codec)ExtraCodecs.m_184421_(Enum::ordinal, id -> id >= 0 && id < Rarity.values().length ? Rarity.values()[id] : null, (int)-1));
    public static final Codec<AbilityTypeEffect.Target> CODEC_TARGET = ExtraCodecs.m_184425_((Codec)ExtraCodecs.m_184405_(rarity -> rarity.name().toLowerCase(Locale.ROOT), name -> AbilityTypeEffect.Target.valueOf(name.toUpperCase(Locale.ROOT))), (Codec)ExtraCodecs.m_184421_(Enum::ordinal, id -> id >= 0 && id < AbilityTypeEffect.Target.values().length ? AbilityTypeEffect.Target.values()[id] : null, (int)-1));
    public static final Codec<ICondition> CODEC_CONDITION = new PrimitiveCodec<ICondition>(){

        public <T> DataResult<ICondition> read(DynamicOps<T> ops, T input) {
            try {
                return DataResult.success((Object)CraftingHelper.getCondition((JsonObject)((JsonObject)CodecHelpers.opsToJson(ops, input))));
            }
            catch (RuntimeException error) {
                return DataResult.error((String)error.getMessage());
            }
        }

        public <T> T write(DynamicOps<T> ops, ICondition value) {
            return CodecHelpers.jsonToOps(ops, (JsonElement)CraftingHelper.serialize((ICondition)value));
        }
    };

    public static <T> JsonElement opsToJson(DynamicOps<T> ops, T input) {
        if (input instanceof JsonElement) {
            JsonElement jsonElement = (JsonElement)input;
            return jsonElement;
        }
        Optional optionalString = ops.getStringValue(input).result();
        if (optionalString.isPresent()) {
            return new JsonPrimitive((String)optionalString.get());
        }
        Optional optionalNumber = ops.getNumberValue(input).result();
        if (optionalNumber.isPresent()) {
            return new JsonPrimitive((Number)optionalNumber.get());
        }
        Optional optionalMap = ops.getMap(input).result();
        if (optionalMap.isPresent()) {
            MapLike map = (MapLike)optionalMap.get();
            JsonObject jsonObject = new JsonObject();
            map.entries().forEach(pair -> jsonObject.add(CodecHelpers.opsToJson(ops, pair.getFirst()).getAsString(), CodecHelpers.opsToJson(ops, pair.getSecond())));
            return jsonObject;
        }
        throw new IllegalArgumentException("Unknown JSON entry " + input);
    }

    public static <T> T jsonToOps(DynamicOps<T> ops, JsonElement jsonElement) {
        if (jsonElement.isJsonPrimitive()) {
            JsonPrimitive primitive = jsonElement.getAsJsonPrimitive();
            if (primitive.isString()) {
                return (T)ops.createString(primitive.getAsString());
            }
            if (primitive.isNumber()) {
                return (T)ops.createNumeric(primitive.getAsNumber());
            }
        }
        if (jsonElement instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)jsonElement;
            HashMap map = Maps.newHashMap();
            for (Map.Entry entry : jsonObject.entrySet()) {
                map.put(ops.createString((String)entry.getKey()), CodecHelpers.jsonToOps(ops, (JsonElement)entry.getValue()));
            }
            return (T)ops.createMap((Map)map);
        }
        throw new IllegalArgumentException("Unknown JSON entry " + jsonElement);
    }
}

