/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.cyclops.cyclopscore.command.argument.ArgumentTypeEnum;
import org.cyclops.everlastingabilities.ability.AbilityHelpers;
import org.cyclops.everlastingabilities.api.Ability;
import org.cyclops.everlastingabilities.api.IAbilityType;
import org.cyclops.everlastingabilities.api.capability.IMutableAbilityStore;
import org.cyclops.everlastingabilities.capability.MutableAbilityStoreConfig;
import org.cyclops.everlastingabilities.command.argument.ArgumentTypeAbility;

public class CommandModifyAbilities
implements Command<CommandSourceStack> {
    private final boolean checkAbility;
    private final boolean checkLevel;

    public CommandModifyAbilities(boolean checkAbility, boolean checkLevel) {
        this.checkAbility = checkAbility;
        this.checkLevel = checkLevel;
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer sender = ((CommandSourceStack)context.getSource()).m_81375_();
        Action action = (Action)ArgumentTypeEnum.getValue(context, (String)"action", Action.class);
        ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
        IMutableAbilityStore abilityStore = (IMutableAbilityStore)player.getCapability(MutableAbilityStoreConfig.CAPABILITY).orElse(null);
        if (action == Action.LIST) {
            sender.m_213846_(abilityStore.getTextComponent());
        } else {
            int level;
            if (!this.checkAbility) {
                throw new SimpleCommandExceptionType((Message)Component.m_237110_((String)"chat.everlastingabilities.command.invalidAbility", (Object[])new Object[]{"null"})).create();
            }
            IAbilityType abilityType = (IAbilityType)context.getArgument("ability", IAbilityType.class);
            int n = level = this.checkLevel ? (Integer)context.getArgument("level", Integer.class) : 1;
            if (action == Action.ADD) {
                level = Math.max(1, Math.min(abilityType.getMaxLevelInfinitySafe(), level));
                Ability ability = new Ability(abilityType, level);
                Ability addedAbility = AbilityHelpers.addPlayerAbility((Player)player, ability, true, false);
                Ability newAbility = abilityStore.getAbility(abilityType);
                sender.m_213846_((Component)Component.m_237110_((String)"chat.everlastingabilities.command.addedAbility", (Object[])new Object[]{addedAbility, newAbility}));
            } else {
                level = Math.max(1, level);
                Ability ability = new Ability(abilityType, level);
                Ability removedAbility = AbilityHelpers.removePlayerAbility((Player)player, ability, true, false);
                Ability newAbility = abilityStore.getAbility(abilityType);
                sender.m_213846_((Component)Component.m_237110_((String)"chat.everlastingabilities.command.removedAbility", (Object[])new Object[]{removedAbility, newAbility}));
            }
        }
        return 0;
    }

    public static LiteralArgumentBuilder<CommandSourceStack> make() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"abilities").requires(commandSource -> commandSource.m_6761_(2))).then(Commands.m_82129_((String)"action", (ArgumentType)new ArgumentTypeEnum(Action.class)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes((Command)new CommandModifyAbilities(false, false))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"ability", (ArgumentType)new ArgumentTypeAbility()).executes((Command)new CommandModifyAbilities(true, false))).then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer((int)1)).executes((Command)new CommandModifyAbilities(true, true))))));
    }

    public static enum Action {
        ADD,
        REMOVE,
        LIST;

    }
}

