/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.ability;

import com.mojang.serialization.Codec;
import java.util.Objects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Rarity;
import net.minecraftforge.common.crafting.conditions.ICondition;
import org.cyclops.everlastingabilities.RegistryEntries;
import org.cyclops.everlastingabilities.api.AbilityTypeAdapter;
import org.cyclops.everlastingabilities.api.IAbilityType;

public class AbilityTypeSpecialStepAssist
extends AbilityTypeAdapter {
    private static final String PLAYER_NBT_KEY = "everlastingabilities:stepAssist";
    private final boolean forceDefaultStepHeight;

    public AbilityTypeSpecialStepAssist(ICondition condition, String name, Rarity rarity, int maxLevel, int baseXpPerLevel, boolean obtainableOnPlayerSpawn, boolean obtainableOnMobSpawn, boolean obtainableOnCraft, boolean obtainableOnLoot, boolean forceDefaultStepHeight) {
        super(condition, name, rarity, maxLevel, baseXpPerLevel, obtainableOnPlayerSpawn, obtainableOnMobSpawn, obtainableOnCraft, obtainableOnLoot);
        this.forceDefaultStepHeight = forceDefaultStepHeight;
    }

    @Override
    public Codec<? extends IAbilityType> codec() {
        return Objects.requireNonNull(RegistryEntries.ABILITYSERIALIZER_SPECIAL_STEP_ASSIST);
    }

    public boolean isForceDefaultStepHeight() {
        return this.forceDefaultStepHeight;
    }

    @Override
    public void onTick(Player player, int level) {
        player.f_19793_ = player.m_6047_() ? 0.5f : (float)level;
    }

    @Override
    public void onChangedLevel(Player player, int oldLevel, int newLevel) {
        if (oldLevel > 0 && newLevel == 0) {
            float stepHeight = 0.6f;
            if (player.getPersistentData().m_128441_(PLAYER_NBT_KEY)) {
                if (!this.isForceDefaultStepHeight()) {
                    stepHeight = player.getPersistentData().m_128457_(PLAYER_NBT_KEY);
                }
                player.getPersistentData().m_128473_(PLAYER_NBT_KEY);
            }
            player.f_19793_ = stepHeight;
        } else if (oldLevel == 0 && newLevel > 0) {
            player.getPersistentData().m_128350_(PLAYER_NBT_KEY, player.f_19793_);
        }
    }
}

