/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.cyclops.cyclopscore.config.ConfigHandler;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.helper.EntityHelpers;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.cyclopscore.init.ItemGroupMod;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.init.ModBaseVersionable;
import org.cyclops.cyclopscore.modcompat.capabilities.ICapabilityConstructor;
import org.cyclops.cyclopscore.modcompat.capabilities.ICapabilityTypeGetter;
import org.cyclops.cyclopscore.modcompat.capabilities.SimpleCapabilityConstructor;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.cyclopscore.proxy.IClientProxy;
import org.cyclops.cyclopscore.proxy.ICommonProxy;
import org.cyclops.everlastingabilities.GeneralConfig;
import org.cyclops.everlastingabilities.RegistryEntries;
import org.cyclops.everlastingabilities.ability.AbilityHelpers;
import org.cyclops.everlastingabilities.ability.serializer.AbilityTypeEffectSerializerConfig;
import org.cyclops.everlastingabilities.ability.serializer.AbilityTypeSpecialBonemealerSerializerConfig;
import org.cyclops.everlastingabilities.ability.serializer.AbilityTypeSpecialFertilitySerializerConfig;
import org.cyclops.everlastingabilities.ability.serializer.AbilityTypeSpecialFlightSerializerConfig;
import org.cyclops.everlastingabilities.ability.serializer.AbilityTypeSpecialMagnetizeSerializerConfig;
import org.cyclops.everlastingabilities.ability.serializer.AbilityTypeSpecialPowerStareSerializerConfig;
import org.cyclops.everlastingabilities.ability.serializer.AbilityTypeSpecialStepAssistSerializerConfig;
import org.cyclops.everlastingabilities.api.Ability;
import org.cyclops.everlastingabilities.api.AbilityTypes;
import org.cyclops.everlastingabilities.api.IAbilityType;
import org.cyclops.everlastingabilities.api.capability.AbilityStoreCapabilityProvider;
import org.cyclops.everlastingabilities.api.capability.DefaultMutableAbilityStore;
import org.cyclops.everlastingabilities.api.capability.IMutableAbilityStore;
import org.cyclops.everlastingabilities.api.capability.IMutableAbilityStoreRegistryAccess;
import org.cyclops.everlastingabilities.capability.AbilityStoreConfig;
import org.cyclops.everlastingabilities.capability.MutableAbilityStoreConfig;
import org.cyclops.everlastingabilities.command.CommandModifyAbilities;
import org.cyclops.everlastingabilities.command.argument.ArgumentTypeAbilityConfig;
import org.cyclops.everlastingabilities.inventory.container.ContainerAbilityContainerConfig;
import org.cyclops.everlastingabilities.item.ItemAbilityBottleConfig;
import org.cyclops.everlastingabilities.item.ItemAbilityTotemConfig;
import org.cyclops.everlastingabilities.loot.functions.LootFunctionSetRandomAbility;
import org.cyclops.everlastingabilities.network.packet.RequestAbilityStorePacket;
import org.cyclops.everlastingabilities.proxy.ClientProxy;
import org.cyclops.everlastingabilities.proxy.CommonProxy;
import org.cyclops.everlastingabilities.recipe.TotemRecycleRecipeConfig;

@Mod(value="everlastingabilities")
public class EverlastingAbilities
extends ModBaseVersionable<EverlastingAbilities> {
    public static EverlastingAbilities _instance;
    private static final String NBT_TOTEM_SPAWNED = "everlastingabilities:totemSpawned";

    public EverlastingAbilities() {
        super("everlastingabilities", instance -> {
            _instance = instance;
        });
        AbilityTypes.REGISTRY.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    protected LiteralArgumentBuilder<CommandSourceStack> constructBaseCommand() {
        LiteralArgumentBuilder root = super.constructBaseCommand();
        root.then(CommandModifyAbilities.make());
        return root;
    }

    protected IClientProxy constructClientProxy() {
        return new ClientProxy();
    }

    protected ICommonProxy constructCommonProxy() {
        return new CommonProxy();
    }

    protected void setup(FMLCommonSetupEvent event) {
        super.setup(event);
        LootFunctionSetRandomAbility.load();
        this.getCapabilityConstructorRegistry().registerInheritableEntity(Player.class, (ICapabilityConstructor)new SimpleCapabilityConstructor<IMutableAbilityStore, Player>(){

            @Nullable
            public ICapabilityProvider createProvider(Player host) {
                return new AbilityStoreCapabilityProvider<DefaultMutableAbilityStore>((ICapabilityTypeGetter<DefaultMutableAbilityStore>)this, new DefaultMutableAbilityStore());
            }

            public Capability<IMutableAbilityStore> getCapability() {
                return MutableAbilityStoreConfig.CAPABILITY;
            }
        });
        this.getCapabilityConstructorRegistry().registerInheritableEntity(PathfinderMob.class, (ICapabilityConstructor)new SimpleCapabilityConstructor<IMutableAbilityStore, PathfinderMob>(){

            @Nullable
            public ICapabilityProvider createProvider(PathfinderMob host) {
                if (host instanceof Entity) {
                    PathfinderMob entity = host;
                    DefaultMutableAbilityStore store = new DefaultMutableAbilityStore();
                    if (!entity.m_20193_().f_46443_ && host instanceof LivingEntity && GeneralConfig.mobAbilityChance > 0 && entity.m_19879_() % GeneralConfig.mobAbilityChance == 0 && EverlastingAbilities.canMobHaveAbility((LivingEntity)host)) {
                        RandomSource rand = RandomSource.m_216327_();
                        rand.m_188584_((long)entity.m_19879_());
                        Registry<IAbilityType> registry = AbilityHelpers.getRegistry(host.f_19853_.m_5962_());
                        List<IAbilityType> abilityTypes = AbilityHelpers.getAbilityTypesMobSpawn(registry);
                        Rarity rarity = AbilityHelpers.getRandomRarity(abilityTypes, rand);
                        AbilityHelpers.getRandomAbility(abilityTypes, rand, rarity).ifPresent(abilityType -> store.addAbility(new Ability((IAbilityType)abilityType, 1), true));
                    }
                    return new AbilityStoreCapabilityProvider<DefaultMutableAbilityStore>((ICapabilityTypeGetter<DefaultMutableAbilityStore>)this, store);
                }
                return null;
            }

            public Capability<IMutableAbilityStore> getCapability() {
                return MutableAbilityStoreConfig.CAPABILITY;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean canMobHaveAbility(LivingEntity mob) {
        ResourceLocation mobName = ForgeRegistries.ENTITY_TYPES.getKey((Object)mob.m_6095_());
        if (mobName == null) return false;
        if (!GeneralConfig.mobDropBlacklist.stream().noneMatch(mobName.toString()::matches)) return false;
        return true;
    }

    public CreativeModeTab constructDefaultCreativeModeTab() {
        return new ItemGroupMod((ModBase)this, () -> RegistryEntries.ITEM_ABILITY_BOTTLE);
    }

    protected void onConfigsRegister(ConfigHandler configHandler) {
        super.onConfigsRegister(configHandler);
        configHandler.addConfigurable((ExtendedConfig)new GeneralConfig());
        configHandler.addConfigurable((ExtendedConfig)new ArgumentTypeAbilityConfig());
        configHandler.addConfigurable((ExtendedConfig)new AbilityStoreConfig());
        configHandler.addConfigurable((ExtendedConfig)new MutableAbilityStoreConfig());
        configHandler.addConfigurable((ExtendedConfig)new ContainerAbilityContainerConfig());
        configHandler.addConfigurable((ExtendedConfig)new TotemRecycleRecipeConfig());
        configHandler.addConfigurable((ExtendedConfig)new ItemAbilityTotemConfig());
        configHandler.addConfigurable((ExtendedConfig)new ItemAbilityBottleConfig());
        configHandler.addConfigurable((ExtendedConfig)new AbilityTypeEffectSerializerConfig());
        configHandler.addConfigurable((ExtendedConfig)new AbilityTypeSpecialBonemealerSerializerConfig());
        configHandler.addConfigurable((ExtendedConfig)new AbilityTypeSpecialFertilitySerializerConfig());
        configHandler.addConfigurable((ExtendedConfig)new AbilityTypeSpecialFlightSerializerConfig());
        configHandler.addConfigurable((ExtendedConfig)new AbilityTypeSpecialMagnetizeSerializerConfig());
        configHandler.addConfigurable((ExtendedConfig)new AbilityTypeSpecialPowerStareSerializerConfig());
        configHandler.addConfigurable((ExtendedConfig)new AbilityTypeSpecialStepAssistSerializerConfig());
    }

    public static void clog(String message) {
        EverlastingAbilities.clog(org.apache.logging.log4j.Level.INFO, message);
    }

    public static void clog(org.apache.logging.log4j.Level level, String message) {
        _instance.getLoggerHelper().log(level, message);
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinLevelEvent event) {
        if (event.getLevel().f_46443_ && event.getEntity().getCapability(MutableAbilityStoreConfig.CAPABILITY).isPresent()) {
            this.getPacketHandler().sendToServer((PacketBase)new RequestAbilityStorePacket(event.getEntity().m_20148_().toString()));
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (GeneralConfig.totemMaximumSpawnRarity >= 0) {
            CompoundTag playerTag;
            CompoundTag tag = event.getEntity().getPersistentData();
            if (!tag.m_128441_("PlayerPersisted")) {
                tag.m_128365_("PlayerPersisted", (Tag)new CompoundTag());
            }
            if (!(playerTag = tag.m_128469_("PlayerPersisted")).m_128441_(NBT_TOTEM_SPAWNED)) {
                playerTag.m_128379_(NBT_TOTEM_SPAWNED, true);
                Level world = event.getEntity().f_19853_;
                Player player = event.getEntity();
                Rarity rarity = Rarity.values()[GeneralConfig.totemMaximumSpawnRarity];
                AbilityHelpers.getRandomAbilityUntilRarity(AbilityHelpers.getAbilityTypesPlayerSpawn(AbilityHelpers.getRegistry(world.m_5962_())), world.f_46441_, rarity, true).ifPresent(abilityType -> {
                    ItemStack itemStack = new ItemStack((ItemLike)RegistryEntries.ITEM_ABILITY_BOTTLE);
                    itemStack.getCapability(MutableAbilityStoreConfig.CAPABILITY, null).ifPresent(mutableAbilityStore -> {
                        ((IMutableAbilityStoreRegistryAccess)mutableAbilityStore).setRegistryAccess(world.m_5962_());
                        mutableAbilityStore.addAbility(new Ability((IAbilityType)abilityType, 1), true);
                    });
                    ItemStackHelpers.spawnItemStackToPlayer((Level)world, (BlockPos)player.m_20183_(), (ItemStack)itemStack, (Player)player);
                    EntityHelpers.spawnXpAtPlayer((Level)world, (Player)player, (int)abilityType.getXpPerLevelScaled());
                });
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        boolean doMobLoot = event.getEntity().f_19853_.m_46469_().m_46207_(GameRules.f_46135_);
        if (!event.getEntity().f_19853_.f_46443_ && (event.getEntity() instanceof Player ? GeneralConfig.dropAbilitiesOnPlayerDeath > 0 && (GeneralConfig.alwaysDropAbilities || event.getSource() instanceof EntityDamageSource && event.getSource().m_7639_() instanceof Player) : doMobLoot && event.getSource() instanceof EntityDamageSource && event.getSource().m_7639_() instanceof Player)) {
            LivingEntity entity = event.getEntity();
            entity.getCapability(MutableAbilityStoreConfig.CAPABILITY, null).ifPresent(mutableAbilityStore -> {
                int toDrop = 1;
                if (event.getEntity() instanceof Player && (GeneralConfig.alwaysDropAbilities || event.getSource() instanceof EntityDamageSource && event.getSource().m_7639_() instanceof Player)) {
                    toDrop = GeneralConfig.dropAbilitiesOnPlayerDeath;
                }
                ItemStack itemStack = new ItemStack((ItemLike)RegistryEntries.ITEM_ABILITY_TOTEM);
                IMutableAbilityStore itemStackStore = (IMutableAbilityStore)itemStack.getCapability(MutableAbilityStoreConfig.CAPABILITY, null).orElse(null);
                ((IMutableAbilityStoreRegistryAccess)itemStackStore).setRegistryAccess(event.getEntity().m_9236_().m_5962_());
                ArrayList abilities = Lists.newArrayList(mutableAbilityStore.getAbilities());
                for (Ability ability : abilities) {
                    Ability toRemove;
                    Ability removed;
                    if (toDrop <= 0 || (removed = mutableAbilityStore.removeAbility(toRemove = new Ability(ability.getAbilityType(), toDrop), true)) == null) continue;
                    toDrop -= removed.getLevel();
                    itemStackStore.addAbility(removed, true);
                    entity.m_213846_((Component)Component.m_237110_((String)"chat.everlastingabilities.playerLostAbility", (Object[])new Object[]{entity.m_7755_(), Component.m_237115_((String)removed.getAbilityType().getTranslationKey()).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)removed.getAbilityType().getRarity().f_43022_)).m_131136_(Boolean.valueOf(true))), removed.getLevel()}));
                }
                if (!itemStackStore.getAbilities().isEmpty()) {
                    ItemStackHelpers.spawnItemStack((Level)entity.f_19853_, (BlockPos)entity.m_20183_(), (ItemStack)itemStack);
                }
            });
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        event.getOriginal().reviveCaps();
        IMutableAbilityStore oldStore = (IMutableAbilityStore)event.getOriginal().getCapability(MutableAbilityStoreConfig.CAPABILITY, null).orElse(null);
        IMutableAbilityStore newStore = (IMutableAbilityStore)event.getEntity().getCapability(MutableAbilityStoreConfig.CAPABILITY, null).orElse(null);
        if (oldStore != null && newStore != null) {
            newStore.setAbilities(Maps.newHashMap(oldStore.getAbilitiesRaw()));
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        if (GeneralConfig.tickAbilities && event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            player.getCapability(MutableAbilityStoreConfig.CAPABILITY, null).ifPresent(abilityStore -> {
                for (Ability ability : abilityStore.getAbilities()) {
                    if (!AbilityHelpers.PREDICATE_ABILITY_ENABLED.test(ability.getAbilityType())) continue;
                    if (event.getEntity().f_19853_.m_46467_() % 20L == 0L && GeneralConfig.exhaustionPerAbilityTick > 0.0) {
                        player.m_36399_((float)GeneralConfig.exhaustionPerAbilityTick);
                    }
                    ability.getAbilityType().onTick(player, ability.getLevel());
                }
            });
        }
    }
}

