/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book;

import com.klikli_dev.modonomicon.util.RenderUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class BookIcon {
    private final ItemStack itemStack;
    private final ResourceLocation texture;

    public BookIcon(ItemStack stack) {
        this.itemStack = stack;
        this.texture = null;
    }

    public BookIcon(ResourceLocation texture) {
        this.texture = texture;
        this.itemStack = ItemStack.f_41583_;
    }

    public static BookIcon fromString(ResourceLocation value) {
        if (value.m_135815_().endsWith(".png")) {
            return new BookIcon(value);
        }
        Item item = (Item)Registry.f_122827_.m_7745_(value);
        return new BookIcon(new ItemStack((ItemLike)item));
    }

    public static BookIcon fromNetwork(FriendlyByteBuf buffer) {
        ResourceLocation rl = buffer.m_130281_();
        if (rl.m_135815_().endsWith(".png")) {
            return new BookIcon(rl);
        }
        Item item = (Item)Registry.f_122827_.m_7745_(rl);
        return new BookIcon(new ItemStack((ItemLike)item));
    }

    public void render(PoseStack ms, int x, int y) {
        if (this.texture != null) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.texture);
            GuiComponent.m_93143_((PoseStack)ms, (int)x, (int)y, (int)0, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        } else {
            RenderUtil.renderAndDecorateItemWithPose(ms, this.itemStack, x, y);
        }
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        if (this.texture != null) {
            buffer.m_130085_(this.texture);
        } else {
            buffer.m_130085_(Registry.f_122827_.m_7981_((Object)this.itemStack.m_41720_()));
        }
    }
}

