/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util.inventory;

import dan200.computercraft.shared.Registry;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.util.StringUtil;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.Level;

public class ItemUtil {
    public static final Item TURTLE_NORMAL = (Item)Registry.ModItems.TURTLE_NORMAL.get();
    public static final Item TURTLE_ADVANCED = (Item)Registry.ModItems.TURTLE_ADVANCED.get();
    public static final Item POCKET_NORMAL = (Item)Registry.ModItems.POCKET_COMPUTER_NORMAL.get();
    public static final Item POCKET_ADVANCED = (Item)Registry.ModItems.POCKET_COMPUTER_ADVANCED.get();

    private ItemUtil() {
    }

    public static <T> T getRegistryEntry(String name, IForgeRegistry<T> forgeRegistry) {
        Object value;
        ResourceLocation location;
        try {
            location = new ResourceLocation(name);
        }
        catch (ResourceLocationException ex) {
            location = null;
        }
        if (location != null && forgeRegistry.containsKey(location) && (value = forgeRegistry.getValue(location)) != null) {
            return (T)value;
        }
        return null;
    }

    public static String getFingerprint(ItemStack stack) {
        String fingerprint = stack.m_41784_() + ItemUtil.getRegistryKey(stack).toString() + stack.m_41611_().getString();
        try {
            byte[] bytesOfHash = fingerprint.getBytes(StandardCharsets.UTF_8);
            MessageDigest md = MessageDigest.getInstance("MD5");
            return StringUtil.toHexString(md.digest(bytesOfHash));
        }
        catch (NoSuchAlgorithmException ex) {
            AdvancedPeripherals.debug("Could not parse fingerprint.", Level.ERROR);
            ex.printStackTrace();
            return "";
        }
    }

    public static ItemStack makeTurtle(Item turtle, String upgrade) {
        ItemStack stack = new ItemStack((ItemLike)turtle);
        stack.m_41784_().m_128359_("RightUpgrade", upgrade);
        return stack;
    }

    public static ItemStack makePocket(Item turtle, String upgrade) {
        ItemStack stack = new ItemStack((ItemLike)turtle);
        stack.m_41784_().m_128359_("Upgrade", upgrade);
        return stack;
    }

    public static List<ItemStack> getItemsFromItemHandler(IItemHandler handler) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(handler.getSlots());
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            items.add(handler.getStackInSlot(slot).m_41777_());
        }
        return items;
    }

    public static void addComputerItemToTab(ResourceLocation turtleID, ResourceLocation pocketID, NonNullList<ItemStack> items) {
        if (turtleID != null) {
            items.add((Object)ItemUtil.makeTurtle(TURTLE_ADVANCED, turtleID.toString()));
            items.add((Object)ItemUtil.makeTurtle(TURTLE_NORMAL, turtleID.toString()));
        }
        if (pocketID != null) {
            items.add((Object)ItemUtil.makePocket(POCKET_ADVANCED, pocketID.toString()));
            items.add((Object)ItemUtil.makePocket(POCKET_NORMAL, pocketID.toString()));
        }
    }

    public static ResourceLocation getRegistryKey(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item);
    }

    public static ResourceLocation getRegistryKey(ItemStack item) {
        return ForgeRegistries.ITEMS.getKey((Object)item.m_41777_().m_41720_());
    }
}

