/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.appliedenergistics;

import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.CraftingJobStatus;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingService;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.AEKeyFilter;
import appeng.api.storage.IStorageProvider;
import appeng.api.storage.MEStorage;
import appeng.blockentity.storage.DriveBlockEntity;
import appeng.items.storage.BasicStorageCell;
import dan200.computercraft.shared.util.NBTUtil;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.util.LuaConverter;
import de.srendi.advancedperipherals.common.util.Pair;
import de.srendi.advancedperipherals.common.util.inventory.FluidFilter;
import de.srendi.advancedperipherals.common.util.inventory.ItemFilter;
import de.srendi.advancedperipherals.common.util.inventory.ItemUtil;
import io.github.projectet.ae2things.item.DISKDrive;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.Nullable;

public class AppEngApi {
    public static Pair<Long, AEItemKey> findAEStackFromStack(MEStorage monitor, @Nullable ICraftingService crafting, ItemStack item) {
        return AppEngApi.findAEStackFromFilter(monitor, crafting, ItemFilter.fromStack(item));
    }

    public static Pair<Long, AEItemKey> findAEStackFromFilter(MEStorage monitor, @Nullable ICraftingService crafting, ItemFilter item) {
        AEItemKey key;
        for (Object2LongMap.Entry temp : monitor.getAvailableStacks()) {
            Object object = temp.getKey();
            if (!(object instanceof AEItemKey) || !item.test((key = (AEItemKey)object).toStack())) continue;
            return Pair.of(temp.getLongValue(), key);
        }
        if (crafting == null) {
            return Pair.of(0L, AEItemKey.of((ItemStack)ItemStack.f_41583_));
        }
        for (Object2LongMap.Entry temp : crafting.getCraftables(param -> true)) {
            if (!(temp instanceof AEItemKey) || !item.test((key = (AEItemKey)temp).toStack())) continue;
            return Pair.of(0L, key);
        }
        return Pair.of(0L, AEItemKey.of((ItemStack)ItemStack.f_41583_));
    }

    public static Pair<Long, AEFluidKey> findAEFluidFromStack(MEStorage monitor, @Nullable ICraftingService crafting, FluidStack item) {
        return AppEngApi.findAEFluidFromFilter(monitor, crafting, FluidFilter.fromStack(item));
    }

    public static Pair<Long, AEFluidKey> findAEFluidFromFilter(MEStorage monitor, @Nullable ICraftingService crafting, FluidFilter item) {
        AEFluidKey key;
        for (Object2LongMap.Entry temp : monitor.getAvailableStacks()) {
            Object object = temp.getKey();
            if (!(object instanceof AEFluidKey) || !item.test((key = (AEFluidKey)object).toStack(1))) continue;
            return Pair.of(temp.getLongValue(), key);
        }
        if (crafting == null) {
            return null;
        }
        for (Object2LongMap.Entry temp : crafting.getCraftables(param -> true)) {
            if (!(temp instanceof AEFluidKey) || !item.test((key = (AEFluidKey)temp).toStack(1))) continue;
            return Pair.of(0L, key);
        }
        return null;
    }

    public static List<Object> listStacks(MEStorage monitor, ICraftingService service, int flag) {
        ArrayList<Object> items = new ArrayList<Object>();
        KeyCounter keyCounter = monitor.getAvailableStacks();
        for (Object2LongMap.Entry aeKey : keyCounter) {
            Object object = aeKey.getKey();
            if (!(object instanceof AEItemKey)) continue;
            AEItemKey itemKey = (AEItemKey)object;
            if (flag == 1 && aeKey.getLongValue() < 0L) continue;
            if (flag == 2 && !service.isCraftable((AEKey)itemKey)) {
                service.getCraftables(AEKeyFilter.none()).forEach(aeKey1 -> {
                    Map<String, Object> itemObject = AppEngApi.getObjectFromStack(Pair.of(0L, aeKey1), service);
                    if (keyCounter.get(aeKey1) == 0L && !items.contains(itemObject)) {
                        items.add(itemObject);
                    }
                });
                continue;
            }
            items.add(AppEngApi.getObjectFromStack(Pair.of(aeKey.getLongValue(), itemKey), service));
        }
        return items;
    }

    public static List<Object> listFluids(MEStorage monitor, ICraftingService service, int flag) {
        ArrayList<Object> items = new ArrayList<Object>();
        for (Object2LongMap.Entry aeKey : monitor.getAvailableStacks()) {
            Object object = aeKey.getKey();
            if (!(object instanceof AEFluidKey)) continue;
            AEFluidKey itemKey = (AEFluidKey)object;
            if (flag == 1 && aeKey.getLongValue() < 0L || flag == 2 && !service.isCraftable((AEKey)itemKey)) continue;
            items.add(AppEngApi.getObjectFromStack(Pair.of(aeKey.getLongValue(), itemKey), service));
        }
        return items;
    }

    public static <T extends AEKey> Map<String, Object> getObjectFromStack(Pair<Long, T> stack, @Nullable ICraftingService service) {
        if (stack.getRight() == null) {
            return Collections.emptyMap();
        }
        T t = stack.getRight();
        if (t instanceof AEItemKey) {
            AEItemKey itemKey = (AEItemKey)t;
            return AppEngApi.getObjectFromItemStack(Pair.of(stack.getLeft(), itemKey), service);
        }
        t = stack.getRight();
        if (t instanceof AEFluidKey) {
            AEFluidKey fluidKey = (AEFluidKey)t;
            return AppEngApi.getObjectFromFluidStack(Pair.of(stack.getLeft(), fluidKey), service);
        }
        AdvancedPeripherals.debug("Could not create table from unknown stack " + ((AEKey)stack.getRight()).getClass() + " - Report this to the maintainer of ap", Level.ERROR);
        return Collections.emptyMap();
    }

    private static Map<String, Object> getObjectFromItemStack(Pair<Long, AEItemKey> stack, @Nullable ICraftingService craftingService) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String displayName = stack.getRight().getDisplayName().getString();
        CompoundTag nbt = stack.getRight().toTag();
        long amount = stack.getLeft();
        map.put("fingerprint", ItemUtil.getFingerprint(stack.getRight().toStack()));
        map.put("name", ItemUtil.getRegistryKey(stack.getRight().getItem()).toString());
        map.put("amount", amount);
        map.put("displayName", displayName);
        map.put("nbt", NBTUtil.toLua((Tag)nbt));
        map.put("tags", LuaConverter.tagsToList(() -> ((AEItemKey)stack.getRight()).getItem().m_204114_().m_203616_()));
        map.put("isCraftable", craftingService != null && craftingService.isCraftable((AEKey)stack.getRight()));
        return map;
    }

    private static Map<String, Object> getObjectFromFluidStack(Pair<Long, AEFluidKey> stack, @Nullable ICraftingService craftingService) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        long amount = stack.getLeft();
        map.put("name", ForgeRegistries.FLUIDS.getKey((Object)stack.getRight().getFluid()).toString());
        map.put("amount", amount);
        map.put("displayName", stack.getRight().getDisplayName());
        map.put("tags", LuaConverter.tagsToList(() -> ((AEFluidKey)stack.getRight()).getFluid().m_205069_().m_203616_()));
        map.put("isCraftable", craftingService != null && craftingService.isCraftable((AEKey)stack.getRight()));
        return map;
    }

    public static Map<String, Object> getObjectFromCPU(ICraftingCPU cpu) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        long storage = cpu.getAvailableStorage();
        int coProcessors = cpu.getCoProcessors();
        boolean isBusy = cpu.isBusy();
        map.put("storage", storage);
        map.put("coProcessors", coProcessors);
        map.put("isBusy", isBusy);
        map.put("craftingJob", cpu.getJobStatus() != null ? AppEngApi.getObjectFromJob(cpu.getJobStatus()) : null);
        return map;
    }

    public static Map<String, Object> getObjectFromJob(CraftingJobStatus job) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("storage", AppEngApi.getObjectFromGenericStack(job.crafting()));
        map.put("elapsedTimeNanos", job.elapsedTimeNanos());
        map.put("totalItem", job.totalItems());
        map.put("progress", job.progress());
        return map;
    }

    public static Map<String, Object> getObjectFromGenericStack(GenericStack stack) {
        if (stack.what() == null) {
            return Collections.emptyMap();
        }
        AEKey aEKey = stack.what();
        if (aEKey instanceof AEItemKey) {
            AEItemKey aeItemKey = (AEItemKey)aEKey;
            return AppEngApi.getObjectFromItemStack(Pair.of(stack.amount(), aeItemKey), null);
        }
        aEKey = stack.what();
        if (aEKey instanceof AEFluidKey) {
            AEFluidKey aeFluidKey = (AEFluidKey)aEKey;
            return AppEngApi.getObjectFromFluidStack(Pair.of(stack.amount(), aeFluidKey), null);
        }
        return Collections.emptyMap();
    }

    public static MEStorage getMonitor(IGridNode node) {
        return ((IStorageService)node.getGrid().getService(IStorageService.class)).getInventory();
    }

    public static boolean isItemCrafting(MEStorage monitor, ICraftingService grid, ItemFilter filter, @Nullable ICraftingCPU craftingCPU) {
        Pair<Long, AEItemKey> stack = AppEngApi.findAEStackFromFilter(monitor, grid, filter);
        if (stack == null) {
            return false;
        }
        if (craftingCPU == null) {
            for (ICraftingCPU cpu : grid.getCpus()) {
                CraftingJobStatus jobStatus;
                if (!cpu.isBusy() || (jobStatus = cpu.getJobStatus()) == null || !jobStatus.crafting().what().equals(stack.getRight())) continue;
                return true;
            }
        } else if (craftingCPU.isBusy()) {
            CraftingJobStatus jobStatus = craftingCPU.getJobStatus();
            if (jobStatus == null) {
                return false;
            }
            return jobStatus.crafting().what().equals(stack.getRight());
        }
        return false;
    }

    public static long getTotalItemStorage(IGridNode node) {
        long total = 0L;
        Iterator iterator = node.getGrid().getMachineNodes(DriveBlockEntity.class).iterator();
        if (!iterator.hasNext()) {
            return 0L;
        }
        while (iterator.hasNext()) {
            DriveBlockEntity entity = (DriveBlockEntity)((IGridNode)iterator.next()).getService(IStorageProvider.class);
            if (entity == null) continue;
            InternalInventory inventory = entity.getInternalInventory();
            for (int i = 0; i < inventory.size(); ++i) {
                DISKDrive disk;
                ItemStack stack = inventory.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                Item item = stack.m_41720_();
                if (item instanceof BasicStorageCell) {
                    BasicStorageCell cell = (BasicStorageCell)item;
                    if (!cell.getKeyType().getClass().isAssignableFrom(AEKeyType.items().getClass())) continue;
                    total += (long)cell.getBytes(null);
                    continue;
                }
                item = stack.m_41720_();
                if (!(item instanceof DISKDrive) || !(disk = (DISKDrive)item).getKeyType().toString().equals("ae2:i")) continue;
                total += (long)disk.getBytes(null);
            }
        }
        return total;
    }

    public static long getTotalFluidStorage(IGridNode node) {
        long total = 0L;
        Iterator iterator = node.getGrid().getMachineNodes(DriveBlockEntity.class).iterator();
        if (!iterator.hasNext()) {
            return 0L;
        }
        while (iterator.hasNext()) {
            DriveBlockEntity entity = (DriveBlockEntity)((IGridNode)iterator.next()).getService(IStorageProvider.class);
            if (entity == null) continue;
            InternalInventory inventory = entity.getInternalInventory();
            for (int i = 0; i < inventory.size(); ++i) {
                BasicStorageCell cell;
                Item item;
                ItemStack stack = inventory.getStackInSlot(i);
                if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof BasicStorageCell) || !(cell = (BasicStorageCell)item).getKeyType().getClass().isAssignableFrom(AEKeyType.fluids().getClass())) continue;
                total += (long)cell.getBytes(null);
            }
        }
        return total;
    }

    public static long getUsedItemStorage(IGridNode node) {
        long used = 0L;
        Iterator iterator = node.getGrid().getMachineNodes(DriveBlockEntity.class).iterator();
        if (!iterator.hasNext()) {
            return 0L;
        }
        while (iterator.hasNext()) {
            DriveBlockEntity entity = (DriveBlockEntity)((IGridNode)iterator.next()).getService(IStorageProvider.class);
            if (entity == null) continue;
            InternalInventory inventory = entity.getInternalInventory();
            for (int i = 0; i < inventory.size(); ++i) {
                Item item;
                ItemStack stack = inventory.getStackInSlot(i);
                if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof BasicStorageCell)) continue;
                BasicStorageCell cell = (BasicStorageCell)item;
                int bytesPerType = cell.getBytesPerType(null);
                if (!cell.getKeyType().getClass().isAssignableFrom(AEKeyType.items().getClass()) || stack.m_41783_() == null) continue;
                int numOfType = stack.m_41783_().m_128467_("amts").length;
                long numItemsInCell = stack.m_41783_().m_128454_("ic");
                used += (long)((int)Math.ceil((double)numItemsInCell / 8.0)) + (long)bytesPerType * (long)numOfType;
            }
        }
        return used;
    }

    public static long getUsedFluidStorage(IGridNode node) {
        long used = 0L;
        Iterator iterator = node.getGrid().getMachineNodes(DriveBlockEntity.class).iterator();
        if (!iterator.hasNext()) {
            return 0L;
        }
        while (iterator.hasNext()) {
            DriveBlockEntity entity = (DriveBlockEntity)((IGridNode)iterator.next()).getService(IStorageProvider.class);
            if (entity == null) continue;
            InternalInventory inventory = entity.getInternalInventory();
            for (int i = 0; i < inventory.size(); ++i) {
                DISKDrive disk;
                ItemStack stack = inventory.getStackInSlot(i);
                Item item = stack.m_41720_();
                if (!(item instanceof BasicStorageCell)) continue;
                BasicStorageCell cell = (BasicStorageCell)item;
                int bytesPerType = cell.getBytesPerType(null);
                if (cell.getKeyType().getClass().isAssignableFrom(AEKeyType.fluids().getClass())) {
                    if (stack.m_41783_() == null) continue;
                    int numOfType = stack.m_41783_().m_128467_("amts").length;
                    long numBucketsInCell = stack.m_41783_().m_128454_("ic") / 1000L;
                    used += (long)((int)Math.ceil((double)numBucketsInCell / 8.0)) + (long)bytesPerType * (long)numOfType;
                    continue;
                }
                Item numOfType = stack.m_41720_();
                if (!(numOfType instanceof DISKDrive) || !(disk = (DISKDrive)numOfType).getKeyType().toString().equals("ae2:i") || stack.m_41783_() == null) continue;
                long numItemsInCell = stack.m_41783_().m_128454_("ic");
                used += (long)((int)Math.ceil((double)numItemsInCell / 8.0));
            }
        }
        return used;
    }

    public static long getAvailableItemStorage(IGridNode node) {
        return AppEngApi.getTotalItemStorage(node) - AppEngApi.getUsedItemStorage(node);
    }

    public static long getAvailableFluidStorage(IGridNode node) {
        return AppEngApi.getTotalFluidStorage(node) - AppEngApi.getUsedFluidStorage(node);
    }

    public static List<Object> listCells(IGridNode node) {
        ArrayList<Object> items = new ArrayList<Object>();
        Iterator iterator = node.getGrid().getMachineNodes(DriveBlockEntity.class).iterator();
        if (!iterator.hasNext()) {
            return items;
        }
        while (iterator.hasNext()) {
            DriveBlockEntity entity = (DriveBlockEntity)((IGridNode)iterator.next()).getService(IStorageProvider.class);
            if (entity == null) continue;
            InternalInventory inventory = entity.getInternalInventory();
            for (int i = 0; i < inventory.size(); ++i) {
                ItemStack stack = inventory.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                Item item = stack.m_41720_();
                if (item instanceof BasicStorageCell) {
                    BasicStorageCell cell = (BasicStorageCell)item;
                    items.add(AppEngApi.getObjectFromCell(cell, stack));
                    continue;
                }
                item = stack.m_41720_();
                if (!(item instanceof DISKDrive)) continue;
                DISKDrive disk = (DISKDrive)item;
                items.add(AppEngApi.getObjectFromDisk(disk, stack));
            }
        }
        return items;
    }

    private static Map<String, Object> getObjectFromCell(BasicStorageCell cell, ItemStack stack) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("item", ItemUtil.getRegistryKey(stack.m_41720_()).toString());
        String cellType = "";
        if (cell.getKeyType().getClass().isAssignableFrom(AEKeyType.items().getClass())) {
            cellType = "item";
        } else if (cell.getKeyType().getClass().isAssignableFrom(AEKeyType.fluids().getClass())) {
            cellType = "fluid";
        }
        map.put("cellType", cellType);
        map.put("bytesPerType", cell.getBytesPerType(null));
        map.put("totalBytes", cell.getBytes(null));
        return map;
    }

    private static Map<String, Object> getObjectFromDisk(DISKDrive drive, ItemStack stack) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("item", stack.m_41720_().toString());
        String cellType = "";
        if (drive.getKeyType().toString().equals("ae2:i")) {
            cellType = "item";
        } else if (drive.getKeyType().toString().equals("ae2:f")) {
            cellType = "fluid";
        }
        map.put("cellType", cellType);
        map.put("totalBytes", drive.getBytes(null));
        return map;
    }
}

