/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fmaudio;

import de.keksuccino.fancymenu.api.buttonaction.ButtonActionContainer;
import de.keksuccino.fancymenu.api.buttonaction.ButtonActionRegistry;
import de.keksuccino.fancymenu.api.item.CustomizationItemContainer;
import de.keksuccino.fancymenu.api.item.CustomizationItemRegistry;
import de.keksuccino.fancymenu.api.visibilityrequirements.VisibilityRequirement;
import de.keksuccino.fancymenu.api.visibilityrequirements.VisibilityRequirementRegistry;
import de.keksuccino.fmaudio.EventHandler;
import de.keksuccino.fmaudio.customization.buttonaction.ToggleMuteButtonAction;
import de.keksuccino.fmaudio.customization.item.ACIHandler;
import de.keksuccino.fmaudio.customization.item.AudioCustomizationItemContainer;
import de.keksuccino.fmaudio.customization.visibilityrequirement.IsAudioMutedVisibilityRequirement;
import de.keksuccino.konkrete.Konkrete;
import de.keksuccino.konkrete.config.Config;
import de.keksuccino.konkrete.config.exceptions.InvalidValueException;
import de.keksuccino.konkrete.localization.Locals;
import java.io.File;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="fmextension_audio")
public class FmAudio {
    public static final String VERSION = "1.1.1";
    private static final Logger LOGGER = LogManager.getLogger((String)"fmaudio/FmAudio");
    public static final File MOD_DIR = new File("config/fancymenu/extensions/fmaudio");
    public static final File INSTANCE_DATA_DIR = new File("fancymenu_instance_data/extensions/fmaudio");
    public static Config config;

    public FmAudio() {
        try {
            if (FMLEnvironment.dist == Dist.CLIENT) {
                if (!MOD_DIR.isDirectory()) {
                    MOD_DIR.mkdirs();
                }
                if (!INSTANCE_DATA_DIR.isDirectory()) {
                    INSTANCE_DATA_DIR.mkdirs();
                }
                FmAudio.updateConfig();
                ACIHandler.init();
                CustomizationItemRegistry.registerItem((CustomizationItemContainer)new AudioCustomizationItemContainer());
                ButtonActionRegistry.registerButtonAction((ButtonActionContainer)new ToggleMuteButtonAction());
                VisibilityRequirementRegistry.registerRequirement((VisibilityRequirement)new IsAudioMutedVisibilityRequirement());
                MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
                Konkrete.addPostLoadingEvent((String)"fmextension_audio", this::onClientSetup);
            } else {
                LOGGER.warn("WARNING: FancyMenu Audio Extension is a client mod and has no effect when loaded on a server!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void onClientSetup() {
        try {
            FmAudio.initLocals();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void initLocals() {
        String baseDir = "locals/";
        File f = new File(MOD_DIR.getPath() + "/locals");
        if (!f.exists()) {
            f.mkdirs();
        }
        Locals.copyLocalsFileToDir((ResourceLocation)new ResourceLocation("fmaudio", baseDir + "en_us.local"), (String)"en_us", (String)f.getPath());
        Locals.getLocalsFromDir((String)f.getPath());
    }

    public static void updateConfig() {
        try {
            config = new Config(MOD_DIR.getPath() + "/config.cfg");
            config.registerValue("stop_world_music_in_menu", Boolean.valueOf(false), "world");
            config.registerValue("only_play_out_of_world", Boolean.valueOf(false), "world");
            config.syncConfig();
            config.clearUnusedValues();
        }
        catch (InvalidValueException e) {
            e.printStackTrace();
        }
    }
}

