/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.incubation.core.data.client;

import com.teamabnormals.incubation.core.registry.IncubationBlocks;
import com.teamabnormals.incubation.core.registry.IncubationItems;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.text.WordUtils;

public class IncubationLanguageProvider
extends LanguageProvider {
    public IncubationLanguageProvider(DataGenerator generator) {
        super(generator, "incubation", "en_us");
    }

    public void addTranslations() {
        this.add((Block)IncubationBlocks.CHICKEN_EGG_CRATE.get());
        this.add((Block)IncubationBlocks.TURTLE_EGG_CRATE.get());
        this.add((Block)IncubationBlocks.HAY_NEST.get());
        this.add((Block)IncubationBlocks.HAY_CHICKEN_NEST.get());
        this.add((Block)IncubationBlocks.HAY_DUCK_NEST.get());
        this.add((Block)IncubationBlocks.HAY_TURKEY_NEST.get());
        this.add((Block)IncubationBlocks.TWIG_NEST.get());
        this.add((Block)IncubationBlocks.TWIG_CHICKEN_NEST.get());
        this.add((Block)IncubationBlocks.TWIG_DUCK_NEST.get());
        this.add((Block)IncubationBlocks.TWIG_TURKEY_NEST.get());
        this.add((Item)IncubationItems.FRIED_EGG.get());
        this.add((Item)IncubationItems.SCRAMBLED_EGGS.get());
        this.add("item.incubation.chicken_egg", "Chicken Egg");
    }

    private void add(Item item) {
        ResourceLocation name = ForgeRegistries.ITEMS.getKey((Object)item);
        if (name != null) {
            this.add(item, this.format(name));
        }
    }

    private void add(Block block) {
        ResourceLocation name = ForgeRegistries.BLOCKS.getKey((Object)block);
        if (name != null) {
            this.add(block, this.format(name));
        }
    }

    private String format(ResourceLocation registryName) {
        return WordUtils.capitalizeFully((String)registryName.m_135815_().replace("_", " "));
    }
}

