/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.incubation.core.data.client;

import com.teamabnormals.incubation.common.block.BirdNestBlock;
import com.teamabnormals.incubation.core.registry.IncubationBlocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class IncubationBlockStateProvider
extends BlockStateProvider {
    public IncubationBlockStateProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "incubation", existingFileHelper);
    }

    public void registerStatesAndModels() {
        this.cubeBottomTop((Block)IncubationBlocks.CHICKEN_EGG_CRATE.get());
        this.cubeBottomTop((Block)IncubationBlocks.TURTLE_EGG_CRATE.get());
        this.nestBlocks((Block)IncubationBlocks.TWIG_NEST.get(), (Block)IncubationBlocks.HAY_NEST.get());
        this.nestBlocks("chicken", (Block)IncubationBlocks.TWIG_CHICKEN_NEST.get(), (Block)IncubationBlocks.HAY_CHICKEN_NEST.get());
        this.nestBlocks("duck", (Block)IncubationBlocks.TWIG_DUCK_NEST.get(), (Block)IncubationBlocks.HAY_DUCK_NEST.get());
        this.nestBlocks("turkey", (Block)IncubationBlocks.TWIG_TURKEY_NEST.get(), (Block)IncubationBlocks.HAY_TURKEY_NEST.get());
    }

    public void cubeBottomTop(Block block) {
        ResourceLocation name = ForgeRegistries.BLOCKS.getKey((Object)block);
        this.cubeBottomTop(block, this.prefix("block/", this.suffix(name, "_side")), this.prefix("block/", this.suffix(name, "_bottom")), this.prefix("block/", this.suffix(name, "_top")));
    }

    public void cubeBottomTop(Block block, ResourceLocation sideTexture, ResourceLocation bottomTexture, ResourceLocation topTexture) {
        this.simpleBlock(block, (ModelFile)this.models().cubeBottomTop(this.name(block), sideTexture, bottomTexture, topTexture));
        this.blockItem(block);
    }

    public void blockItem(Block block) {
        this.simpleBlockItem(block, (ModelFile)new ModelFile.ExistingModelFile(this.blockTexture(block), this.models().existingFileHelper));
    }

    public void nestBlocks(String eggType, Block twigNest, Block hayNest) {
        this.eggNest(eggType, (Block)IncubationBlocks.TWIG_NEST.get(), twigNest);
        this.eggNest(eggType, (Block)IncubationBlocks.HAY_NEST.get(), hayNest);
    }

    public void nestBlocks(Block twigNest, Block hayNest) {
        this.eggNest(null, (Block)IncubationBlocks.TWIG_NEST.get(), twigNest);
        this.eggNest(null, (Block)IncubationBlocks.HAY_NEST.get(), hayNest);
    }

    public ModelFile blockModelFile(String name) {
        return new ModelFile.UncheckedModelFile(new ResourceLocation("incubation", "block/" + name));
    }

    public void simpleBlockWithModel(Block block) {
        this.simpleBlock(block, this.blockModelFile(this.name(block)));
    }

    public void eggNest(String eggType, Block base, Block nest) {
        if (eggType != null) {
            ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(nest).part().modelFile(this.blockModelFile(this.name(base))).addModel()).end().part().modelFile(this.blockModelFile("one_" + eggType + "_egg")).addModel()).condition((Property)BirdNestBlock.EGGS, (Comparable[])new Integer[]{1}).end().part().modelFile(this.blockModelFile("two_" + eggType + "_eggs")).addModel()).condition((Property)BirdNestBlock.EGGS, (Comparable[])new Integer[]{2}).end().part().modelFile(this.blockModelFile("three_" + eggType + "_eggs")).addModel()).condition((Property)BirdNestBlock.EGGS, (Comparable[])new Integer[]{3}).end().part().modelFile(this.blockModelFile("four_" + eggType + "_eggs")).addModel()).condition((Property)BirdNestBlock.EGGS, (Comparable[])new Integer[]{4}).end().part().modelFile(this.blockModelFile("five_" + eggType + "_eggs")).addModel()).condition((Property)BirdNestBlock.EGGS, (Comparable[])new Integer[]{5}).end().part().modelFile(this.blockModelFile("six_" + eggType + "_eggs")).addModel()).condition((Property)BirdNestBlock.EGGS, (Comparable[])new Integer[]{6}).end();
        } else {
            this.simpleBlockWithModel(base);
            this.generated((ItemLike)nest);
        }
    }

    private void generated(ItemLike item) {
        ResourceLocation itemName = ForgeRegistries.ITEMS.getKey((Object)item.m_5456_());
        ((ItemModelBuilder)this.itemModels().withExistingParent(itemName.m_135815_(), "item/generated")).texture("layer0", new ResourceLocation("incubation", "item/" + itemName.m_135815_()));
    }

    private String name(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
    }

    private ResourceLocation prefix(String prefix, ResourceLocation rl) {
        return new ResourceLocation(rl.m_135827_(), prefix + rl.m_135815_());
    }

    private ResourceLocation suffix(ResourceLocation rl, String suffix) {
        return new ResourceLocation(rl.m_135827_(), rl.m_135815_() + suffix);
    }
}

