/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.mixin;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Vector3f;
import net.joefoxe.hexerei.fluid.PotionFluidType;
import net.joefoxe.hexerei.tileentity.MixingCauldronTile;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.CubicSampler;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={FogRenderer.class})
public abstract class FogRendererMixin {
    private static float fogRed;
    @Shadow
    private static float f_109011_;
    @Shadow
    private static float f_109012_;
    @Shadow
    private static int f_109013_;
    @Shadow
    private static int f_109014_;
    @Shadow
    private static long f_109015_;

    @OnlyIn(value=Dist.CLIENT)
    @Inject(method={"setupColor"}, at={@At(value="HEAD")}, cancellable=true)
    private static void setupColor(Camera pCamera, float pPartialTicks, ClientLevel pLevel, int pRenderDistanceChunks, float pBossColorModifier, CallbackInfo ci) {
        BlockGetter level = pCamera.f_90550_;
        BlockPos cameraPos = pCamera.m_90588_();
        BlockEntity be = level.m_7702_(cameraPos);
        if (be instanceof MixingCauldronTile) {
            double d1;
            MixingCauldronTile tile = (MixingCauldronTile)be;
            double d0 = pCamera.m_90583_().m_7098_() - 0.1111111119389534;
            BlockPos blockpos = new BlockPos(pCamera.m_90583_().m_7096_(), d0, pCamera.m_90583_().m_7094_());
            if (tile.renderedFluid != null && (d1 = (double)((float)blockpos.m_123342_() + (float)tile.renderedFluid.getAmount() / 2000.0f)) > d0) {
                LivingEntity livingentity1;
                FogType fogtype = FogRendererMixin.getFluidInCamera(tile.renderedFluid);
                Entity entity = pCamera.m_90592_();
                if (fogtype == FogType.WATER) {
                    long i = Util.m_137550_();
                    int j = ((Biome)pLevel.m_204166_(new BlockPos(pCamera.m_90583_())).m_203334_()).m_47561_();
                    if (f_109015_ < 0L) {
                        f_109013_ = j;
                        f_109014_ = j;
                        f_109015_ = i;
                    }
                    int k = f_109013_ >> 16 & 0xFF;
                    int l = f_109013_ >> 8 & 0xFF;
                    int i1 = f_109013_ & 0xFF;
                    int j1 = f_109014_ >> 16 & 0xFF;
                    int k1 = f_109014_ >> 8 & 0xFF;
                    int l1 = f_109014_ & 0xFF;
                    float f = Mth.m_14036_((float)((float)(i - f_109015_) / 5000.0f), (float)0.0f, (float)1.0f);
                    float f1 = Mth.m_14179_((float)f, (float)j1, (float)k);
                    float f2 = Mth.m_14179_((float)f, (float)k1, (float)l);
                    float f3 = Mth.m_14179_((float)f, (float)l1, (float)i1);
                    fogRed = f1 / 255.0f;
                    f_109011_ = f2 / 255.0f;
                    f_109012_ = f3 / 255.0f;
                    if (f_109013_ != j) {
                        f_109013_ = j;
                        f_109014_ = Mth.m_14143_((float)f1) << 16 | Mth.m_14143_((float)f2) << 8 | Mth.m_14143_((float)f3);
                        f_109015_ = i;
                    }
                } else if (fogtype == FogType.LAVA) {
                    fogRed = 0.6f;
                    f_109011_ = 0.1f;
                    f_109012_ = 0.0f;
                    f_109015_ = -1L;
                } else if (fogtype == FogType.POWDER_SNOW) {
                    fogRed = 0.623f;
                    f_109011_ = 0.734f;
                    f_109012_ = 0.785f;
                    f_109015_ = -1L;
                    RenderSystem.m_69424_((float)fogRed, (float)f_109011_, (float)f_109012_, (float)0.0f);
                } else {
                    float f15;
                    float f4 = 0.25f + 0.75f * (float)pRenderDistanceChunks / 32.0f;
                    f4 = 1.0f - (float)Math.pow(f4, 0.25);
                    Vec3 vec3 = pLevel.m_171660_(pCamera.m_90583_(), pPartialTicks);
                    float f6 = (float)vec3.f_82479_;
                    float f8 = (float)vec3.f_82480_;
                    float f10 = (float)vec3.f_82481_;
                    float f11 = Mth.m_14036_((float)(Mth.m_14089_((float)(pLevel.m_46942_(pPartialTicks) * ((float)Math.PI * 2))) * 2.0f + 0.5f), (float)0.0f, (float)1.0f);
                    BiomeManager biomemanager = pLevel.m_7062_();
                    Vec3 vec31 = pCamera.m_90583_().m_82492_(2.0, 2.0, 2.0).m_82490_(0.25);
                    Vec3 vec32 = CubicSampler.m_130038_((Vec3)vec31, (p_109033_, p_109034_, p_109035_) -> pLevel.m_104583_().m_5927_(Vec3.m_82501_((int)((Biome)biomemanager.m_204210_(p_109033_, p_109034_, p_109035_).m_203334_()).m_47539_()), f11));
                    fogRed = (float)vec32.m_7096_();
                    f_109011_ = (float)vec32.m_7098_();
                    f_109012_ = (float)vec32.m_7094_();
                    if (pRenderDistanceChunks >= 4) {
                        float[] afloat;
                        float f12 = Mth.m_14031_((float)pLevel.m_46490_(pPartialTicks)) > 0.0f ? -1.0f : 1.0f;
                        Vector3f vector3f = new Vector3f(f12, 0.0f, 0.0f);
                        float f16 = pCamera.m_90596_().m_122276_(vector3f);
                        if (f16 < 0.0f) {
                            f16 = 0.0f;
                        }
                        if (f16 > 0.0f && (afloat = pLevel.m_104583_().m_7518_(pLevel.m_46942_(pPartialTicks), pPartialTicks)) != null) {
                            fogRed = fogRed * (1.0f - (f16 *= afloat[3])) + afloat[0] * f16;
                            f_109011_ = f_109011_ * (1.0f - f16) + afloat[1] * f16;
                            f_109012_ = f_109012_ * (1.0f - f16) + afloat[2] * f16;
                        }
                    }
                    fogRed += (f6 - fogRed) * f4;
                    f_109011_ += (f8 - f_109011_) * f4;
                    f_109012_ += (f10 - f_109012_) * f4;
                    float f13 = pLevel.m_46722_(pPartialTicks);
                    if (f13 > 0.0f) {
                        float f14 = 1.0f - f13 * 0.5f;
                        float f17 = 1.0f - f13 * 0.4f;
                        fogRed *= f14;
                        f_109011_ *= f14;
                        f_109012_ *= f17;
                    }
                    if ((f15 = pLevel.m_46661_(pPartialTicks)) > 0.0f) {
                        float f18 = 1.0f - f15 * 0.5f;
                        fogRed *= f18;
                        f_109011_ *= f18;
                        f_109012_ *= f18;
                    }
                    f_109015_ = -1L;
                }
                float f5 = ((float)pCamera.m_90583_().f_82480_ - (float)pLevel.m_141937_()) * pLevel.m_6106_().m_205519_();
                if (f5 < 1.0f && fogtype != FogType.LAVA && fogtype != FogType.POWDER_SNOW) {
                    if (f5 < 0.0f) {
                        f5 = 0.0f;
                    }
                    f5 *= f5;
                    fogRed *= f5;
                    f_109011_ *= f5;
                    f_109012_ *= f5;
                }
                if (pBossColorModifier > 0.0f) {
                    fogRed = fogRed * (1.0f - pBossColorModifier) + fogRed * 0.7f * pBossColorModifier;
                    f_109011_ = f_109011_ * (1.0f - pBossColorModifier) + f_109011_ * 0.6f * pBossColorModifier;
                    f_109012_ = f_109012_ * (1.0f - pBossColorModifier) + f_109012_ * 0.6f * pBossColorModifier;
                }
                float f7 = fogtype == FogType.WATER ? (entity instanceof LocalPlayer ? ((LocalPlayer)entity).m_108639_() : 1.0f) : (entity instanceof LivingEntity && (livingentity1 = (LivingEntity)entity).m_21023_(MobEffects.f_19611_) && !livingentity1.m_21023_(MobEffects.f_216964_) ? GameRenderer.m_109108_((LivingEntity)livingentity1, (float)pPartialTicks) : 0.0f);
                if (fogRed != 0.0f && f_109011_ != 0.0f && f_109012_ != 0.0f) {
                    float f9 = Math.min(1.0f / fogRed, Math.min(1.0f / f_109011_, 1.0f / f_109012_));
                    fogRed = fogRed * (1.0f - f7) + fogRed * f9 * f7;
                    f_109011_ = f_109011_ * (1.0f - f7) + f_109011_ * f9 * f7;
                    f_109012_ = f_109012_ * (1.0f - f7) + f_109012_ * f9 * f7;
                }
                Vector3f fogColor = FogRendererMixin.getFogColor(pCamera, pPartialTicks, pLevel, pRenderDistanceChunks, pBossColorModifier, fogRed, f_109011_, f_109012_, tile.renderedFluid);
                fogRed = fogColor.m_122239_();
                f_109011_ = fogColor.m_122260_();
                f_109012_ = fogColor.m_122269_();
                RenderSystem.m_69424_((float)fogRed, (float)f_109011_, (float)f_109012_, (float)0.0f);
                ci.cancel();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @Inject(method={"setupFog"}, at={@At(value="HEAD")}, cancellable=true)
    private static void setupFog(Camera pCamera, FogRenderer.FogMode pFogMode, float pFarPlaneDistance, boolean p_234176_, float p_234177_, CallbackInfo ci) {
        BlockGetter level = pCamera.f_90550_;
        BlockPos cameraPos = pCamera.m_90588_();
        BlockEntity be = level.m_7702_(cameraPos);
        if (be instanceof MixingCauldronTile) {
            double d1;
            MixingCauldronTile tile = (MixingCauldronTile)be;
            double d0 = pCamera.m_90583_().m_7098_() - 0.1111111119389534;
            BlockPos blockpos = new BlockPos(pCamera.m_90583_().m_7096_(), d0, pCamera.m_90583_().m_7094_());
            if (tile.renderedFluid != null && (d1 = (double)((float)blockpos.m_123342_() + (float)tile.renderedFluid.getAmount() / 2000.0f)) > d0) {
                FogType fogtype = FogRendererMixin.getFluidInCamera(tile.renderedFluid);
                Entity entity = pCamera.m_90592_();
                HexereiUtil.FogData fogrenderer$fogdata = new HexereiUtil.FogData(pFogMode);
                fogrenderer$fogdata.start = -8.0f;
                fogrenderer$fogdata.end = 96.0f;
                if (entity instanceof LocalPlayer) {
                    LocalPlayer localplayer = (LocalPlayer)entity;
                    fogrenderer$fogdata.end *= Math.max(0.25f, FogRendererMixin.getWaterVision(localplayer));
                    Holder holder = localplayer.f_19853_.m_204166_(localplayer.m_20183_());
                    if (holder.m_203656_(BiomeTags.f_215802_)) {
                        fogrenderer$fogdata.end *= 0.85f;
                    }
                }
                if (fogrenderer$fogdata.end > pFarPlaneDistance) {
                    fogrenderer$fogdata.end = pFarPlaneDistance;
                    fogrenderer$fogdata.shape = FogShape.CYLINDER;
                }
                RenderSystem.m_157445_((float)fogrenderer$fogdata.start);
                RenderSystem.m_157443_((float)fogrenderer$fogdata.end);
                RenderSystem.m_202160_((FogShape)fogrenderer$fogdata.shape);
                FogRendererMixin.onFogRender(pFogMode, fogtype, pCamera, p_234177_, pFarPlaneDistance, fogrenderer$fogdata.start, fogrenderer$fogdata.end, fogrenderer$fogdata.shape, tile.renderedFluid.getFluid());
                ci.cancel();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static float getWaterVision(LocalPlayer localPlayer) {
        float f = 600.0f;
        float f1 = 100.0f;
        if ((float)localPlayer.f_108615_ >= 600.0f) {
            return 1.0f;
        }
        float f2 = Mth.m_14036_((float)((float)localPlayer.f_108615_ / 100.0f), (float)0.0f, (float)1.0f);
        float f3 = (float)localPlayer.f_108615_ < 100.0f ? 0.0f : Mth.m_14036_((float)(((float)localPlayer.f_108615_ - 100.0f) / 500.0f), (float)0.0f, (float)1.0f);
        return f2 * 0.6f + f3 * 0.39999998f;
    }

    private static FogType getFluidInCamera(FluidStack fluidStack) {
        if (fluidStack.getFluid().m_205067_(FluidTags.f_13131_)) {
            return FogType.WATER;
        }
        if (fluidStack.getFluid().m_205067_(FluidTags.f_13132_)) {
            return FogType.LAVA;
        }
        return FogType.NONE;
    }

    private static Vector3f getFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, float fogRed, float fogGreen, float fogBlue, FluidStack fluid) {
        Vector3f in = new Vector3f(fogRed, fogGreen, fogBlue);
        Vector3f fluidFogColor = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid()).modifyFogColor(camera, partialTick, level, renderDistance, darkenWorldAmount, in);
        if (fluidFogColor.equals((Object)in) && ForgeRegistries.FLUIDS.getKey((Object)fluid.getFluid()).m_135815_().equals("potion")) {
            float[] f = HexereiUtil.rgbIntToFloatArray(PotionFluidType.getTintColor(fluid));
            fluidFogColor = new Vector3f(f[0], f[1], f[2]);
        }
        ViewportEvent.ComputeFogColor event = new ViewportEvent.ComputeFogColor(camera, partialTick, fluidFogColor.m_122239_(), fluidFogColor.m_122260_(), fluidFogColor.m_122269_());
        MinecraftForge.EVENT_BUS.post((Event)event);
        fluidFogColor.m_122245_(event.getRed(), event.getGreen(), event.getBlue());
        return fluidFogColor;
    }

    private static void onFogRender(FogRenderer.FogMode mode, FogType type, Camera camera, float partialTick, float renderDistance, float nearDistance, float farDistance, FogShape shape, Fluid fluid) {
        IClientFluidTypeExtensions.of((Fluid)fluid).modifyFogRender(camera, mode, renderDistance, partialTick, nearDistance, farDistance, shape);
        ViewportEvent.RenderFog event = new ViewportEvent.RenderFog(mode, type, camera, partialTick, nearDistance, farDistance, shape);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            RenderSystem.m_157445_((float)event.getNearPlaneDistance());
            RenderSystem.m_157443_((float)event.getFarPlaneDistance());
            RenderSystem.m_202160_((FogShape)event.getFogShape());
        }
    }

    static {
        f_109013_ = -1;
        f_109014_ = -1;
        f_109015_ = -1L;
    }
}

