/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.light;

import net.joefoxe.hexerei.config.HexConfig;
import net.joefoxe.hexerei.light.LightManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class DynamicLightUtil {
    public static int getSectionCoord(double coord) {
        return DynamicLightUtil.getSectionCoord(Mth.m_14107_((double)coord));
    }

    public static int getSectionCoord(int coord) {
        return coord >> 4;
    }

    private static int getLuminance(Entity entity) {
        if (entity.m_6060_() || entity.m_142038_()) {
            return 15;
        }
        if (HexConfig.ENTITY_LIGHT_MAP.containsKey(DynamicLightUtil.keyFor(entity))) {
            return HexConfig.ENTITY_LIGHT_MAP.get(DynamicLightUtil.keyFor(entity));
        }
        return Math.min(15, LightManager.getValue(entity));
    }

    public static boolean couldGiveLight(Entity entity) {
        Player player;
        return LightManager.getLightRegistry().containsKey(entity.m_6095_()) || HexConfig.ENTITY_LIGHT_MAP.containsKey(DynamicLightUtil.keyFor(entity)) || entity instanceof Player && DynamicLightUtil.getPlayerLight(player = (Player)entity) > 0 || entity.m_6060_() || entity.m_142038_();
    }

    public static int getPlayerLight(Player player) {
        int mainLight = HexConfig.ITEM_LIGHTMAP.getOrDefault(DynamicLightUtil.keyFor((ItemLike)player.m_21205_().m_41720_()), 0);
        int offHandLight = HexConfig.ITEM_LIGHTMAP.getOrDefault(DynamicLightUtil.keyFor((ItemLike)player.m_21206_().m_41720_()), 0);
        return Math.max(mainLight, offHandLight);
    }

    public static int lightForEntity(Entity entity) {
        int light = 0;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            light = DynamicLightUtil.getPlayerLight(player);
        }
        if (entity.m_6060_() || entity.m_142038_()) {
            return 15;
        }
        if (light < 15 && LightManager.containsEntity((EntityType<? extends Entity>)entity.m_6095_())) {
            int entityLuminance = DynamicLightUtil.getLuminance(entity);
            return Math.max(entityLuminance, light);
        }
        return Math.min(15, light);
    }

    public static int fromItemLike(ItemLike itemLike) {
        return HexConfig.ITEM_LIGHTMAP.getOrDefault(DynamicLightUtil.keyFor(itemLike), 0);
    }

    public static ResourceLocation keyFor(Entity entity) {
        return ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
    }

    public static ResourceLocation keyFor(ItemLike itemLike) {
        return ForgeRegistries.ITEMS.getKey((Object)itemLike.m_5456_());
    }
}

