/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.item.custom;

import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.message.DowsingRodUpdatePositionPacket;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.PacketDistributor;

public class DowsingRodItem
extends Item {
    public static final TagKey<Biome> BT_SWAMP = DowsingRodItem.createBiomeTag("has_structure/dark_coven_biomes");
    public BlockPos nearestPos = null;
    public boolean swampMode = true;
    private static final int distBetweenChecks = 30;
    private static final int searchOffset = 10;
    private static final int numOfChecks = 120;
    private static final int maxRadiusI = 600;
    private int radiusI = 0;
    private int angleI = 0;
    private BlockPos playerPos;
    public static final DynamicCommandExceptionType ERROR_INVALID_BIOME = new DynamicCommandExceptionType(p_137850_ -> Component.m_237110_((String)"commands.locatebiome.invalid", (Object[])new Object[]{p_137850_}));

    public DowsingRodItem(Item.Properties properties) {
        super(properties);
    }

    public static double angleDifference(double angle1, double angle2) {
        double diff = (angle2 - angle1 + 180.0) % 360.0 - 180.0;
        return diff < -180.0 ? diff + 360.0 : diff;
    }

    public void m_6883_(ItemStack p_41404_, Level world, Entity entity, int p_41407_, boolean p_41408_) {
        super.m_6883_(p_41404_, world, entity, p_41407_, p_41408_);
        if (entity instanceof Player && (this.nearestPos == null && ((Player)entity).m_21205_() == p_41404_ || ((Player)entity).m_21206_() == p_41404_)) {
            if (this.swampMode) {
                this.findSwamp(world, entity);
            } else {
                this.findJungle(world, entity);
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        BlockHitResult raytraceresult = DowsingRodItem.m_41435_((Level)worldIn, (Player)playerIn, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (playerIn.m_36341_()) {
            if (!worldIn.f_46443_) {
                playerIn.m_36335_().m_41524_((Item)this, 20);
                this.swampMode = !this.swampMode;
                String s = "display.hexerei.dowsing_rod_swamp";
                if (!this.swampMode) {
                    s = "display.hexerei.dowsing_rod_jungle";
                }
                if (this.swampMode) {
                    this.findSwamp(worldIn, (Entity)playerIn);
                } else {
                    this.findJungle(worldIn, (Entity)playerIn);
                }
                playerIn.m_5661_((Component)Component.m_237115_((String)s), true);
            }
            playerIn.m_6674_(handIn);
        } else {
            if (this.swampMode) {
                this.findSwamp(worldIn, (Entity)playerIn);
                playerIn.m_5661_((Component)Component.m_237115_((String)"display.hexerei.dowsing_rod_swamp_new"), true);
            } else {
                this.findJungle(worldIn, (Entity)playerIn);
                playerIn.m_5661_((Component)Component.m_237115_((String)"display.hexerei.dowsing_rod_jungle_new"), true);
            }
            playerIn.m_6674_(handIn);
        }
        if (!worldIn.f_46443_ && this.nearestPos != null) {
            HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> worldIn.m_46745_(playerIn.m_20183_())), (Object)new DowsingRodUpdatePositionPacket(itemstack, this.nearestPos, this.swampMode));
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    public void findSwamp(Level worldIn, Entity entity) {
        Predicate<Holder> SWAMP;
        ServerLevel serverLevel;
        Pair pair;
        if (worldIn instanceof ServerLevel && (pair = (serverLevel = (ServerLevel)worldIn).m_215069_(SWAMP = p_211672_ -> BuiltinRegistries.f_123865_.m_203561_(BT_SWAMP).m_203333_(p_211672_), entity.m_20183_(), 6400, 32, 64)) != null) {
            this.nearestPos = (BlockPos)pair.getFirst();
        }
    }

    public void findJungle(Level worldIn, Entity entity) {
        Predicate<Holder> JUNGLE;
        ServerLevel serverLevel;
        Pair pair;
        if (worldIn instanceof ServerLevel && (pair = (serverLevel = (ServerLevel)worldIn).m_215069_(JUNGLE = p_211672_ -> BuiltinRegistries.f_123865_.m_203561_(BiomeTags.f_207610_).m_203333_(p_211672_), entity.m_20183_(), 6400, 32, 64)) != null) {
            this.nearestPos = (BlockPos)pair.getFirst();
        }
    }

    private static TagKey<Biome> createBiomeTag(String name) {
        return TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("hexerei", name));
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flagIn) {
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237110_((String)"<%s>", (Object[])new Object[]{Component.m_237115_((String)"tooltip.hexerei.shift").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xAA6600)))}).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.hexerei.dowsing_rod_2").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.hexerei.dowsing_rod_3").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.hexerei.dowsing_rod_4").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.hexerei.dowsing_rod_5").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
        } else {
            tooltip.add((Component)Component.m_237110_((String)"[%s]", (Object[])new Object[]{Component.m_237115_((String)"tooltip.hexerei.shift").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xAAAA00)))}).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.hexerei.dowsing_rod").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
        }
        super.m_7373_(stack, world, tooltip, flagIn);
    }
}

