/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.data.recipes.ModRecipeTypes;
import net.joefoxe.hexerei.fluid.FluidIngredient;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidMixingRecipe
implements Recipe<SimpleContainer> {
    private final ResourceLocation id;
    private final NonNullList<Ingredient> recipeItems;
    private final FluidStack liquid;
    private final FluidStack liquidOutput;
    protected static final List<Boolean> itemMatchesSlot = new ArrayList<Boolean>();
    private final HeatCondition heatCondition;

    public boolean m_5598_() {
        return true;
    }

    public FluidMixingRecipe(ResourceLocation id, NonNullList<Ingredient> recipeItems, FluidStack liquid, FluidStack liquidOutput) {
        this.id = id;
        this.recipeItems = recipeItems;
        this.liquid = liquid;
        this.liquidOutput = liquidOutput;
        this.heatCondition = HeatCondition.NONE;
        for (int i = 0; i < 8; ++i) {
            itemMatchesSlot.add(false);
        }
    }

    public FluidMixingRecipe(ResourceLocation id, NonNullList<Ingredient> recipeItems, FluidStack liquid, FluidStack liquidOutput, HeatCondition heatCondition) {
        this.id = id;
        this.recipeItems = recipeItems;
        this.liquid = liquid;
        this.liquidOutput = liquidOutput;
        this.heatCondition = heatCondition;
        for (int i = 0; i < 8; ++i) {
            itemMatchesSlot.add(false);
        }
    }

    public List<FluidIngredient> getFluidIngredients() {
        return new ArrayList<FluidIngredient>(List.of(FluidIngredient.fromFluidStack(this.liquid)));
    }

    public FluidIngredient getFluidIngredient() {
        return FluidIngredient.fromFluidStack(this.liquid);
    }

    public boolean matches(SimpleContainer inv, Level worldIn) {
        for (int i = 0; i < 8; ++i) {
            itemMatchesSlot.set(i, false);
        }
        boolean flag = false;
        for (Ingredient recipeItem : this.recipeItems) {
            for (int i = 0; i < 8; ++i) {
                if (!recipeItem.test(inv.m_8020_(i)) || itemMatchesSlot.get(i).booleanValue()) continue;
                itemMatchesSlot.set(i, true);
                flag = true;
                break;
            }
            if (!flag) break;
            flag = false;
        }
        for (int i = 0; i < 8; ++i) {
            if (itemMatchesSlot.get(i).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.recipeItems;
    }

    public ItemStack assemble(SimpleContainer p_44001_) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int p_43999_, int p_44000_) {
        return true;
    }

    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    public HeatCondition getHeatCondition() {
        return this.heatCondition;
    }

    public FluidStack getLiquid() {
        return this.liquid;
    }

    public FluidStack getLiquidOutput() {
        return this.liquidOutput;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)ModBlocks.MIXING_CAULDRON.get());
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeTypes.FLUID_MIXING_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static enum HeatCondition implements StringRepresentable
    {
        NONE,
        HEATED,
        SUPERHEATED;


        public String toString() {
            return this.m_7912_();
        }

        public static HeatCondition getHeated(String str) {
            return switch (str) {
                case "heated" -> HEATED;
                case "superheated" -> SUPERHEATED;
                default -> NONE;
            };
        }

        public String m_7912_() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case HEATED -> "heated";
                case SUPERHEATED -> "superheated";
                case NONE -> "none";
            };
        }
    }

    public static class Type
    implements RecipeType<FluidMixingRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "fluid_mixing";

        private Type() {
        }
    }

    public static class Serializer
    implements RecipeSerializer<FluidMixingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("hexerei", "fluid_mixing");

        public FluidMixingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            FluidStack liquid = Serializer.deserializeFluidStack(GsonHelper.m_13930_((JsonObject)json, (String)"input"));
            FluidStack liquidOutput = Serializer.deserializeFluidStack(GsonHelper.m_13930_((JsonObject)json, (String)"output"));
            String heatRequirement = GsonHelper.m_13851_((JsonObject)json, (String)"heatRequirement", (String)"none");
            HeatCondition heatCondition = HeatCondition.getHeated(heatRequirement);
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            NonNullList inputs = NonNullList.m_122780_((int)8, (Object)Ingredient.f_43901_);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43917_((JsonElement)ingredients.get(i)));
            }
            return new FluidMixingRecipe(recipeId, (NonNullList<Ingredient>)inputs, liquid, liquidOutput, heatCondition);
        }

        @Nullable
        public FluidMixingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            NonNullList inputs = NonNullList.m_122780_((int)8, (Object)Ingredient.f_43901_);
            for (int i = 0; i < buffer.readInt(); ++i) {
                inputs.add((Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            FluidStack inputFluid = buffer.readFluidStack();
            FluidStack outputFluid = buffer.readFluidStack();
            HeatCondition heated = (HeatCondition)buffer.m_130066_(HeatCondition.class);
            return new FluidMixingRecipe(recipeId, (NonNullList<Ingredient>)inputs, inputFluid, outputFluid, heated);
        }

        public void toNetwork(FriendlyByteBuf buffer, FluidMixingRecipe recipe) {
            buffer.writeInt(recipe.m_7527_().size());
            for (Ingredient ing : recipe.m_7527_()) {
                ing.m_43923_(buffer);
            }
            buffer.writeFluidStack(recipe.getLiquid());
            buffer.writeFluidStack(recipe.getLiquidOutput());
            buffer.m_130068_((Enum)recipe.heatCondition);
        }

        public static FluidStack deserializeFluidStack(JsonObject json) {
            ResourceLocation id = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"fluid"));
            Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(id);
            if (fluid == null) {
                throw new JsonSyntaxException("Unknown fluid '" + id + "'");
            }
            FluidStack stack = new FluidStack(fluid, 1);
            if (!json.has("nbt")) {
                return stack;
            }
            try {
                JsonElement element = json.get("nbt");
                stack.setTag(TagParser.m_129359_((String)(element.isJsonObject() ? Hexerei.GSON.toJson(element) : GsonHelper.m_13805_((JsonElement)element, (String)"nbt"))));
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
            return stack;
        }
    }
}

