/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.block.custom;

import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.block.ITileEntity;
import net.joefoxe.hexerei.container.MixingCauldronContainer;
import net.joefoxe.hexerei.fluid.ModFluids;
import net.joefoxe.hexerei.fluid.PotionFluid;
import net.joefoxe.hexerei.fluid.PotionFluidHandler;
import net.joefoxe.hexerei.item.ModItems;
import net.joefoxe.hexerei.particle.ModParticleTypes;
import net.joefoxe.hexerei.tileentity.MixingCauldronTile;
import net.joefoxe.hexerei.tileentity.ModTileEntities;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.HexereiTags;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.joefoxe.hexerei.util.message.EmitParticlesPacket;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;

public class MixingCauldron
extends BaseEntityBlock
implements ITileEntity<MixingCauldronTile>,
DyeableLeatherItem {
    public static final IntegerProperty LEVEL = IntegerProperty.m_61631_((String)"level", (int)0, (int)3);
    public static final IntegerProperty CRAFT_DELAY = IntegerProperty.m_61631_((String)"delay", (int)0, (int)100);
    public static final BooleanProperty GUI_RENDER = BooleanProperty.m_61465_((String)"gui_render");
    public static final BooleanProperty DYED = BooleanProperty.m_61465_((String)"dyed");
    public int emitParticles;
    public static final VoxelShape SHAPE = Stream.of(Block.m_49796_((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0), Block.m_49796_((double)0.0, (double)1.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)1.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0), Block.m_49796_((double)14.0, (double)1.0, (double)2.0, (double)16.0, (double)16.0, (double)14.0), Block.m_49796_((double)-1.0, (double)3.0, (double)-1.0, (double)17.0, (double)14.0, (double)2.0), Block.m_49796_((double)-1.0, (double)3.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0), Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)3.0, (double)1.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)1.0, (double)3.0), Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)3.0), Block.m_49796_((double)13.0, (double)0.0, (double)13.0, (double)16.0, (double)1.0, (double)16.0), Block.m_49796_((double)2.0, (double)3.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0), Block.m_49796_((double)14.0, (double)3.0, (double)2.0, (double)17.0, (double)14.0, (double)14.0), Block.m_49796_((double)-1.0, (double)3.0, (double)14.0, (double)17.0, (double)14.0, (double)17.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public RenderShape m_7514_(BlockState iBlockState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)CRAFT_DELAY, (Comparable)Integer.valueOf(0))).m_61124_((Property)DYED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)GUI_RENDER, (Comparable)Boolean.valueOf(false));
    }

    protected boolean canReceiveStalactiteDrip(Fluid pFluid) {
        return true;
    }

    protected void receiveStalactiteDrip(BlockState pState, Level pLevel, BlockPos pPos, Fluid pFluid) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof MixingCauldronTile) {
            MixingCauldronTile mixingCauldron = (MixingCauldronTile)blockEntity;
            if (mixingCauldron.getFluidStack().isEmpty()) {
                mixingCauldron.fill(new FluidStack(pFluid, 100), IFluidHandler.FluidAction.EXECUTE);
            } else if (mixingCauldron.getFluidStack().getFluid() == pFluid && mixingCauldron.getFluidStack().getAmount() < 2000) {
                mixingCauldron.getFluidStack().grow(100);
                if (mixingCauldron.getFluidStack().getAmount() > 2000) {
                    mixingCauldron.getFluidStack().setAmount(2000);
                }
            }
            mixingCauldron.sync();
        }
    }

    public boolean m_7923_(BlockState p_220074_1_) {
        return true;
    }

    public VoxelShape m_5940_(BlockState p_220053_1_, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        return SHAPE;
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        MixingCauldronTile cauldronTile;
        ItemStack stack = player.m_21120_(hand).m_41777_();
        Random random = new Random();
        BlockEntity tileEntity = world.m_7702_(pos);
        if (!(tileEntity instanceof MixingCauldronTile) || (cauldronTile = (MixingCauldronTile)tileEntity).m_58904_() == null) {
            return InteractionResult.SUCCESS;
        }
        if (stack.m_150930_((Item)ModItems.CROW_FLUTE.get()) && stack.m_41784_().m_128451_("commandMode") == 2) {
            stack.m_41661_(new UseOnContext(player, hand, rayTraceResult));
            return InteractionResult.SUCCESS;
        }
        if (stack.m_204117_(HexereiTags.Items.SIGILS)) {
            MixingCauldronTile mixingCauldronTile = (MixingCauldronTile)tileEntity;
            if (mixingCauldronTile.getItemStackInSlot(9).m_41619_()) {
                stack.m_41764_(1);
                mixingCauldronTile.m_6836_(9, stack);
                player.m_21120_(hand).m_41774_(1);
                tileEntity.m_6596_();
                return InteractionResult.SUCCESS;
            }
            if (!mixingCauldronTile.getItemStackInSlot(9).m_150930_(stack.m_41720_())) {
                player.f_36093_.m_150079_(mixingCauldronTile.getItemStackInSlot(9));
                stack.m_41764_(1);
                mixingCauldronTile.m_6836_(9, stack);
                player.m_21120_(hand).m_41774_(1);
                tileEntity.m_6596_();
                return InteractionResult.SUCCESS;
            }
        }
        ItemStack fillStack = stack.m_41777_();
        fillStack.m_41764_(1);
        LazyOptional fluidHandlerOptional = fillStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
        if (fluidHandlerOptional.isPresent()) {
            IFluidHandlerItem fluidHandler = (IFluidHandlerItem)fluidHandlerOptional.resolve().get();
            if (cauldronTile.interactWithFluid(fluidHandler)) {
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                    if (stack.m_41619_()) {
                        player.m_21008_(hand, fluidHandler.getContainer());
                    } else {
                        player.m_21008_(hand, stack);
                        if (!player.m_150109_().m_36054_(fluidHandler.getContainer())) {
                            player.m_36176_(fluidHandler.getContainer(), false);
                        }
                    }
                }
                if (!cauldronTile.m_58904_().f_46443_) {
                    HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> tileEntity.m_58904_().m_46745_(cauldronTile.getPos())), (Object)new EmitParticlesPacket(cauldronTile.getPos(), 3, false));
                }
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            }
            return InteractionResult.SUCCESS;
        }
        if (stack.m_41720_() == Items.f_42590_) {
            if (cauldronTile.getFluidStack().getAmount() >= 333) {
                if (cauldronTile.getFluidStack().isFluidEqual(new FluidStack((Fluid)Fluids.f_76193_, 1))) {
                    ItemStack itemstack4 = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_);
                    player.m_36220_(Stats.f_12944_);
                    if (!player.m_7500_()) {
                        player.m_21120_(hand).m_41774_(1);
                        if (player.m_21120_(hand).m_41619_()) {
                            player.m_21008_(hand, itemstack4);
                        } else if (!player.m_150109_().m_36054_(itemstack4)) {
                            player.m_36176_(itemstack4, false);
                        }
                    }
                    cauldronTile.getFluidStack().shrink(333);
                    if (cauldronTile.getFluidStack().getAmount() % 10 == 1) {
                        cauldronTile.getFluidStack().shrink(1);
                    }
                    if (cauldronTile.getFluidStack().getAmount() % 10 == 9) {
                        cauldronTile.getFluidStack().grow(1);
                    }
                    if (!cauldronTile.m_58904_().f_46443_) {
                        HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> cauldronTile.m_58904_().m_46745_(cauldronTile.getPos())), (Object)new EmitParticlesPacket(cauldronTile.getPos(), 3, false));
                    }
                    if (cauldronTile.m_58904_() != null) {
                        cauldronTile.m_58904_().m_6263_(null, (double)((float)cauldronTile.getPos().m_123341_() + 0.5f), (double)((float)cauldronTile.getPos().m_123342_() + 0.5f), (double)((float)cauldronTile.getPos().m_123343_() + 0.5f), SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 0.8f + 0.4f * random.nextFloat());
                    }
                    tileEntity.m_6596_();
                    return InteractionResult.SUCCESS;
                }
                if (cauldronTile.getFluidStack().isFluidEqual(new FluidStack((Fluid)Fluids.f_76195_, 1))) {
                    ItemStack itemstack4 = new ItemStack((ItemLike)ModItems.LAVA_BOTTLE.get());
                    player.m_36220_(Stats.f_12944_);
                    if (!player.m_7500_()) {
                        player.m_21120_(hand).m_41774_(1);
                        if (player.m_21120_(hand).m_41619_()) {
                            player.m_21008_(hand, itemstack4);
                        } else if (!player.m_150109_().m_36054_(itemstack4)) {
                            player.m_36176_(itemstack4, false);
                        }
                    }
                    cauldronTile.getFluidStack().shrink(333);
                    if (cauldronTile.getFluidStack().getAmount() % 10 == 1) {
                        cauldronTile.getFluidStack().shrink(1);
                    }
                    if (cauldronTile.getFluidStack().getAmount() % 10 == 9) {
                        cauldronTile.getFluidStack().grow(1);
                    }
                    if (!cauldronTile.m_58904_().f_46443_) {
                        HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> cauldronTile.m_58904_().m_46745_(cauldronTile.getPos())), (Object)new EmitParticlesPacket(cauldronTile.getPos(), 3, false));
                    }
                    if (cauldronTile.m_58904_() != null) {
                        cauldronTile.m_58904_().m_6263_(null, (double)((float)cauldronTile.getPos().m_123341_() + 0.5f), (double)((float)cauldronTile.getPos().m_123342_() + 0.5f), (double)((float)cauldronTile.getPos().m_123343_() + 0.5f), SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 0.8f + 0.4f * random.nextFloat());
                    }
                    tileEntity.m_6596_();
                    return InteractionResult.SUCCESS;
                }
                if (cauldronTile.getFluidStack().isFluidEqual(new FluidStack((Fluid)ModFluids.QUICKSILVER_FLUID.get(), 1))) {
                    ItemStack itemstack4 = new ItemStack((ItemLike)ModItems.QUICKSILVER_BOTTLE.get());
                    player.m_36220_(Stats.f_12944_);
                    if (!player.m_7500_()) {
                        player.m_21120_(hand).m_41774_(1);
                        if (player.m_21120_(hand).m_41619_()) {
                            player.m_21008_(hand, itemstack4);
                        } else if (!player.m_150109_().m_36054_(itemstack4)) {
                            player.m_36176_(itemstack4, false);
                        }
                    }
                    cauldronTile.getFluidStack().shrink(333);
                    if (cauldronTile.getFluidStack().getAmount() % 10 == 1) {
                        cauldronTile.getFluidStack().shrink(1);
                    }
                    if (cauldronTile.getFluidStack().getAmount() % 10 == 9) {
                        cauldronTile.getFluidStack().grow(1);
                    }
                    if (!cauldronTile.m_58904_().f_46443_) {
                        HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> cauldronTile.m_58904_().m_46745_(cauldronTile.getPos())), (Object)new EmitParticlesPacket(cauldronTile.getPos(), 3, false));
                    }
                    if (cauldronTile.m_58904_() != null) {
                        cauldronTile.m_58904_().m_6263_(null, (double)((float)cauldronTile.getPos().m_123341_() + 0.5f), (double)((float)cauldronTile.getPos().m_123342_() + 0.5f), (double)((float)cauldronTile.getPos().m_123343_() + 0.5f), SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 0.8f + 0.4f * random.nextFloat());
                    }
                    tileEntity.m_6596_();
                    return InteractionResult.SUCCESS;
                }
                if (cauldronTile.getFluidStack().isFluidEqual(new FluidStack((Fluid)ModFluids.TALLOW_FLUID.get(), 1))) {
                    ItemStack itemstack4 = new ItemStack((ItemLike)ModItems.TALLOW_BOTTLE.get());
                    player.m_36220_(Stats.f_12944_);
                    if (!player.m_7500_()) {
                        player.m_21120_(hand).m_41774_(1);
                        if (player.m_21120_(hand).m_41619_()) {
                            player.m_21008_(hand, itemstack4);
                        } else if (!player.m_150109_().m_36054_(itemstack4)) {
                            player.m_36176_(itemstack4, false);
                        }
                    }
                    cauldronTile.getFluidStack().shrink(333);
                    if (cauldronTile.getFluidStack().getAmount() % 10 == 1) {
                        cauldronTile.getFluidStack().shrink(1);
                    }
                    if (cauldronTile.getFluidStack().getAmount() % 10 == 9) {
                        cauldronTile.getFluidStack().grow(1);
                    }
                    if (!cauldronTile.m_58904_().f_46443_) {
                        HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> cauldronTile.m_58904_().m_46745_(cauldronTile.getPos())), (Object)new EmitParticlesPacket(cauldronTile.getPos(), 3, false));
                    }
                    if (cauldronTile.m_58904_() != null) {
                        cauldronTile.m_58904_().m_6263_(null, (double)((float)cauldronTile.getPos().m_123341_() + 0.5f), (double)((float)cauldronTile.getPos().m_123342_() + 0.5f), (double)((float)cauldronTile.getPos().m_123343_() + 0.5f), SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 0.8f + 0.4f * random.nextFloat());
                    }
                    tileEntity.m_6596_();
                    return InteractionResult.SUCCESS;
                }
                if (cauldronTile.getFluidStack().isFluidEqual(new FluidStack((Fluid)ModFluids.BLOOD_FLUID.get(), 1))) {
                    ItemStack itemstack4 = new ItemStack((ItemLike)ModItems.BLOOD_BOTTLE.get());
                    player.m_36220_(Stats.f_12944_);
                    if (!player.m_7500_()) {
                        player.m_21120_(hand).m_41774_(1);
                        if (player.m_21120_(hand).m_41619_()) {
                            player.m_21008_(hand, itemstack4);
                        } else if (!player.m_150109_().m_36054_(itemstack4)) {
                            player.m_36176_(itemstack4, false);
                        }
                    }
                    cauldronTile.getFluidStack().shrink(333);
                    if (cauldronTile.getFluidStack().getAmount() % 10 == 1) {
                        cauldronTile.getFluidStack().shrink(1);
                    }
                    if (cauldronTile.getFluidStack().getAmount() % 10 == 9) {
                        cauldronTile.getFluidStack().grow(1);
                    }
                    if (!cauldronTile.m_58904_().f_46443_) {
                        HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> cauldronTile.m_58904_().m_46745_(cauldronTile.getPos())), (Object)new EmitParticlesPacket(cauldronTile.getPos(), 3, false));
                    }
                    if (cauldronTile.m_58904_() != null) {
                        cauldronTile.m_58904_().m_6263_(null, (double)((float)cauldronTile.getPos().m_123341_() + 0.5f), (double)((float)cauldronTile.getPos().m_123342_() + 0.5f), (double)((float)cauldronTile.getPos().m_123343_() + 0.5f), SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 0.8f + 0.4f * random.nextFloat());
                    }
                    tileEntity.m_6596_();
                    return InteractionResult.SUCCESS;
                }
                if (cauldronTile.getFluidStack().getFluid() instanceof PotionFluid) {
                    ItemStack itemstack4 = PotionFluidHandler.fillBottle(cauldronTile.getFluidStack());
                    player.m_36220_(Stats.f_12944_);
                    if (!player.m_7500_()) {
                        player.m_21120_(hand).m_41774_(1);
                        if (player.m_21120_(hand).m_41619_()) {
                            player.m_21008_(hand, itemstack4);
                        } else if (!player.m_150109_().m_36054_(itemstack4)) {
                            player.m_36176_(itemstack4, false);
                        }
                    }
                    cauldronTile.getFluidStack().shrink(333);
                    if (cauldronTile.getFluidStack().getAmount() % 10 == 1) {
                        cauldronTile.getFluidStack().shrink(1);
                    }
                    if (cauldronTile.getFluidStack().getAmount() % 10 == 9) {
                        cauldronTile.getFluidStack().grow(1);
                    }
                    if (!cauldronTile.m_58904_().f_46443_) {
                        HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> cauldronTile.m_58904_().m_46745_(cauldronTile.getPos())), (Object)new EmitParticlesPacket(cauldronTile.getPos(), 3, false));
                    }
                    if (cauldronTile.m_58904_() != null) {
                        cauldronTile.m_58904_().m_6263_(null, (double)((float)cauldronTile.getPos().m_123341_() + 0.5f), (double)((float)cauldronTile.getPos().m_123342_() + 0.5f), (double)((float)cauldronTile.getPos().m_123343_() + 0.5f), SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 0.8f + 0.4f * random.nextFloat());
                    }
                    tileEntity.m_6596_();
                    return InteractionResult.SUCCESS;
                }
            }
        } else if (stack.m_41720_() == Items.f_42589_ || stack.m_41720_() == Items.f_42739_ || stack.m_41720_() == Items.f_42736_) {
            if (PotionUtils.m_43579_((ItemStack)stack) == Potions.f_43599_) {
                if (cauldronTile.getFluidStack().isFluidEqual(new FluidStack((Fluid)Fluids.f_76193_, 1)) || cauldronTile.getFluidStack().isEmpty()) {
                    ItemStack itemstack4 = new ItemStack((ItemLike)Items.f_42590_);
                    player.m_36220_(Stats.f_12944_);
                    if (!player.m_7500_()) {
                        player.m_21120_(hand).m_41774_(1);
                        if (player.m_21120_(hand).m_41619_()) {
                            player.m_21008_(hand, itemstack4);
                        } else if (!player.m_150109_().m_36054_(itemstack4)) {
                            player.m_36176_(itemstack4, false);
                        }
                    }
                    if (cauldronTile.getFluidStack().isEmpty()) {
                        cauldronTile.fill(new FluidStack((Fluid)Fluids.f_76193_, 333), IFluidHandler.FluidAction.EXECUTE);
                    } else {
                        cauldronTile.getFluidStack().grow(333);
                    }
                    if (cauldronTile.getFluidStack().getAmount() > cauldronTile.getTankCapacity(1)) {
                        cauldronTile.getFluidStack().setAmount(cauldronTile.getTankCapacity(1));
                    }
                    if (cauldronTile.getFluidStack().getAmount() % 10 == 1) {
                        cauldronTile.getFluidStack().shrink(1);
                    }
                    if (cauldronTile.getFluidStack().getAmount() % 10 == 9) {
                        cauldronTile.getFluidStack().grow(1);
                    }
                    if (!tileEntity.m_58904_().f_46443_) {
                        HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> tileEntity.m_58904_().m_46745_(cauldronTile.getPos())), (Object)new EmitParticlesPacket(cauldronTile.getPos(), 3, false));
                    }
                    if (tileEntity.m_58904_() != null) {
                        tileEntity.m_58904_().m_6263_(null, (double)((float)cauldronTile.getPos().m_123341_() + 0.5f), (double)((float)cauldronTile.getPos().m_123342_() + 0.5f), (double)((float)cauldronTile.getPos().m_123343_() + 0.5f), SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 0.8f + 0.4f * random.nextFloat());
                    }
                    tileEntity.m_6596_();
                    return InteractionResult.SUCCESS;
                }
            } else if (cauldronTile.getFluidStack().isFluidEqual(PotionFluidHandler.getFluidFromPotionItem(stack)) || cauldronTile.getFluidStack().isEmpty()) {
                ItemStack itemstack4 = new ItemStack((ItemLike)Items.f_42590_);
                player.m_36220_(Stats.f_12944_);
                if (!player.m_7500_()) {
                    player.m_21120_(hand).m_41774_(1);
                    if (player.m_21120_(hand).m_41619_()) {
                        player.m_21008_(hand, itemstack4);
                    } else if (!player.m_150109_().m_36054_(itemstack4)) {
                        player.m_36176_(itemstack4, false);
                    }
                }
                if (cauldronTile.getFluidStack().isEmpty()) {
                    cauldronTile.fill(new FluidStack(PotionFluidHandler.getFluidFromPotionItem(stack), 333), IFluidHandler.FluidAction.EXECUTE);
                } else {
                    cauldronTile.getFluidStack().grow(333);
                }
                if (cauldronTile.getFluidStack().getAmount() > cauldronTile.getTankCapacity(1)) {
                    cauldronTile.getFluidStack().setAmount(cauldronTile.getTankCapacity(1));
                }
                if (cauldronTile.getFluidStack().getAmount() % 10 == 1) {
                    cauldronTile.getFluidStack().shrink(1);
                }
                if (cauldronTile.getFluidStack().getAmount() % 10 == 9) {
                    cauldronTile.getFluidStack().grow(1);
                }
                if (!tileEntity.m_58904_().f_46443_) {
                    HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> tileEntity.m_58904_().m_46745_(cauldronTile.getPos())), (Object)new EmitParticlesPacket(cauldronTile.getPos(), 3, false));
                }
                if (tileEntity.m_58904_() != null) {
                    tileEntity.m_58904_().m_6263_(null, (double)((float)cauldronTile.getPos().m_123341_() + 0.5f), (double)((float)cauldronTile.getPos().m_123342_() + 0.5f), (double)((float)cauldronTile.getPos().m_123343_() + 0.5f), SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 0.8f + 0.4f * random.nextFloat());
                }
                tileEntity.m_6596_();
                return InteractionResult.SUCCESS;
            }
        } else if (stack.m_41720_() == ModItems.LAVA_BOTTLE.get()) {
            if (cauldronTile.getFluidStack().isFluidEqual(new FluidStack((Fluid)Fluids.f_76195_, 1)) || cauldronTile.getFluidStack().isEmpty()) {
                ItemStack itemstack4 = new ItemStack((ItemLike)Items.f_42590_);
                player.m_36220_(Stats.f_12944_);
                if (!player.m_7500_()) {
                    player.m_21120_(hand).m_41774_(1);
                    if (player.m_21120_(hand).m_41619_()) {
                        player.m_21008_(hand, itemstack4);
                    } else if (!player.m_150109_().m_36054_(itemstack4)) {
                        player.m_36176_(itemstack4, false);
                    }
                }
                if (cauldronTile.getFluidStack().isEmpty()) {
                    cauldronTile.fill(new FluidStack((Fluid)Fluids.f_76195_, 333), IFluidHandler.FluidAction.EXECUTE);
                } else {
                    cauldronTile.getFluidStack().grow(333);
                }
                if (cauldronTile.getFluidStack().getAmount() > cauldronTile.getTankCapacity(1)) {
                    cauldronTile.getFluidStack().setAmount(cauldronTile.getTankCapacity(1));
                }
                if (cauldronTile.getFluidStack().getAmount() % 10 == 1) {
                    cauldronTile.getFluidStack().shrink(1);
                }
                if (cauldronTile.getFluidStack().getAmount() % 10 == 9) {
                    cauldronTile.getFluidStack().grow(1);
                }
                if (!tileEntity.m_58904_().f_46443_) {
                    HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> tileEntity.m_58904_().m_46745_(cauldronTile.getPos())), (Object)new EmitParticlesPacket(cauldronTile.getPos(), 3, false));
                }
                if (tileEntity.m_58904_() != null) {
                    tileEntity.m_58904_().m_6263_(null, (double)((float)cauldronTile.getPos().m_123341_() + 0.5f), (double)((float)cauldronTile.getPos().m_123342_() + 0.5f), (double)((float)cauldronTile.getPos().m_123343_() + 0.5f), SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 0.8f + 0.4f * random.nextFloat());
                }
                tileEntity.m_6596_();
                return InteractionResult.SUCCESS;
            }
        } else if (stack.m_41720_() == ModItems.QUICKSILVER_BOTTLE.get()) {
            if (cauldronTile.getFluidStack().isFluidEqual(new FluidStack((Fluid)ModFluids.QUICKSILVER_FLUID.get(), 1)) || cauldronTile.getFluidStack().isEmpty()) {
                ItemStack itemstack4 = new ItemStack((ItemLike)Items.f_42590_);
                player.m_36220_(Stats.f_12944_);
                if (!player.m_7500_()) {
                    player.m_21120_(hand).m_41774_(1);
                    if (player.m_21120_(hand).m_41619_()) {
                        player.m_21008_(hand, itemstack4);
                    } else if (!player.m_150109_().m_36054_(itemstack4)) {
                        player.m_36176_(itemstack4, false);
                    }
                }
                if (cauldronTile.getFluidStack().isEmpty()) {
                    cauldronTile.fill(new FluidStack((Fluid)ModFluids.QUICKSILVER_FLUID.get(), 333), IFluidHandler.FluidAction.EXECUTE);
                } else {
                    cauldronTile.getFluidStack().grow(333);
                }
                if (cauldronTile.getFluidStack().getAmount() > cauldronTile.getTankCapacity(1)) {
                    cauldronTile.getFluidStack().setAmount(cauldronTile.getTankCapacity(1));
                }
                if (cauldronTile.getFluidStack().getAmount() % 10 == 1) {
                    cauldronTile.getFluidStack().shrink(1);
                }
                if (cauldronTile.getFluidStack().getAmount() % 10 == 9) {
                    cauldronTile.getFluidStack().grow(1);
                }
                if (!tileEntity.m_58904_().f_46443_) {
                    HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> tileEntity.m_58904_().m_46745_(cauldronTile.getPos())), (Object)new EmitParticlesPacket(cauldronTile.getPos(), 3, false));
                }
                if (tileEntity.m_58904_() != null) {
                    tileEntity.m_58904_().m_6263_(null, (double)((float)cauldronTile.getPos().m_123341_() + 0.5f), (double)((float)cauldronTile.getPos().m_123342_() + 0.5f), (double)((float)cauldronTile.getPos().m_123343_() + 0.5f), SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 0.8f + 0.4f * random.nextFloat());
                }
                tileEntity.m_6596_();
                return InteractionResult.SUCCESS;
            }
        } else if (stack.m_41720_() == ModItems.TALLOW_BOTTLE.get()) {
            if (cauldronTile.getFluidStack().isFluidEqual(new FluidStack((Fluid)ModFluids.TALLOW_FLUID.get(), 1)) || cauldronTile.getFluidStack().isEmpty()) {
                ItemStack itemstack4 = new ItemStack((ItemLike)Items.f_42590_);
                player.m_36220_(Stats.f_12944_);
                if (!player.m_7500_()) {
                    player.m_21120_(hand).m_41774_(1);
                    if (player.m_21120_(hand).m_41619_()) {
                        player.m_21008_(hand, itemstack4);
                    } else if (!player.m_150109_().m_36054_(itemstack4)) {
                        player.m_36176_(itemstack4, false);
                    }
                }
                if (cauldronTile.getFluidStack().isEmpty()) {
                    cauldronTile.fill(new FluidStack((Fluid)ModFluids.TALLOW_FLUID.get(), 333), IFluidHandler.FluidAction.EXECUTE);
                } else {
                    cauldronTile.getFluidStack().grow(333);
                }
                if (cauldronTile.getFluidStack().getAmount() > cauldronTile.getTankCapacity(1)) {
                    cauldronTile.getFluidStack().setAmount(cauldronTile.getTankCapacity(1));
                }
                if (cauldronTile.getFluidStack().getAmount() % 10 == 1) {
                    cauldronTile.getFluidStack().shrink(1);
                }
                if (cauldronTile.getFluidStack().getAmount() % 10 == 9) {
                    cauldronTile.getFluidStack().grow(1);
                }
                if (!tileEntity.m_58904_().f_46443_) {
                    HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> tileEntity.m_58904_().m_46745_(cauldronTile.getPos())), (Object)new EmitParticlesPacket(cauldronTile.getPos(), 3, false));
                }
                if (tileEntity.m_58904_() != null) {
                    tileEntity.m_58904_().m_6263_(null, (double)((float)cauldronTile.getPos().m_123341_() + 0.5f), (double)((float)cauldronTile.getPos().m_123342_() + 0.5f), (double)((float)cauldronTile.getPos().m_123343_() + 0.5f), SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 0.8f + 0.4f * random.nextFloat());
                }
                tileEntity.m_6596_();
                return InteractionResult.SUCCESS;
            }
        } else if (stack.m_41720_() == ModItems.BLOOD_BOTTLE.get() && (cauldronTile.getFluidStack().isFluidEqual(new FluidStack((Fluid)ModFluids.BLOOD_FLUID.get(), 1)) || cauldronTile.getFluidStack().isEmpty())) {
            ItemStack itemstack4 = new ItemStack((ItemLike)Items.f_42590_);
            player.m_36220_(Stats.f_12944_);
            if (!player.m_7500_()) {
                player.m_21120_(hand).m_41774_(1);
                if (player.m_21120_(hand).m_41619_()) {
                    player.m_21008_(hand, itemstack4);
                } else if (!player.m_150109_().m_36054_(itemstack4)) {
                    player.m_36176_(itemstack4, false);
                }
            }
            if (cauldronTile.getFluidStack().isEmpty()) {
                cauldronTile.fill(new FluidStack((Fluid)ModFluids.BLOOD_FLUID.get(), 333), IFluidHandler.FluidAction.EXECUTE);
            } else {
                cauldronTile.getFluidStack().grow(333);
            }
            if (cauldronTile.getFluidStack().getAmount() > cauldronTile.getTankCapacity(1)) {
                cauldronTile.getFluidStack().setAmount(cauldronTile.getTankCapacity(1));
            }
            if (cauldronTile.getFluidStack().getAmount() % 10 == 1) {
                cauldronTile.getFluidStack().shrink(1);
            }
            if (cauldronTile.getFluidStack().getAmount() % 10 == 9) {
                cauldronTile.getFluidStack().grow(1);
            }
            if (!tileEntity.m_58904_().f_46443_) {
                HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> tileEntity.m_58904_().m_46745_(cauldronTile.getPos())), (Object)new EmitParticlesPacket(cauldronTile.getPos(), 3, false));
            }
            if (tileEntity.m_58904_() != null) {
                tileEntity.m_58904_().m_6263_(null, (double)((float)cauldronTile.getPos().m_123341_() + 0.5f), (double)((float)cauldronTile.getPos().m_123342_() + 0.5f), (double)((float)cauldronTile.getPos().m_123343_() + 0.5f), SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 0.8f + 0.4f * random.nextFloat());
            }
            tileEntity.m_6596_();
            return InteractionResult.SUCCESS;
        }
        if (!world.m_5776_()) {
            MenuProvider containerProvider = this.createContainerProvider(world, pos);
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)containerProvider, (BlockPos)tileEntity.m_58899_());
        }
        return InteractionResult.SUCCESS;
    }

    public MixingCauldron(BlockBehaviour.Properties properties) {
        super(properties.m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)GUI_RENDER, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DYED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{CRAFT_DELAY, GUI_RENDER, DYED});
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity tileentity = level.m_7702_(pos);
            if (tileentity instanceof MixingCauldronTile) {
                MixingCauldronTile te = (MixingCauldronTile)tileentity;
                te.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(h -> {
                    level.m_7967_((Entity)new ItemEntity(level, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), h.getStackInSlot(0)));
                    level.m_7967_((Entity)new ItemEntity(level, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), h.getStackInSlot(1)));
                    level.m_7967_((Entity)new ItemEntity(level, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), h.getStackInSlot(2)));
                    level.m_7967_((Entity)new ItemEntity(level, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), h.getStackInSlot(3)));
                    level.m_7967_((Entity)new ItemEntity(level, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), h.getStackInSlot(4)));
                    level.m_7967_((Entity)new ItemEntity(level, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), h.getStackInSlot(5)));
                    level.m_7967_((Entity)new ItemEntity(level, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), h.getStackInSlot(6)));
                    level.m_7967_((Entity)new ItemEntity(level, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), h.getStackInSlot(7)));
                    level.m_7967_((Entity)new ItemEntity(level, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), h.getStackInSlot(8)));
                    level.m_7967_((Entity)new ItemEntity(level, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), h.getStackInSlot(9)));
                });
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        this.withTileEntityDo((BlockGetter)worldIn, pos, te -> te.setDyeColor(MixingCauldron.getColorStatic(stack)));
        super.m_6402_(worldIn, pos, state, placer, stack);
        if (stack.m_41788_() && (blockEntity = worldIn.m_7702_(pos)) instanceof MixingCauldronTile) {
            MixingCauldronTile mixingCauldronTile = (MixingCauldronTile)blockEntity;
            mixingCauldronTile.customName = stack.m_41786_();
        }
    }

    public ItemStack m_7397_(BlockGetter worldIn, BlockPos pos, BlockState state) {
        ItemStack item = new ItemStack((ItemLike)this);
        Optional<MixingCauldronTile> tileEntityOptional = Optional.ofNullable((MixingCauldronTile)this.getBlockEntity(worldIn, pos));
        this.m_41115_(item, tileEntityOptional.map(cauldron -> cauldron.dyeColor).orElse(4337438));
        Component customName = tileEntityOptional.map(MixingCauldronTile::m_7770_).orElse(null);
        if (customName != null && customName.getString().length() > 0) {
            item.m_41714_(customName);
        }
        return item;
    }

    public static int getColorStatic(ItemStack p_41122_) {
        CompoundTag compoundtag = p_41122_.m_41737_("display");
        return compoundtag != null && compoundtag.m_128425_("color", 99) ? compoundtag.m_128451_("color") : 16760348;
    }

    public static DyeColor getDyeColorNamed(ItemStack stack) {
        return HexereiUtil.getDyeColorNamed(stack.m_41786_().getString(), 0);
    }

    public static int getColorValue(BlockState state, BlockPos pos, BlockGetter level) {
        ItemStack clone = ((MixingCauldron)state.m_60734_()).m_7397_(level, pos, state);
        int dyeCol = MixingCauldron.getColorStatic(clone);
        DyeColor color = MixingCauldron.getDyeColorNamed(clone);
        if (color == null && dyeCol != -1) {
            return dyeCol;
        }
        float[] colors = color.m_41068_();
        int r = (int)(colors[0] * 255.0f);
        int g = (int)(colors[1] * 255.0f);
        int b = (int)(colors[2] * 255.0f);
        return r << 16 | g << 8 | b;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        float height = 0.25f;
        BlockEntity tileEntity = world.m_7702_(pos);
        if (tileEntity instanceof MixingCauldronTile) {
            MixingCauldronTile cauldronTile = (MixingCauldronTile)tileEntity;
            height = 0.25f + 0.6875f * Math.min(1.0f, (float)cauldronTile.getFluidStack().getAmount() / (float)cauldronTile.getTankCapacity(0)) + 0.0625f;
            int num = cauldronTile.getNumberOfItems();
            if (cauldronTile.getFluidStack().getAmount() > 0) {
                int i;
                for (i = 0; i < Mth.m_14143_((float)((float)cauldronTile.getFluidStack().getAmount() / 666.0f + 0.5f)); ++i) {
                    if (!(rand.m_188500_() > 0.5)) continue;
                    world.m_7106_((ParticleOptions)ModParticleTypes.CAULDRON.get(), (double)pos.m_123341_() + 0.2 + 0.6 * rand.m_188500_(), (double)((float)pos.m_123342_() + height), (double)pos.m_123343_() + 0.2 + 0.6 * rand.m_188500_(), (rand.m_188500_() - 0.5) / 50.0, (rand.m_188500_() + 0.5) * 0.004, (rand.m_188500_() - 0.5) / 50.0);
                }
                for (i = 0; i < num; ++i) {
                    if (!(rand.m_188500_() > 0.5)) continue;
                    world.m_7106_((ParticleOptions)ModParticleTypes.CAULDRON.get(), (double)pos.m_123341_() + 0.2 + 0.6 * rand.m_188500_(), (double)((float)pos.m_123342_() + height), (double)pos.m_123343_() + 0.2 + 0.6 * rand.m_188500_(), (rand.m_188500_() - 0.5) / 50.0, (rand.m_188500_() + 0.5) * 0.004, (rand.m_188500_() - 0.5) / 50.0);
                }
                BlockState heatSource = world.m_8055_(pos.m_7495_());
                if (heatSource.m_204336_(HexereiTags.Blocks.HEAT_SOURCES)) {
                    for (int i2 = 0; i2 < num + 5; ++i2) {
                        if (!(rand.m_188500_() > 0.5)) continue;
                        world.m_7106_((ParticleOptions)ModParticleTypes.CAULDRON.get(), (double)pos.m_123341_() + 0.2 + 0.6 * rand.m_188500_(), (double)((float)pos.m_123342_() + height), (double)pos.m_123343_() + 0.2 + 0.6 * rand.m_188500_(), (rand.m_188500_() - 0.5) / 50.0, (rand.m_188500_() + 0.5) * 0.014, (rand.m_188500_() - 0.5) / 50.0);
                    }
                }
                if (cauldronTile.getFluidStack().isFluidEqual(new FluidStack((Fluid)Fluids.f_76193_, 1)) || cauldronTile.getFluidStack().isFluidEqual(new FluidStack((Fluid)ModFluids.TALLOW_FLUID.get(), 1))) {
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123795_, (double)pos.m_123341_() + 0.2 + 0.6 * rand.m_188500_(), (double)((float)pos.m_123342_() + height), (double)pos.m_123343_() + 0.2 + 0.6 * rand.m_188500_(), (rand.m_188500_() - 0.5) / 50.0, (rand.m_188500_() + 0.5) * 0.005, (rand.m_188500_() - 0.5) / 50.0);
                } else if (cauldronTile.getFluidStack().isFluidEqual(new FluidStack((Fluid)ModFluids.BLOOD_FLUID.get(), 1)) && rand.m_188503_(20) == 0) {
                    world.m_7106_((ParticleOptions)ModParticleTypes.BLOOD.get(), (double)pos.m_123341_() + 0.2 + 0.6 * rand.m_188500_(), (double)((float)pos.m_123342_() + height), (double)pos.m_123343_() + 0.2 + 0.6 * rand.m_188500_(), (rand.m_188500_() - 0.5) / 75.0, (rand.m_188500_() + 0.5) * 5.0E-4, (rand.m_188500_() - 0.5) / 75.0);
                }
            }
            if ((double)((Integer)state.m_61143_((Property)CRAFT_DELAY)).intValue() >= 80.0 && cauldronTile.m_58904_() != null && !cauldronTile.m_58904_().f_46443_) {
                HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> tileEntity.m_58904_().m_46745_(cauldronTile.getPos())), (Object)new EmitParticlesPacket(cauldronTile.getPos(), 3, false));
            }
        }
        super.m_214162_(state, world, pos, rand);
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        Fluid fluid;
        BlockPos blockpos = PointedDripstoneBlock.m_154055_((Level)pLevel, (BlockPos)pPos);
        if (blockpos != null && (fluid = PointedDripstoneBlock.m_221849_((ServerLevel)pLevel, (BlockPos)blockpos)) != Fluids.f_76191_ && this.canReceiveStalactiteDrip(fluid)) {
            this.receiveStalactiteDrip(pState, (Level)pLevel, pPos, fluid);
        }
    }

    private MenuProvider createContainerProvider(final Level worldIn, final BlockPos pos) {
        return new MenuProvider(){

            @org.jetbrains.annotations.Nullable
            public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
                return new MixingCauldronContainer(i, worldIn, pos, playerInventory, playerEntity);
            }

            public Component m_5446_() {
                BlockEntity blockEntity = worldIn.m_7702_(pos);
                if (blockEntity instanceof MixingCauldronTile) {
                    MixingCauldronTile mixingCauldronTile = (MixingCauldronTile)blockEntity;
                    if (mixingCauldronTile.customName != null) {
                        return Component.m_237115_((String)mixingCauldronTile.customName.getString());
                    }
                }
                return Component.m_237115_((String)"screen.hexerei.mixing_cauldron");
            }
        };
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        BlockEntity tileentity = worldIn.m_7702_(pos);
        if (tileentity instanceof MixingCauldronTile) {
            ((MixingCauldronTile)tileentity).entityInside(entityIn);
        }
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag flagIn) {
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237110_((String)"<%s>", (Object[])new Object[]{Component.m_237115_((String)"tooltip.hexerei.shift").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xAA6600)))}).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.hexerei.mixing_cauldron_shift").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
        } else {
            tooltip.add((Component)Component.m_237110_((String)"[%s]", (Object[])new Object[]{Component.m_237115_((String)"tooltip.hexerei.shift").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xAAAA00)))}).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
        }
        super.m_5871_(stack, world, tooltip, flagIn);
    }

    @Override
    public Class<MixingCauldronTile> getTileEntityClass() {
        return MixingCauldronTile.class;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new MixingCauldronTile((BlockEntityType)ModTileEntities.MIXING_CAULDRON_TILE.get(), pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> entityType) {
        return entityType == ModTileEntities.MIXING_CAULDRON_TILE.get() ? (world2, pos, state2, entity) -> ((MixingCauldronTile)entity).tick() : null;
    }
}

