/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.network.packets;

import com.direwolf20.laserio.common.blockentities.LaserNodeBE;
import com.direwolf20.laserio.common.blockentities.basebe.BaseLaserBE;
import com.direwolf20.laserio.common.blocks.LaserNode;
import com.direwolf20.laserio.common.containers.CardEnergyContainer;
import com.direwolf20.laserio.common.containers.CardItemContainer;
import com.direwolf20.laserio.common.containers.CardRedstoneContainer;
import com.direwolf20.laserio.common.containers.LaserNodeContainer;
import com.direwolf20.laserio.common.containers.customhandler.LaserNodeItemHandler;
import com.direwolf20.laserio.common.network.PacketHandler;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;

public class PacketOpenNode {
    private BlockPos sourcePos;
    private byte side;

    public PacketOpenNode(BlockPos pos, byte side) {
        this.sourcePos = pos;
        this.side = side;
    }

    public static void encode(PacketOpenNode msg, FriendlyByteBuf buffer) {
        buffer.m_130064_(msg.sourcePos);
        buffer.writeByte((int)msg.side);
    }

    public static PacketOpenNode decode(FriendlyByteBuf buffer) {
        return new PacketOpenNode(buffer.m_130135_(), buffer.readByte());
    }

    public static class Handler {
        public static void handle(final PacketOpenNode msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                BlockPos pos;
                ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
                if (sender == null) {
                    return;
                }
                AbstractContainerMenu container = sender.f_36096_;
                if (container == null) {
                    return;
                }
                if (container instanceof LaserNodeContainer) {
                    pos = msg.sourcePos;
                } else if (container instanceof CardItemContainer) {
                    CardItemContainer cardItemContainer = (CardItemContainer)container;
                    pos = cardItemContainer.sourceContainer;
                } else if (container instanceof CardEnergyContainer) {
                    CardEnergyContainer cardEnergyContainer = (CardEnergyContainer)container;
                    pos = cardEnergyContainer.sourceContainer;
                } else if (container instanceof CardRedstoneContainer) {
                    CardRedstoneContainer cardRedstoneContainer = (CardRedstoneContainer)container;
                    pos = cardRedstoneContainer.sourceContainer;
                } else {
                    return;
                }
                BlockPos sourcePos = pos;
                final BlockEntity be = sender.f_19853_.m_7702_(sourcePos);
                if (be == null || !(be instanceof BaseLaserBE)) {
                    return;
                }
                ItemStack heldStack = sender.f_36096_.m_142621_();
                if (!heldStack.m_41619_()) {
                    sender.f_36096_.m_142503_(ItemStack.f_41583_);
                }
                be.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.values()[msg.side]).ifPresent(h -> {
                    ItemStack cardHolder = LaserNode.findCardHolders((Player)sender);
                    MenuProvider containerProvider = new MenuProvider(){
                        final /* synthetic */ IItemHandler val$h;
                        final /* synthetic */ ItemStack val$cardHolder;
                        {
                            this.val$h = iItemHandler;
                            this.val$cardHolder = itemStack;
                        }

                        public Component m_5446_() {
                            return Component.m_237115_((String)"screen.laserio.lasernode");
                        }

                        public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player playerEntity) {
                            return new LaserNodeContainer((LaserNodeBE)be, windowId, msg.side, playerInventory, playerEntity, (LaserNodeItemHandler)this.val$h, ContainerLevelAccess.m_39289_((Level)be.m_58904_(), (BlockPos)be.m_58899_()), this.val$cardHolder);
                        }
                    };
                    NetworkHooks.openScreen((ServerPlayer)sender, (MenuProvider)containerProvider, buf -> {
                        buf.m_130064_(sourcePos);
                        buf.writeByte((int)msg.side);
                        buf.writeItemStack(cardHolder, false);
                    });
                    if (!heldStack.m_41619_()) {
                        sender.f_36096_.m_142503_(heldStack);
                        PacketHandler.sendVanillaPacket((Entity)sender, new ClientboundContainerSetSlotPacket(-1, -1, -1, heldStack));
                    }
                });
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

