/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.client.screens;

import com.direwolf20.laserio.client.screens.widgets.ChannelButton;
import com.direwolf20.laserio.client.screens.widgets.NumberButton;
import com.direwolf20.laserio.client.screens.widgets.ToggleButton;
import com.direwolf20.laserio.common.containers.CardEnergyContainer;
import com.direwolf20.laserio.common.containers.customslot.CardItemSlot;
import com.direwolf20.laserio.common.containers.customslot.CardOverclockSlot;
import com.direwolf20.laserio.common.items.cards.BaseCard;
import com.direwolf20.laserio.common.items.cards.CardEnergy;
import com.direwolf20.laserio.common.items.cards.CardRedstone;
import com.direwolf20.laserio.common.network.PacketHandler;
import com.direwolf20.laserio.common.network.packets.PacketOpenNode;
import com.direwolf20.laserio.common.network.packets.PacketUpdateCard;
import com.direwolf20.laserio.util.MiscTools;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class CardEnergyScreen
extends AbstractContainerScreen<CardEnergyContainer> {
    private final ResourceLocation GUI = new ResourceLocation("laserio", "textures/gui/energycard.png");
    protected final CardEnergyContainer container;
    protected byte currentMode;
    protected byte currentChannel;
    protected byte currentRedstoneChannel;
    protected int currentEnergyExtractAmt;
    protected short currentPriority;
    protected byte currentSneaky;
    protected int currentTicks;
    protected boolean currentExact;
    protected int currentRoundRobin;
    protected boolean currentRegulate;
    protected int currentExtractLimitPercent;
    protected int currentInsertLimitPercent;
    protected final ItemStack card;
    protected Map<String, Button> buttons = new HashMap<String, Button>();
    protected byte currentRedstoneMode;
    protected final String[] sneakyNames = new String[]{"screen.laserio.default", "screen.laserio.down", "screen.laserio.up", "screen.laserio.north", "screen.laserio.south", "screen.laserio.west", "screen.laserio.east"};

    public CardEnergyScreen(CardEnergyContainer container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.container = container;
        this.card = container.cardItem;
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        Button limitButton;
        Button speedButton;
        Button exact;
        Button redstoneMode;
        Button roundrobin;
        Button regulate;
        Button amountButton;
        Button sneakyButton;
        Button redstoneChannelButton;
        Button channelButton;
        this.m_7333_(matrixStack);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.m_7025_(matrixStack, mouseX, mouseY);
        Button modeButton = this.buttons.get("mode");
        if (MiscTools.inBounds(modeButton.f_93620_, modeButton.f_93621_, modeButton.m_5711_(), modeButton.m_93694_(), mouseX, mouseY)) {
            MutableComponent[] translatableComponents = new MutableComponent[]{Component.m_237115_((String)"screen.laserio.insert"), Component.m_237115_((String)"screen.laserio.extract"), Component.m_237115_((String)"screen.laserio.stock"), Component.m_237115_((String)"screen.laserio.sensor")};
            this.m_96602_(matrixStack, (Component)translatableComponents[this.currentMode], mouseX, mouseY);
        }
        if (MiscTools.inBounds(channelButton.f_93620_, channelButton.f_93621_, (channelButton = this.buttons.get("channel")).m_5711_(), channelButton.m_93694_(), mouseX, mouseY)) {
            this.m_96602_(matrixStack, (Component)Component.m_237115_((String)"screen.laserio.channel").m_130946_(String.valueOf(this.currentChannel)), mouseX, mouseY);
        }
        if (MiscTools.inBounds(redstoneChannelButton.f_93620_, redstoneChannelButton.f_93621_, (redstoneChannelButton = this.buttons.get("redstoneChannel")).m_5711_(), redstoneChannelButton.m_93694_(), mouseX, mouseY)) {
            this.m_96602_(matrixStack, (Component)Component.m_237115_((String)"screen.laserio.redstonechannel").m_130946_(String.valueOf(this.currentRedstoneChannel)), mouseX, mouseY);
        }
        if (MiscTools.inBounds(sneakyButton.f_93620_, sneakyButton.f_93621_, (sneakyButton = this.buttons.get("sneaky")).m_5711_(), sneakyButton.m_93694_(), mouseX, mouseY)) {
            this.m_96602_(matrixStack, (Component)Component.m_237115_((String)String.valueOf(this.sneakyNames[this.currentSneaky + 1])), mouseX, mouseY);
        }
        if (MiscTools.inBounds(amountButton.f_93620_, amountButton.f_93621_, (amountButton = this.buttons.get("amount")).m_5711_(), amountButton.m_93694_(), mouseX, mouseY)) {
            if (this.showExtractAmt()) {
                this.m_96602_(matrixStack, (Component)Component.m_237115_((String)"screen.laserio.extractamt"), mouseX, mouseY);
            }
            if (this.showPriority()) {
                this.m_96602_(matrixStack, (Component)Component.m_237115_((String)"screen.laserio.priority"), mouseX, mouseY);
            }
        }
        if (MiscTools.inBounds(regulate.f_93620_, regulate.f_93621_, (regulate = this.buttons.get("regulate")).m_5711_(), regulate.m_93694_(), mouseX, mouseY) && this.showRegulate()) {
            this.m_96602_(matrixStack, (Component)Component.m_237115_((String)"screen.laserio.regulate"), mouseX, mouseY);
        }
        if (MiscTools.inBounds(roundrobin.f_93620_, roundrobin.f_93621_, (roundrobin = this.buttons.get("roundrobin")).m_5711_(), roundrobin.m_93694_(), mouseX, mouseY) && this.showRoundRobin()) {
            MutableComponent[] translatableComponents = new MutableComponent[]{Component.m_237115_((String)"screen.laserio.false"), Component.m_237115_((String)"screen.laserio.true"), Component.m_237115_((String)"screen.laserio.enforced")};
            this.m_96602_(matrixStack, (Component)Component.m_237115_((String)"screen.laserio.roundrobin").m_7220_((Component)translatableComponents[this.currentRoundRobin]), mouseX, mouseY);
        }
        if (MiscTools.inBounds(redstoneMode.f_93620_, redstoneMode.f_93621_, (redstoneMode = this.buttons.get("redstoneMode")).m_5711_(), redstoneMode.m_93694_(), mouseX, mouseY)) {
            MutableComponent[] translatableComponents = new MutableComponent[]{Component.m_237115_((String)"screen.laserio.ignored"), Component.m_237115_((String)"screen.laserio.low"), Component.m_237115_((String)"screen.laserio.high")};
            this.m_96602_(matrixStack, (Component)Component.m_237115_((String)"screen.laserio.redstoneMode").m_7220_((Component)translatableComponents[this.currentRedstoneMode]), mouseX, mouseY);
        }
        if (MiscTools.inBounds(exact.f_93620_, exact.f_93621_, (exact = this.buttons.get("exact")).m_5711_(), exact.m_93694_(), mouseX, mouseY) && this.showExactAmt()) {
            this.m_96602_(matrixStack, (Component)Component.m_237115_((String)"screen.laserio.exact"), mouseX, mouseY);
        }
        if (MiscTools.inBounds(speedButton.f_93620_, speedButton.f_93621_, (speedButton = this.buttons.get("speed")).m_5711_(), speedButton.m_93694_(), mouseX, mouseY) && this.showExactAmt()) {
            this.m_96602_(matrixStack, (Component)Component.m_237115_((String)"screen.laserio.tickSpeed"), mouseX, mouseY);
        }
        if (MiscTools.inBounds(limitButton.f_93620_, limitButton.f_93621_, (limitButton = this.buttons.get("limit")).m_5711_(), limitButton.m_93694_(), mouseX, mouseY)) {
            this.m_96602_(matrixStack, (Component)Component.m_237115_((String)"screen.laserio.energylimit"), mouseX, mouseY);
        }
    }

    public void addAmtButton() {
        this.buttons.put("amount", new NumberButton(this.getGuiLeft() + 125, this.getGuiTop() + 25, 46, 12, this.currentMode == 0 ? this.currentPriority : this.currentEnergyExtractAmt, button -> this.changeAmount(-1)));
    }

    public void addLimitButton() {
        this.buttons.put("limit", new NumberButton(this.getGuiLeft() + 147, this.getGuiTop() + 53, 24, 12, this.showExtractLimit() ? this.currentExtractLimitPercent : this.currentInsertLimitPercent, button -> this.changeLimitAmount(-1)));
    }

    public void addModeButton() {
        ResourceLocation[] modeTextures = new ResourceLocation[]{new ResourceLocation("laserio", "textures/gui/buttons/modeinserter.png"), new ResourceLocation("laserio", "textures/gui/buttons/modeextractor.png"), new ResourceLocation("laserio", "textures/gui/buttons/modestocker.png"), new ResourceLocation("laserio", "textures/gui/buttons/modesensor.png")};
        this.buttons.put("mode", new ToggleButton(this.getGuiLeft() + 5, this.getGuiTop() + 5, 16, 16, modeTextures, this.currentMode, button -> {
            this.currentMode = BaseCard.nextTransferMode(this.card);
            ((ToggleButton)button).setTexturePosition(this.currentMode);
            ((NumberButton)this.buttons.get("amount")).setValue(this.currentMode == 0 ? this.currentPriority : this.currentEnergyExtractAmt);
            ((NumberButton)this.buttons.get("limit")).setValue(this.showExtractLimit() ? this.currentExtractLimitPercent : this.currentInsertLimitPercent);
            this.modeChange();
        }));
    }

    public void addRedstoneButton() {
        ResourceLocation[] redstoneTextures = new ResourceLocation[]{new ResourceLocation("laserio", "textures/gui/buttons/redstoneignore.png"), new ResourceLocation("laserio", "textures/gui/buttons/redstonelow.png"), new ResourceLocation("laserio", "textures/gui/buttons/redstonehigh.png")};
        this.buttons.put("redstoneMode", new ToggleButton(this.getGuiLeft() + 105, this.getGuiTop() + 5, 16, 16, redstoneTextures, this.currentRedstoneMode, button -> {
            this.currentRedstoneMode = (byte)(this.currentRedstoneMode == 2 ? 0 : this.currentRedstoneMode + 1);
            ((ToggleButton)button).setTexturePosition(this.currentRedstoneMode);
        }));
    }

    public void addRedstoneChannelButton() {
        this.buttons.put("redstoneChannel", new ChannelButton(this.getGuiLeft() + 125, this.getGuiTop() + 5, 16, 16, this.currentRedstoneChannel, button -> {
            this.currentRedstoneChannel = CardRedstone.nextRedstoneChannel(this.card);
            ((ChannelButton)button).setChannel(this.currentRedstoneChannel);
        }));
    }

    public void m_7856_() {
        super.m_7856_();
        this.currentMode = BaseCard.getTransferMode(this.card);
        this.currentChannel = BaseCard.getChannel(this.card);
        this.currentEnergyExtractAmt = CardEnergy.getEnergyExtractAmt(this.card);
        this.currentPriority = BaseCard.getPriority(this.card);
        this.currentSneaky = BaseCard.getSneaky(this.card);
        this.currentTicks = CardEnergy.getExtractSpeed(this.card);
        this.currentExact = BaseCard.getExact(this.card);
        this.currentRoundRobin = BaseCard.getRoundRobin(this.card);
        this.currentRegulate = BaseCard.getRegulate(this.card);
        this.currentExtractLimitPercent = CardEnergy.getExtractLimitPercent(this.card);
        this.currentInsertLimitPercent = CardEnergy.getInsertLimitPercent(this.card);
        this.currentRedstoneMode = CardEnergy.getRedstoneMode(this.card);
        this.currentRedstoneChannel = BaseCard.getRedstoneChannel(this.card);
        this.addAmtButton();
        this.addLimitButton();
        this.buttons.put("speed", new NumberButton(this.getGuiLeft() + 147, this.getGuiTop() + 39, 24, 12, this.currentTicks, button -> this.changeTick(-1)));
        ResourceLocation[] exactTextures = new ResourceLocation[]{new ResourceLocation("laserio", "textures/gui/buttons/exactfalse.png"), new ResourceLocation("laserio", "textures/gui/buttons/exacttrue.png")};
        this.buttons.put("exact", new ToggleButton(this.getGuiLeft() + 25, this.getGuiTop() + 25, 16, 16, exactTextures, this.currentExact ? 1 : 0, button -> {
            this.currentExact = !this.currentExact;
            ((ToggleButton)button).setTexturePosition(this.currentExact ? 1 : 0);
        }));
        ResourceLocation[] roundRobinTextures = new ResourceLocation[]{new ResourceLocation("laserio", "textures/gui/buttons/roundrobinfalse.png"), new ResourceLocation("laserio", "textures/gui/buttons/roundrobintrue.png"), new ResourceLocation("laserio", "textures/gui/buttons/roundrobinenforced.png")};
        this.buttons.put("roundrobin", new ToggleButton(this.getGuiLeft() + 5, this.getGuiTop() + 25, 16, 16, roundRobinTextures, this.currentRoundRobin, button -> {
            this.currentRoundRobin = this.currentRoundRobin == 2 ? 0 : this.currentRoundRobin + 1;
            ((ToggleButton)button).setTexturePosition(this.currentRoundRobin);
        }));
        ResourceLocation[] regulateTextures = new ResourceLocation[]{new ResourceLocation("laserio", "textures/gui/buttons/regulatefalse.png"), new ResourceLocation("laserio", "textures/gui/buttons/regulatetrue.png")};
        this.buttons.put("regulate", new ToggleButton(this.getGuiLeft() + 5, this.getGuiTop() + 25, 16, 16, regulateTextures, this.currentRegulate ? 1 : 0, button -> {
            this.currentRegulate = !this.currentRegulate;
            ((ToggleButton)button).setTexturePosition(this.currentRegulate ? 1 : 0);
        }));
        this.addModeButton();
        this.addRedstoneButton();
        this.addRedstoneChannelButton();
        this.buttons.put("channel", new ChannelButton(this.getGuiLeft() + 5, this.getGuiTop() + 65, 16, 16, this.currentChannel, button -> {
            this.currentChannel = BaseCard.nextChannel(this.card);
            ((ChannelButton)button).setChannel(this.currentChannel);
        }));
        ResourceLocation[] sneakyTextures = new ResourceLocation[]{new ResourceLocation("laserio", "textures/gui/buttons/sneaky.png"), new ResourceLocation("laserio", "textures/gui/buttons/sneaky-down.png"), new ResourceLocation("laserio", "textures/gui/buttons/sneaky-up.png"), new ResourceLocation("laserio", "textures/gui/buttons/sneaky-north.png"), new ResourceLocation("laserio", "textures/gui/buttons/sneaky-south.png"), new ResourceLocation("laserio", "textures/gui/buttons/sneaky-west.png"), new ResourceLocation("laserio", "textures/gui/buttons/sneaky-east.png")};
        this.buttons.put("sneaky", new ToggleButton(this.getGuiLeft() + 25, this.getGuiTop() + 5, 16, 16, sneakyTextures, this.currentSneaky + 1, button -> {
            this.currentSneaky = BaseCard.nextSneaky(this.card);
            ((ToggleButton)button).setTexturePosition(this.currentSneaky + 1);
        }));
        if (this.container.direction != -1) {
            this.buttons.put("return", new Button(this.getGuiLeft() - 25, this.getGuiTop() + 1, 25, 20, (Component)Component.m_237113_((String)"<--"), button -> this.openNode()));
        }
        for (Map.Entry<String, Button> button2 : this.buttons.entrySet()) {
            this.m_142416_((GuiEventListener)button2.getValue());
        }
        if (this.card.m_41613_() > 1) {
            int i = 0;
            while (true) {
                if (i >= true) break;
                if (i < this.container.f_38839_.size()) {
                    Slot slot = this.container.m_38853_(i);
                    if (slot instanceof CardItemSlot) {
                        CardItemSlot cardItemSlot = (CardItemSlot)slot;
                        cardItemSlot.setEnabled(false);
                    }
                    if (slot instanceof CardOverclockSlot) {
                        CardOverclockSlot cardOverclockSlot = (CardOverclockSlot)slot;
                        cardOverclockSlot.setEnabled(false);
                    }
                }
                ++i;
            }
        }
        this.modeChange();
    }

    public void modeChange() {
        Button speedButton = this.buttons.get("speed");
        Button exactButton = this.buttons.get("exact");
        Button rrButton = this.buttons.get("roundrobin");
        Button regulateButton = this.buttons.get("regulate");
        Button channelButton = this.buttons.get("channel");
        Button amountButton = this.buttons.get("amount");
        if (this.currentMode == 0) {
            if (!this.f_169369_.contains(channelButton)) {
                this.m_142416_((GuiEventListener)channelButton);
            }
            if (!this.f_169369_.contains(amountButton)) {
                this.m_142416_((GuiEventListener)amountButton);
            }
            this.m_169411_((GuiEventListener)speedButton);
            this.m_169411_((GuiEventListener)exactButton);
            this.m_169411_((GuiEventListener)rrButton);
            this.m_169411_((GuiEventListener)regulateButton);
        } else if (this.currentMode == 1) {
            if (!this.f_169369_.contains(channelButton)) {
                this.m_142416_((GuiEventListener)channelButton);
            }
            if (!this.f_169369_.contains(amountButton)) {
                this.m_142416_((GuiEventListener)amountButton);
            }
            if (!this.f_169369_.contains(speedButton)) {
                this.m_142416_((GuiEventListener)speedButton);
            }
            if (!this.f_169369_.contains(exactButton)) {
                this.m_142416_((GuiEventListener)exactButton);
            }
            if (!this.f_169369_.contains(rrButton)) {
                this.m_142416_((GuiEventListener)rrButton);
            }
            this.m_169411_((GuiEventListener)regulateButton);
        } else if (this.currentMode == 2) {
            if (!this.f_169369_.contains(channelButton)) {
                this.m_142416_((GuiEventListener)channelButton);
            }
            if (!this.f_169369_.contains(amountButton)) {
                this.m_142416_((GuiEventListener)amountButton);
            }
            if (!this.f_169369_.contains(speedButton)) {
                this.m_142416_((GuiEventListener)speedButton);
            }
            if (!this.f_169369_.contains(exactButton)) {
                this.m_142416_((GuiEventListener)exactButton);
            }
            if (!this.f_169369_.contains(regulateButton)) {
                this.m_142416_((GuiEventListener)regulateButton);
            }
            this.m_169411_((GuiEventListener)rrButton);
        } else if (this.currentMode == 3) {
            if (!this.f_169369_.contains(speedButton)) {
                this.m_142416_((GuiEventListener)speedButton);
            }
            this.m_169411_((GuiEventListener)rrButton);
            this.m_169411_((GuiEventListener)regulateButton);
            this.m_169411_((GuiEventListener)channelButton);
            this.m_169411_((GuiEventListener)amountButton);
        }
    }

    public void changeAmount(int change) {
        if (Screen.m_96638_()) {
            change *= 10;
        }
        if (Screen.m_96637_()) {
            change *= 100;
        }
        int overClockers = this.container.m_38853_(0).m_7993_().m_41613_();
        int max = 1000;
        switch (overClockers) {
            case 1: {
                max = 4000;
                break;
            }
            case 2: {
                max = 16000;
                break;
            }
            case 3: {
                max = 32000;
                break;
            }
            case 4: {
                max = 100000;
            }
        }
        if (change < 0) {
            if (this.currentMode == 0) {
                this.currentPriority = (short)Math.max(this.currentPriority + change, -4096);
            } else {
                this.currentEnergyExtractAmt = Math.max(this.currentEnergyExtractAmt + change, 100);
            }
        } else if (this.currentMode == 0) {
            this.currentPriority = (short)Math.min(this.currentPriority + change, 4096);
        } else {
            this.currentEnergyExtractAmt = Math.min(this.currentEnergyExtractAmt + change, max);
        }
    }

    public void changeLimitAmount(int change) {
        if (Screen.m_96638_()) {
            change *= 10;
        }
        if (Screen.m_96637_()) {
            change *= 100;
        }
        if (change < 0) {
            if (this.showExtractLimit()) {
                this.currentExtractLimitPercent = Math.max(this.currentExtractLimitPercent + change, 0);
            } else {
                this.currentInsertLimitPercent = Math.max(this.currentInsertLimitPercent + change, 0);
            }
        } else if (this.showExtractLimit()) {
            this.currentExtractLimitPercent = Math.min(this.currentExtractLimitPercent + change, 100);
        } else {
            this.currentInsertLimitPercent = Math.min(this.currentInsertLimitPercent + change, 100);
        }
    }

    public void changeTick(int change) {
        if (Screen.m_96638_()) {
            change *= 10;
        }
        if (Screen.m_96637_()) {
            change *= 64;
        }
        this.currentTicks = change < 0 ? Math.max(this.currentTicks + change, 1) : Math.min(this.currentTicks + change, 1200);
    }

    private boolean showExtractAmt() {
        return this.card.m_41720_() instanceof BaseCard && BaseCard.getNamedTransferMode(this.card) != BaseCard.TransferMode.INSERT;
    }

    private boolean showExactAmt() {
        return this.card.m_41720_() instanceof BaseCard && BaseCard.getNamedTransferMode(this.card) != BaseCard.TransferMode.INSERT;
    }

    private boolean showPriority() {
        return this.card.m_41720_() instanceof BaseCard && BaseCard.getNamedTransferMode(this.card) == BaseCard.TransferMode.INSERT;
    }

    private boolean showRegulate() {
        return this.card.m_41720_() instanceof BaseCard && BaseCard.getNamedTransferMode(this.card) == BaseCard.TransferMode.STOCK;
    }

    private boolean showRoundRobin() {
        return this.card.m_41720_() instanceof BaseCard && BaseCard.getNamedTransferMode(this.card) == BaseCard.TransferMode.EXTRACT;
    }

    private boolean showExtractLimit() {
        return this.card.m_41720_() instanceof BaseCard && BaseCard.getNamedTransferMode(this.card) == BaseCard.TransferMode.EXTRACT;
    }

    protected void m_7027_(PoseStack stack, int mouseX, int mouseY) {
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.GUI);
        int relX = (this.f_96543_ - this.f_97726_) / 2;
        int relY = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(matrixStack, relX, relY, 0, 0, this.f_97726_, this.f_97727_);
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7379_() {
        this.saveSettings();
        super.m_7379_();
    }

    public boolean m_7933_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)p_keyPressed_1_, (int)p_keyPressed_2_);
        if (p_keyPressed_1_ == 256 || this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean m_6348_(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        return super.m_6348_(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        return super.m_6050_(mouseX, mouseY, delta);
    }

    private static MutableComponent getTrans(String key, Object ... args) {
        return Component.m_237110_((String)("laserio." + key), (Object[])args);
    }

    public void setExtract(NumberButton amountButton, int btn) {
        int change;
        int n = change = this.currentMode == 0 ? 1 : 100;
        if (btn == 0) {
            this.changeAmount(change);
        } else if (btn == 1) {
            this.changeAmount(change * -1);
        }
        amountButton.setValue(this.currentMode == 0 ? this.currentPriority : this.currentEnergyExtractAmt);
        amountButton.m_7435_(Minecraft.m_91087_().m_91106_());
    }

    public void setLimitExtract(NumberButton amountButton, int btn) {
        if (btn == 0) {
            this.changeLimitAmount(1);
        } else if (btn == 1) {
            this.changeLimitAmount(-1);
        }
        amountButton.setValue(this.showExtractLimit() ? this.currentExtractLimitPercent : this.currentInsertLimitPercent);
        amountButton.m_7435_(Minecraft.m_91087_().m_91106_());
    }

    public void saveSettings() {
        PacketHandler.sendToServer(new PacketUpdateCard(this.currentMode, this.currentChannel, this.currentEnergyExtractAmt, this.currentPriority, this.currentSneaky, (short)this.currentTicks, this.currentExact, this.currentRegulate, (byte)this.currentRoundRobin, this.currentExtractLimitPercent, this.currentInsertLimitPercent, this.currentRedstoneMode, this.currentRedstoneChannel, false));
    }

    public void openNode() {
        this.saveSettings();
        PacketHandler.sendToServer(new PacketOpenNode(this.container.sourceContainer, this.container.direction));
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
    }

    public boolean m_6375_(double x, double y, int btn) {
        ChannelButton channelButton = (ChannelButton)this.buttons.get("channel");
        if (MiscTools.inBounds(channelButton.f_93620_, channelButton.f_93621_, channelButton.m_5711_(), channelButton.m_93694_(), x, y)) {
            if (btn == 0) {
                this.currentChannel = BaseCard.nextChannel(this.card);
            } else if (btn == 1) {
                this.currentChannel = BaseCard.previousChannel(this.card);
            }
            channelButton.setChannel(this.currentChannel);
            channelButton.m_7435_(Minecraft.m_91087_().m_91106_());
            return true;
        }
        ToggleButton sneakyButton = (ToggleButton)this.buttons.get("sneaky");
        if (MiscTools.inBounds(sneakyButton.f_93620_, sneakyButton.f_93621_, sneakyButton.m_5711_(), sneakyButton.m_93694_(), x, y)) {
            if (btn == 0) {
                this.currentSneaky = BaseCard.nextSneaky(this.card);
                sneakyButton.setTexturePosition(this.currentSneaky + 1);
            } else if (btn == 1) {
                this.currentSneaky = BaseCard.previousSneaky(this.card);
                sneakyButton.setTexturePosition(this.currentSneaky + 1);
            }
            sneakyButton.m_7435_(Minecraft.m_91087_().m_91106_());
            return true;
        }
        ChannelButton redstoneChannelButton = (ChannelButton)this.buttons.get("redstoneChannel");
        if (MiscTools.inBounds(redstoneChannelButton.f_93620_, redstoneChannelButton.f_93621_, redstoneChannelButton.m_5711_(), redstoneChannelButton.m_93694_(), x, y)) {
            if (btn == 0) {
                this.currentRedstoneChannel = BaseCard.nextRedstoneChannel(this.card);
            } else if (btn == 1) {
                this.currentRedstoneChannel = BaseCard.previousRedstoneChannel(this.card);
            }
            redstoneChannelButton.setChannel(this.currentRedstoneChannel);
            redstoneChannelButton.m_7435_(Minecraft.m_91087_().m_91106_());
            return true;
        }
        NumberButton amountButton = (NumberButton)this.buttons.get("amount");
        if (MiscTools.inBounds(amountButton.f_93620_, amountButton.f_93621_, amountButton.m_5711_(), amountButton.m_93694_(), x, y)) {
            this.setExtract(amountButton, btn);
            return true;
        }
        NumberButton limitButton = (NumberButton)this.buttons.get("limit");
        if (MiscTools.inBounds(limitButton.f_93620_, limitButton.f_93621_, limitButton.m_5711_(), limitButton.m_93694_(), x, y)) {
            this.setLimitExtract(limitButton, btn);
            return true;
        }
        NumberButton speedButton = (NumberButton)this.buttons.get("speed");
        if (MiscTools.inBounds(speedButton.f_93620_, speedButton.f_93621_, speedButton.m_5711_(), speedButton.m_93694_(), x, y)) {
            if (btn == 0) {
                this.changeTick(1);
            } else if (btn == 1) {
                this.changeTick(-1);
            }
            speedButton.setValue(this.currentTicks);
            speedButton.m_7435_(Minecraft.m_91087_().m_91106_());
            return true;
        }
        return super.m_6375_(x, y, btn);
    }
}

