/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.plonk.client;

import com.breakinblocks.plonk.Plonk;
import com.breakinblocks.plonk.client.command.CommandClientPlonk;
import com.breakinblocks.plonk.client.registry.RegistryTESRs;
import com.breakinblocks.plonk.client.render.tile.TESRPlacedItems;
import com.breakinblocks.plonk.common.packet.PacketPlaceItem;
import com.breakinblocks.plonk.common.packet.PacketRotateTile;
import com.breakinblocks.plonk.common.registry.RegistryItems;
import com.breakinblocks.plonk.common.tile.TilePlacedItems;
import com.breakinblocks.plonk.common.util.EntityUtils;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class ClientEvents {
    public static final KeyMapping KEY_PLACE = new KeyMapping("key.plonk.place", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 80, "key.categories.plonk");

    public static void init(IEventBus modEventBus) {
        modEventBus.addListener(ClientEvents::setupClient);
        modEventBus.addListener(ClientEvents::onRegisterKeyMappings);
        MinecraftForge.EVENT_BUS.addListener(ClientEvents::onKeyInput);
        MinecraftForge.EVENT_BUS.addListener(ClientEvents::serverStarting);
    }

    public static void setupClient(FMLClientSetupEvent event) {
        RegistryTESRs.init();
    }

    public static void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        event.register(KEY_PLACE);
    }

    public static void onKeyInput(InputEvent.Key event) {
        HitResult hitRaw;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (mc.m_91265_() == null && (mc.f_91080_ == null || mc.f_91080_.f_96546_) && KEY_PLACE.m_90859_() && player != null && (hitRaw = mc.f_91077_) != null && hitRaw.m_6662_() == HitResult.Type.BLOCK) {
            BlockHitResult hit = (BlockHitResult)hitRaw;
            ItemStack held = player.m_21205_();
            if (!held.m_41619_()) {
                int renderType = TESRPlacedItems.getRenderTypeFromStack(held);
                ItemStack toPlace = new ItemStack((ItemLike)RegistryItems.placed_items, 1);
                RegistryItems.placed_items.setHeldStack(toPlace, held, renderType);
                EntityUtils.setHeldItemSilent((Player)player, InteractionHand.MAIN_HAND, toPlace);
                if (toPlace.m_41661_(new UseOnContext((Player)player, InteractionHand.MAIN_HAND, hit)).m_19077_()) {
                    Plonk.CHANNEL.sendToServer((Object)new PacketPlaceItem(hit, renderType));
                    ItemStack newHeld = RegistryItems.placed_items.getHeldStack(toPlace);
                    EntityUtils.setHeldItemSilent((Player)player, InteractionHand.MAIN_HAND, newHeld);
                } else {
                    EntityUtils.setHeldItemSilent((Player)player, InteractionHand.MAIN_HAND, held);
                }
            } else if (player.m_6144_() && !ClientEvents.rotatePlacedItemsTile(player.f_19853_, hit.m_82425_())) {
                ClientEvents.rotatePlacedItemsTile(player.f_19853_, hit.m_82425_().m_121945_(hit.m_82434_()));
            }
        }
    }

    private static boolean rotatePlacedItemsTile(Level world, BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof TilePlacedItems) {
            ((TilePlacedItems)te).rotateTile();
            Plonk.CHANNEL.sendToServer((Object)new PacketRotateTile(pos));
            return true;
        }
        return false;
    }

    public static void serverStarting(ServerStartingEvent event) {
        new CommandClientPlonk().register((CommandDispatcher<CommandSourceStack>)event.getServer().m_129892_().m_82094_());
    }
}

