/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.forge.screen.widget;

import brentmaas.buildguide.common.BuildGuide;
import brentmaas.buildguide.common.screen.widget.IShapeList;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.network.chat.Component;

public class ShapeListImpl
extends ObjectSelectionList<Entry>
implements IShapeList {
    private Runnable update;

    public ShapeListImpl(Minecraft minecraft, int left, int right, int top, int bottom, int slotHeight, Runnable update) {
        super(minecraft, right - left, bottom - top, top, bottom, slotHeight);
        this.f_93393_ = left;
        this.f_93392_ = right;
        this.m_93488_(false);
        this.m_93496_(false);
        this.update = update;
        for (int shapeId = 0; shapeId < BuildGuide.stateManager.getState().advancedModeShapes.size(); ++shapeId) {
            this.m_7085_((AbstractSelectionList.Entry)new Entry(shapeId));
            if (shapeId != BuildGuide.stateManager.getState().iAdvanced) continue;
            this.setSelected((Entry)this.m_6702_().get(this.m_6702_().size() - 1));
        }
    }

    @Override
    public void addEntry(int shapeId) {
        this.m_7085_((AbstractSelectionList.Entry)new Entry(shapeId));
        this.setSelected((Entry)this.m_6702_().get(shapeId));
    }

    public boolean removeEntry(Entry entry) {
        for (Entry e : this.m_6702_()) {
            if (e.getShapeId() <= entry.getShapeId()) continue;
            e.setShapeId(e.getShapeId() - 1);
        }
        if (this.m_6702_().size() > entry.getShapeId() + 1) {
            this.setSelected((Entry)this.m_6702_().get(entry.getShapeId() + 1));
        } else if (this.m_6702_().size() > 1) {
            this.setSelected((Entry)this.m_6702_().get(entry.getShapeId() - 1));
        }
        return super.m_93502_((AbstractSelectionList.Entry)entry);
    }

    @Override
    public boolean removeEntry(IShapeList.IEntry entry) {
        return this.removeEntry((Entry)entry);
    }

    public void setSelected(@Nullable Entry entry) {
        super.m_6987_((AbstractSelectionList.Entry)entry);
        if (entry != null) {
            BuildGuide.stateManager.getState().iAdvanced = entry.getShapeId();
        }
        this.update.run();
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        ShapeListImpl.m_93172_((PoseStack)poseStack, (int)this.f_93393_, (int)this.f_93390_, (int)this.f_93392_, (int)this.f_93391_, (int)0x33000000);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
    }

    protected void m_240140_(PoseStack poseStack, int top, int width, int height, int colourOuter, int colourInner) {
        int left = this.f_93393_ + (this.f_93388_ - width) / 2;
        int right = this.f_93393_ + (this.f_93388_ + width) / 2;
        this.boundedFill(poseStack, left, top - 2, right, top + height + 2, this.f_93393_, this.f_93390_, this.f_93392_, this.f_93391_, colourOuter);
        this.boundedFill(poseStack, left + 1, top - 1, right - 1, top + height + 1, this.f_93393_, this.f_93390_, this.f_93392_, this.f_93391_, colourInner);
    }

    private void boundedFill(PoseStack poseStack, int left, int top, int right, int bottom, int boundLeft, int boundTop, int boundRight, int boundBottom, int colour) {
        if (left < boundRight && top < boundBottom && right > boundLeft && bottom > boundTop) {
            ShapeListImpl.m_93172_((PoseStack)poseStack, (int)Math.max(left, boundLeft), (int)Math.max(top, boundTop), (int)Math.min(right, boundRight), (int)Math.min(bottom, boundBottom), (int)colour);
        }
    }

    public int m_5759_() {
        return this.f_93388_ - 12;
    }

    protected int m_5756_() {
        return this.f_93392_ - 6;
    }

    public final class Entry
    extends ObjectSelectionList.Entry<Entry>
    implements IShapeList.IEntry {
        private int shapeId;

        public Entry(int shapeId) {
            this.shapeId = shapeId;
        }

        public void m_6311_(PoseStack poseStack, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            Minecraft.m_91087_().f_91062_.m_92750_(poseStack, (BuildGuide.stateManager.getState().advancedModeShapes.get((int)this.shapeId).visible ? "" : "\u00a7m") + BuildGuide.stateManager.getState().advancedModeShapes.get(this.shapeId).getTranslatedName(), (float)(x + 5), (float)(y + 4), 0xFFFFFF);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            ShapeListImpl.this.setSelected(this);
            return false;
        }

        @Override
        public void setShapeId(int shapeId) {
            this.shapeId = shapeId;
        }

        @Override
        public int getShapeId() {
            return this.shapeId;
        }

        public Component m_142172_() {
            return Component.m_237113_((String)"");
        }
    }
}

